package com.dtyunxi.tcbj.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@ApiModel(value = "UpdateBillOrgDto", description = "修改计费组织传输对象")
public class UpdateBillOrgDto extends BaseVo {

    @NotEmpty
    @ApiModelProperty(name = "idList", value = "id集合")
    private List<Long> idList;

    @NotBlank
    @ApiModelProperty(name = "billingOrgCode", value = "计费组织编码")
    private String billingOrgCode;

    @NotBlank
    @ApiModelProperty(name = "billingOrgName", value = "计费组织名称")
    private String billingOrgName;

    @ApiModelProperty(name = "updatePerson", value = "更新人")
    private String updatePerson;

}