package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CountRelateNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryTimeLimitReqDto;
import com.dtyunxi.tcbj.api.dto.request.OutNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryInTransitQualifiedNoticeReqDto;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.dtyunxi.tcbj.api.dto.response.CountRelateNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryTimeLimitRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderDetailRespVo;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.vo.DatalargescreenDeliveryTimeVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 出库通知单服务接口
*
* @author wude
* @since 2022-03-10
*/
@Api(tags = {"出库通知单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/outNoticeOrder", url = "${tcbj.center.report.api:}")
public interface IOutNoticeOrderQueryApi {

    /**
    * 根据id查询出库通知单
    *
    * @param id 出库通知单id
    * @return   出库通知单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出库通知单", notes = "根据id查询出库通知单")
    RestResponse<OutNoticeOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 出库通知单分页数据
    *
    * @param filter   出库通知单查询条件
    * @return 出库通知单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "出库通知单分页数据", notes = "根据filter查询条件查询出库通知单数据，filter=OutNoticeOrderReqDto")
    RestResponse<PageInfo<OutNoticeOrderRespDto>> queryByPage(@RequestBody OutNoticeOrderReqDto filter);

    /**
     * 加载在途转合格相关出库通知单
     *
     *
     * @return 出库结果单分页数据
     */
    @PostMapping("/queryInTransitQualifiedNotice")
    @ApiOperation(value = "加载在途转合格相关出库通知单", notes = "加载在途转合格相关出库通知单")
    RestResponse<PageInfo<OutNoticeOrderDetailRespVo>> queryInTransitQualifiedNotice(@RequestBody QueryInTransitQualifiedNoticeReqDto reqDto);

    /**
     * 仓库发货时效统计
     * @param deliveryTimeLimitReqDto
     * @return
     */
    @PostMapping(value = {"/queryDeliveryTime"}, produces = {"application/json"})
    @ApiOperation(value = "仓库发货时效统计", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=DeliveryTimeLimitReqDto")
    RestResponse<PageInfo<DeliveryTimeLimitRespDto>> queryDeliveryTime(@RequestBody DeliveryTimeLimitReqDto deliveryTimeLimitReqDto);
    /**
     * 获取单据对应子单据
     *
     *
     * @return 出库结果单分页数据
     */
    @PostMapping("/countRelateNoticeOrder")
    @ApiOperation(value = "查询单据关联通知单数量", notes = "查询单据关联通知单数量")
    RestResponse<CountRelateNoticeOrderRespDto> countRelateNoticeOrder(@RequestBody CountRelateNoticeOrderReqDto reqDto);


    /**
     * 仓库发货时效统计-【数据大屏】
     * @return
     */
    @GetMapping("/queryDeliveryTimeExt")
    @ApiOperation(value = "仓库发货时效统计-【数据大屏】", notes = "-【数据大屏】")
    DatalargescreenDeliveryTimeVo queryDeliveryTimeExt(@RequestParam(value = "warehouseCode") String warehouseCode);

}
