package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumExceptionDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.sql.DataTruncation;
import java.util.Date;
import java.util.List;

/**
* 保费明细表服务接口
*
* @author lshaowu
* @since 2022-07-18
*/
@Api(tags = {"保费明细表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IReInsurancePremiumApi",
    name = "tcbj-center-report",
    path = "/v1/reInsurancePremium",
    url = "${tcbj.center.report.api:}"
)
public interface IReInsurancePremiumApi {

    /**
    * 新增保费明细表
    *
    * @param addReqDto 保费明细表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增保费明细表", notes = "新增保费明细表")
    RestResponse<Long> addReInsurancePremium(@RequestBody ReInsurancePremiumReqDto addReqDto);

    /**
    * 修改保费明细表
    *
    * @param modifyReqDto 保费明细表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改保费明细表", notes = "修改保费明细表")
    RestResponse<Void> modifyReInsurancePremium(@RequestBody ReInsurancePremiumReqDto modifyReqDto);

    /**
    * 删除保费明细表
    *
    * @param ids        保费明细表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除保费明细表", notes = "删除保费明细表")
    RestResponse<Void> removeReInsurancePremium(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    /**
    * 更新保费报表明细和账单异常数据
    *
    * @date 2022/7/19 16:03
    * @author lshaowu
    * @param exceptionDto 更新异常传入对象
    * @return 更新条数信息
    */
    @PostMapping("/updateException")
    @ApiOperation(value = "更新保费报表明细和账单异常数据",notes = "更新保费报表明细和账单异常数据")
    RestResponse<String> updateInsuranceExceptionReport(@RequestBody ReInsurancePremiumExceptionDto exceptionDto);

    @PostMapping("/updateInsuranceByLogistics")
    @ApiOperation(value = "更新保费账单",notes = "更新保费账单")
    RestResponse<String> updateInsuranceByLogistics(@RequestBody ReInsurancePremiumReportUpdateReqDto dto);

    @GetMapping("/generateInsuranceReport")
    @ApiOperation(value = "生成保费明细和账单报表",notes = "只需要一个日期即可，日期格式为yyyy-MM-dd HH:mm:ss")
    RestResponse<String> generateInsuranceReport(@RequestBody ReInsurancePremiumReqDto reqDto);

    @PostMapping("/updateBillOrg")
    @ApiOperation(value = "修改计费组织",notes = "修改计费组织")
    RestResponse<Void> updateBillOrg(@RequestBody ReInsurancePremiumReqDto reqDto);

    @PostMapping("/generateInsuranceReportImport")
    @ApiOperation(value = "导入生成保费明细和账单报表数据",notes = "导入生成保费明细和账单报表数据")
    RestResponse<Void> generateInsuranceReportImport(@RequestBody ReInsuranceBillReqDto billReqDto);

    @PostMapping("/getPcpItemByLongCode")
    @ApiOperation(value = "查询商品信息",notes = "查询商品信息")
    RestResponse<List<InsuranceItemVo>> getPcpItemByLongCode(@RequestBody List<String> longCodes);

    @PostMapping("/delByIds")
    @ApiOperation(value = "根据id删除保费费用",notes = "根据id删除保费费用")
    RestResponse<Void> delByIds(@RequestBody List<Long> ids);
}
