package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "LogisticsImportReqDto", description = "物流费报表对象")
public class LogisticsImportReqDto extends RequestDto {

    /**
     *  出库单号
     */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;

    /**
     *  计算方式
     */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private String chargeMode;

    /**
     *  送货费
     */
    @ApiModelProperty(name = "deliveryAmount", value = "送货费")
    private BigDecimal deliveryAmount;

    /**
     *  特殊费用类型
     */
    @ApiModelProperty(name = "specialType", value = "特殊费用类型")
    private String specialType;

    /**
     *  特殊费用
     */
    @ApiModelProperty(name = "specialAmount", value = "特殊费用")
    private BigDecimal specialAmount;

    /**
     *  运费合计
     */
    @ApiModelProperty(name = "totalTransportAmount", value = "运费合计")
    private BigDecimal totalTransportAmount;

    /**
     *  备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
}
