package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LargeBillsReqDto;
import com.dtyunxi.tcbj.api.dto.response.LargeBillsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author bixuan
 * @since 1.0.0
 */
@Api(tags = {"报表中心：大账单"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/largeBills",
        url = "${tcbj.center.report.api:}"
)
public interface ILargeBillsQueryApi {

    /**
     * 大账单列表查询
     *
     * @param reqDto
     */
    @PostMapping(value = {"/page"}, produces = "application/json")
    @ApiOperation(value = "大账单列表查询", notes = "大账单列表查询")
    RestResponse<PageInfo<LargeBillsRespDto>> page(@RequestBody LargeBillsReqDto reqDto);

    /**
     * 大账单列表历史数据修复
     *
     * @param date
     */
    @PostMapping(value = {"/fixDate"}, produces = "application/json")
    @ApiOperation(value = "大账单列表历史数据修复", notes = "大账单列表历史数据修复")
    RestResponse<Void> fixDate(@RequestParam(value = "date", required = false) String date);

}
