package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 库存报表对比Eo对象
*
* @author fengjian
* @since 2022-07-07
*/
@ApiModel(value = "InventoryComparisonReportReqDto", description = "库存报表对比Eo对象")
public class InventoryComparisonReportReqDto extends RequestDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  统计时间
    */
    @ApiModelProperty(name = "statisticsTime", value = "统计时间")
    private Date statisticsTime;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  逻辑仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓编码")
    private String warehouseCode;
    /**
    *  逻辑仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "逻辑仓名称")
    private String warehouseName;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  库存组织
    */
    @ApiModelProperty(name = "organizationName", value = "库存组织")
    private String organizationName;
    /**
    *  码拖数量
    */
    @ApiModelProperty(name = "trayNum", value = "码拖数量")
    private Long trayNum;
    /**
    *  pcp库存
    */
    @ApiModelProperty(name = "balance", value = "pcp库存")
    private BigDecimal balance;
    /**
    *  eas库存
    */
    @ApiModelProperty(name = "easNum", value = "eas库存")
    private BigDecimal easNum;
    /**
    *  wms库存
    */
    @ApiModelProperty(name = "wmsNum", value = "wms库存")
    private BigDecimal wmsNum;
    /**
    *  pcp_eas差异
    */
    @ApiModelProperty(name = "pcpEas", value = "pcp_eas差异")
    private BigDecimal pcpEas;
    /**
    *  pcp_wms差异
    */
    @ApiModelProperty(name = "pcpWms", value = "pcp_wms差异")
    private BigDecimal pcpWms;
    /**
    *  eas_wms差异
    */
    @ApiModelProperty(name = "easWms", value = "eas_wms差异")
    private BigDecimal easWms;
    /**
    *  是否存在差异 1:是,0:否;
    */
    @ApiModelProperty(name = "diff", value = "是否存在差异 1:是,0:否;")
    private Boolean diff;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setStatisticsTime(Date statisticsTime){
    this.statisticsTime = statisticsTime;
    }
    public Date getStatisticsTime(){
    return this.statisticsTime;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setTrayNum(Long trayNum){
    this.trayNum = trayNum;
    }
    public Long getTrayNum(){
    return this.trayNum;
    }
    public void setBalance(BigDecimal balance){
    this.balance = balance;
    }
    public BigDecimal getBalance(){
    return this.balance;
    }
    public void setEasNum(BigDecimal easNum){
    this.easNum = easNum;
    }
    public BigDecimal getEasNum(){
    return this.easNum;
    }
    public void setWmsNum(BigDecimal wmsNum){
    this.wmsNum = wmsNum;
    }
    public BigDecimal getWmsNum(){
    return this.wmsNum;
    }
    public void setPcpEas(BigDecimal pcpEas){
    this.pcpEas = pcpEas;
    }
    public BigDecimal getPcpEas(){
    return this.pcpEas;
    }
    public void setPcpWms(BigDecimal pcpWms){
    this.pcpWms = pcpWms;
    }
    public BigDecimal getPcpWms(){
    return this.pcpWms;
    }
    public void setEasWms(BigDecimal easWms){
    this.easWms = easWms;
    }
    public BigDecimal getEasWms(){
    return this.easWms;
    }
    public void setDiff(Boolean diff){
    this.diff = diff;
    }
    public Boolean getDiff(){
    return this.diff;
    }
}
