package com.dtyunxi.tcbj.api.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * <p>Tile </p>
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */
@Data
public class LogisticsInReportQueryDto implements Serializable {
    @ApiModelProperty(
            name = "pageSize",
            required = true,
            value = "分页大小"
    )
    private Integer pageSize;

    @ApiModelProperty(
            name = "pageNum",
            required = true,
            value = "当前页码"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "logisticsCompany",
            value = "物流公司"
    )
    private String logisticsCompany;
    @ApiModelProperty(
            name = "logisticsType",
            value = "承运方式"
    )
    private String logisticsType;
    @ApiModelProperty(
            name = "logisticsNo",
            value = "物流单号"
    )
    private String logisticsNo;
    @ApiModelProperty(
            name = "wmsNo",
            value = "WMS单号"
    )
    private String wmsNo;
    @ApiModelProperty(
            name = "businessType",
            value = "关联业务类型"
    )
    private String businessType;
    @ApiModelProperty(
            name = "businessOrderNo",
            value = "关联业务单号"
    )
    private String businessOrderNo;

    @ApiModelProperty(
            name = "status",
            value = "状态"
    )
    private String status;

    @ApiModelProperty(
            name = "createTimeStart",
            value = "创建时间开始"
    )
    private String createTimeStart;

    @ApiModelProperty(
            name = "createTimeEnd",
            value = "创建时间结束"
    )
    private String createTimeEnd;

    @ApiModelProperty(
            name = "overtimeFlag",
            value = "是否超时 0异常 1正常 2超时"
    )
    private String overtimeFlag;

    @ApiModelProperty(name = "orderNo" ,value = "单号")
    private String orderNo;
    @ApiModelProperty(name = "volumeLeft" ,value = "体积左值")
    private Double volumeLeft;
    @ApiModelProperty(name = "volumeRight" ,value = "体积右值")
    private Double volumeRight;
    @ApiModelProperty(name = "totalQuantityLeft" ,value = "重量左值")
    private Double totalQuantityLeft;
    @ApiModelProperty(name = "totalQuantityRight" ,value = "重量右值")
    private Double totalQuantityRight;
    @ApiModelProperty(name = "estimatedTimeStart" ,value = "预计到达时间开始")
    private String estimatedTimeStart;
    @ApiModelProperty(name = "estimatedTimeEnd" ,value = "预计到达时间结束")
    private String estimatedTimeEnd;
    @ApiModelProperty(name = "actualArrivalTimeStart" ,value = "实际到达时间开始")
    private String actualArrivalTimeStart;
    @ApiModelProperty(name = "actualArrivalTimeEnd" ,value = "实际到达时间结束")
    private String actualArrivalTimeEnd;

    @ApiModelProperty(name = "outPhysicsWarehouseName",value = "物理仓")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "shipmentEnterpriseType",value = "物流商类型 1-物流 2-快递")
    private Integer shipmentEnterpriseType;


    @ApiModelProperty(name = "consignmentNoList", value = "物流单号集合")
    private List<String> consignmentNoList;


    private List<String> logisticsCompanyList;

}
