package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 寻源策略Eo对象
 *
 * @author haoxiao
 * @since 2022-04-18
 */
@ApiModel(value = "ClueReportRespDto", description = "寻源策略Eo对象")
@Data
public class ClueReportRespDto extends BaseRespDto {
    /**
     *
     */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
     * 策略名
     */
    @ApiModelProperty(name = "clueName", value = "策略名")
    private String ruleName;
    /**
     * 策略编码
     */
    @ApiModelProperty(name = "clueCode", value = "策略编码")
    private String ruleCode;
    /**
     * 策略优先级
     */
    @ApiModelProperty(name = "rulePriority", value = "策略优先级")
    private Integer rulePriority;
    /**
     * 策略生效开始时间
     */
    @ApiModelProperty(name = "startTime", value = "策略生效开始时间")
    private Date startTime;
    /**
     * 策略生效结束时间
     */
    @ApiModelProperty(name = "endTime", value = "策略生效结束时间")
    private Date endTime;
    /**
     * 策略启用状态
     */
    @ApiModelProperty(name = "ruleStatus", value = "策略启用状态")
    private String ruleStatus;
    /**
     * 是否拆单
     */
    @ApiModelProperty(name = "isSplitOrder", value = "是否拆单")
    private String isSplitOrder;
    /**
     * 适用渠道名称集
     */
    @ApiModelProperty(name = "channelNames", value = "适用渠道名称集")
    private String channelNames;
}
