package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@Getter
@Setter
@ApiModel(value = "InventoryCheckReqDto", description = "库存校验对象")
public class InventoryCheckReqDto {

    @ApiModelProperty(name = "checkType", value = "1. 校验渠道仓供货仓库存 2. 校验逻辑仓 3.校验渠道仓供货仓库存并校验逻辑仓 ")
    @NotNull
    private CheckType checkType;

    @ApiModelProperty(name = "items", value = "校验类型")
    @NotEmpty
    private List<InventoryCheckItem> items;

    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码 外层传值优先")
    private String logicWarehouseCode;

    @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓编码 外层传值优先")
    private String channelWarehouseCode;


    public enum CheckType {
        /**
         *
         */
        CHANNEL(1, "校验渠道及供货"),
        LOGIC(2, "校验逻辑"),
        LOGIC_AND_CHANNEL(3, "校验逻辑,渠道及供货"),
        ;
        private final Integer type;
        private final String desc;

        CheckType(Integer type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public Integer getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }
    }

}
