package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOperateLogReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOperateLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 放行操作日志服务接口
*
* @author 紫霄
* @since 2023-05-09
*/
@Api(tags = {"放行操作日志服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IInspectionReleaseOperateLogApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/InspectionReleaseOperateLog",
    url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleaseOperateLogApi {

/**
* 新增放行操作日志
*
* @param addReqDto 放行操作日志请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增放行操作日志", notes = "新增放行操作日志")
RestResponse<Long> addInspectionReleaseOperateLog(@RequestBody InspectionReleaseOperateLogReqDto addReqDto);

    /**
    * 修改放行操作日志
    *
    * @param modifyReqDto 放行操作日志请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改放行操作日志", notes = "修改放行操作日志")
    RestResponse<Void> modifyInspectionReleaseOperateLog(@RequestBody InspectionReleaseOperateLogReqDto modifyReqDto);

    /**
    * 删除放行操作日志
    *
    * @param ids        放行操作日志删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除放行操作日志", notes = "删除放行操作日志")
    RestResponse<Void> removeInspectionReleaseOperateLog(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
