package com.dtyunxi.tcbj.api.dto.constant.enums;

public enum CsWarehouseTypeEnum {
    PRODUCT_WAREHOUSE("0", "产品仓"),
    RETURN_WAREHOUSE("1", "退货仓"),
    OTHER_WAREHOUSE("2", "其他仓"),
    TCBJ_B("3","TCBJ-B仓"),
    TCBJ_C("4","TCBJ-C仓");

    CsWarehouseTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(String code) {
        for (CsWarehouseTypeEnum value : CsWarehouseTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return null;
    }
}