package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ConsignmentOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 运单服务接口
*
* @author 紫霄
* @since 2023-05-09
*/
@Api(tags = {"运单服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IConsignmentOrderApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/consignmentOrder",
    url = "${tcbj.center.report.api:}"
)
public interface IConsignmentOrderApi {

/**
* 新增运单
*
* @param addReqDto 运单请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增运单", notes = "新增运单")
RestResponse<Long> addConsignmentOrder(@RequestBody ConsignmentOrderReqDto addReqDto);

    /**
    * 修改运单
    *
    * @param modifyReqDto 运单请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改运单", notes = "修改运单")
    RestResponse<Void> modifyConsignmentOrder(@RequestBody ConsignmentOrderReqDto modifyReqDto);

    /**
    * 删除运单
    *
    * @param ids        运单删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除运单", notes = "删除运单")
    RestResponse<Void> removeConsignmentOrder(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
