package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FinLogisticReportReqDto", description = "物流运费合计记录Dto对象")
public class FinLogisticReportReqDto extends BaseDto {

    @ApiModelProperty(name = "id", value = "ID")
    private String id;

    @ApiModelProperty(name = "parentId", value = "父类id")
    private Long parentId;

    @ApiModelProperty(name = "type", value = "单据类型")
    private Integer type;

    @ApiModelProperty(name = "outboundStartTime", value = "出库开始时间")
    private String outboundStartTime;

    @ApiModelProperty(name = "outboundTimeEndTime", value = "出库结束时间")
    private String outboundTimeEndTime;

    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;

    @ApiModelProperty(name = "outNoticeCode", value = "出库通知单号")
    private String outNoticeCode;
    /**
     *  wms出库单号
     */
    @ApiModelProperty(name = "wmsOutboundCode", value = "wms出库单号")
    private String wmsOutboundCode;
    /**
     *  关联业务单号
     */
    @ApiModelProperty(name = "businessCode", value = "关联业务单号")
    private String businessCode;
    /**
     *  物流公司ID
     */
    @ApiModelProperty(name = "logisticId", value = "物流公司ID")
    private String logisticId;
    /**
     *  物流公司
     */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;
    /**
     *  仓库id
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库id")
    private String warehouseId;
    /**
     *  仓库
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库")
    private String warehouseName;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
     *  计算方式
     */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private String chargeMode;
    /**
     *  托运单号
     */
    @ApiModelProperty(name = "transportCode", value = "托运单号")
    private String transportCode;
    @ApiModelProperty(name = "transportCodeList", value = "托运单号集合")
    private List<String> transportCodeList;
    /**
     *  调出仓库
     */
    @ApiModelProperty(name = "warehouseOut", value = "调出仓库")
    private String warehouseOut;
    /**
     *  调出组织
     */
    @ApiModelProperty(name = "organizationOut", value = "调出组织")
    private String organizationOut;
    /**
     *  调入仓库
     */
    @ApiModelProperty(name = "warehouseEnter", value = "调入仓库")
    private String warehouseEnter;
    /**
     *  调入组织
     */
    @ApiModelProperty(name = "organizationEnter", value = "调入组织")
    private String organizationEnter;

    /**
     *  省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    /**
     *  所属省份Code
     */
    @ApiModelProperty(name="provinceCode", value = "所属省份Code")
    private String provinceCode;
    /**
     *  城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    private String cityCode;
    /**
     *  区域
     */
    @ApiModelProperty(name = "area", value = "区域")
    private String area;
    private String areaCode;

    /**
     *  状态（0=正常 1=异常）
     */
    @ApiModelProperty(name = "status", value = "状态（0=正常 1=异常）")
    private Integer status;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;

    private String warehouseEnterCode;
    private String warehouseOutCode;
    private String logisticCompanyCode;
    private String amountAttribution;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    /**
     * 记账日期
     */
    @ApiModelProperty(name = "bookkeepingDate", value = "记账日期")
    private String bookkeepingDate;
    /**
     * 城市级别
     */
    @ApiModelProperty(name = "cityLevel", value = "城市级别")
    private String cityLevel;

    @ApiModelProperty(name = "easNo", value = "EAS订单号")
    private String easNo;

    @ApiModelProperty(name = "transportNo", value = "承运单号")
    private String transportNo;

    @ApiModelProperty(name = "transportNoList", value = "承运单号集合")
    private List<String> transportNoList;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    private List<String> outPhysicsWarehouseNameList;
    private List<String> outPhysicsWarehouseCodeList;
    
    /**
     * 批量查询字段
     */
    @ApiModelProperty(name = "transportTypeList", value = "承运方式列表")
    private List<String> transportTypeList;
    
    @ApiModelProperty(name = "organizationOutList", value = "调出组织列表")
    private List<String> organizationOutList;
    
    @ApiModelProperty(name = "amountAttributionList", value = "费用归属列表")
    private List<String> amountAttributionList;
    
    @ApiModelProperty(name = "organizationEnterList", value = "调入组织列表")
    private List<String> organizationEnterList;
    
    @ApiModelProperty(name = "warehouseOutCodeList", value = "调出仓库编码列表")
    private List<String> warehouseOutCodeList;
    
    @ApiModelProperty(name = "warehouseEnterCodeList", value = "调入仓库编码列表")
    private List<String> warehouseEnterCodeList;
    
    @ApiModelProperty(name = "businessTypeList", value = "业务类型列表")
    private List<String> businessTypeList;
    
    @ApiModelProperty(name = "warehouseNameList", value = "出库物理仓列表")
    private List<String> warehouseNameList;

    @ApiModelProperty(name = "logisticCompanyCodeList", value = "物流公司编码集合")
    private List<String> logisticCompanyCodeList;
}
