package com.dtyunxi.tcbj.api.dto.response;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
/**
 * 映射打印出库单模板字段
 */
public class GiftPackageInfoExtDto {

    /**
     *  ID主键
     */
    @ApiModelProperty(name = "id", value = "ID主键")
    private Long id;
    /**
     *  第三方ID
     */
    @ApiModelProperty(name = "gid", value = "第三方ID")
    private String gid;
    /**
     *  订单号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;
    /**
     *  礼盒编码
     */
    @ApiModelProperty(name = "proNo", value = "礼盒编码")
    private String proNo;
    /**
     *  礼盒名称
     */
    @ApiModelProperty(name = "proName", value = "礼盒名称")
    private String proName;
    /**
     *  礼盒批次
     */
    @ApiModelProperty(name = "lot", value = "礼盒批次")
    private String lot;
    /**
     *  生产日期（子产品）
     */
    @ApiModelProperty(name = "productDate", value = "生产日期（子产品）")
    private String productDate;
    /**
     *  到期日期（子产品）
     */
    @ApiModelProperty(name = "expireDate", value = "到期日期（子产品）")
    private String expireDate;
    /**
     *  子产品编码
     */
    @ApiModelProperty(name = "subProNo", value = "子产品编码")
    private String subProNo;
    /**
     *  子产品名称
     */
    @ApiModelProperty(name = "subProName", value = "子产品名称")
    private String subProName;
    /**
     *  子产品批次
     */
    @ApiModelProperty(name = "subLot", value = "子产品批次")
    private String subLot;
    /**
     *  礼盒生产日期
     */
    @ApiModelProperty(name = "subProductDate", value = "礼盒生产日期")
    private String subProductDate;
    /**
     *  礼盒到期日期
     */
    @ApiModelProperty(name = "subExpireDate", value = "礼盒到期日期")
    private String subExpireDate;
    /**
     *  子产品排序
     */
    @ApiModelProperty(name = "sort", value = "子产品排序")
    private Integer sort;
    /**
     *  状态标识（1:可用 2:禁用）
     */
    @ApiModelProperty(name = "flag", value = "状态标识（1:可用 2:禁用）")
    private String flag;
    /**
     *  第三方创建时间
     */
    @ApiModelProperty(name = "extCreateTime", value = "第三方创建时间")
    private String extCreateTime;

    @ApiModelProperty(name = "proNoList", value = "礼盒编码集合")
    private List<String> proNoList;

    @ApiModelProperty(name = "lotList", value = "礼盒批次集合")
    private List<String> lotList;
}
