/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CombinedPackageActivityReqDto;
import com.dtyunxi.tcbj.api.dto.response.CombinedPackageActivityItemRespDto;
import com.dtyunxi.tcbj.api.dto.response.CombinedPackageActivityRespDto;
import com.dtyunxi.tcbj.api.dto.trolley.TrolleyItemRespDto;
import com.dtyunxi.tcbj.biz.service.ICombinedPackageActivityService;
import com.dtyunxi.tcbj.dao.das.ActivityDas;
import com.dtyunxi.tcbj.dao.vo.ItemMediasVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.TargetCustomerReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CombinedPackageActivityServiceImpl
implements ICombinedPackageActivityService {
    private static Logger logger = LoggerFactory.getLogger(CombinedPackageActivityServiceImpl.class);
    @Resource
    private ActivityDas activityDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Autowired
    private ICustomerAuthItemQueryApi customerAuthItemQueryApi;

    @Override
    public PageInfo<CombinedPackageActivityRespDto> queryCombinedPackageActivity(CombinedPackageActivityReqDto req) {
        String userSerial;
        PageInfo pageInfo = new PageInfo();
        List customerRespDtos = Lists.newArrayList();
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(customerId))));
            userSerial = String.valueOf(((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId());
            logger.info("\u6839\u636e\u5ba2\u6237id\u83b7\u53d6orgInfoId\uff1a{}", (Object)userSerial);
        } else {
            logger.info("h5\u7aef");
            HashSet<Long> shopIds = new HashSet<Long>();
            shopIds.add(req.getShopId());
            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
            ArrayList merchantIds = Lists.newArrayList();
            Iterator iterator = shopDtos.iterator();
            while (iterator.hasNext()) {
                ShopDto shopDto = (ShopDto)iterator.next();
                merchantIds.add(shopDto.getOrganizationId());
            }
            Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
            if (orgId == null) {
                throw new BizException("-1", "\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            }
            userSerial = String.valueOf(orgId);
            logger.info("yes.req.cus.b2b.organizationid,{}", (Object)orgId);
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, Long.valueOf(orgId)));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                throw new BizException("-1", "\u5ba2\u6237\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
        }
        ArrayList customerIdList = Lists.newArrayList();
        for (CustomerRespDto customerRespDto : customerRespDtos) {
            customerIdList.add(customerRespDto.getId());
        }
        req.setCustomerIds(customerIdList.stream().map(Object::toString).collect(Collectors.joining(",")));
        req.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        req.setActivityTemplateId(Long.valueOf(ActivityType.COMBINATION_ACTIVITY.getId()));
        req.setConditionTemplateId(Long.valueOf(1196944223312880296L));
        List activityIds = this.activityDas.queryActivityIdsByItemId(req);
        if (CollectionUtils.isEmpty((Collection)activityIds)) {
            return pageInfo;
        }
        List<Long> targetActivityIds = this.getActivityIdList((CustomerRespDto)customerRespDtos.get(0), activityIds);
        logger.info("\u76ee\u6807\u7528\u6237\u6d3b\u52a8ids\uff0c{}", targetActivityIds);
        if (CollectionUtils.isEmpty(targetActivityIds)) {
            return pageInfo;
        }
        req.setActivityIds(targetActivityIds);
        CustomerAuthItemPageReqDto customerAuthItemPageReqDto = new CustomerAuthItemPageReqDto();
        customerAuthItemPageReqDto.setCustomerId((Long)customerIdList.get(0));
        customerAuthItemPageReqDto.setNeedLimit(Integer.valueOf(2));
        customerAuthItemPageReqDto.setProhibiteStatus(Integer.valueOf(1));
        customerAuthItemPageReqDto.setShopId(req.getShopId());
        PageInfo authItemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerAuthItemQueryApi.queryAuthItemPage(customerAuthItemPageReqDto));
        if (authItemRespDtoPageInfo == null || CollectionUtils.isEmpty((Collection)authItemRespDtoPageInfo.getList())) {
            logger.info("[\u6388\u6743\u5546\u54c1]\uff0c\u5f53\u524d\u5ba2\u6237\u672a\u6388\u6743\u5546\u54c1\uff1a{}", (Object)customerIdList);
            return pageInfo;
        }
        List authSkuIds = authItemRespDtoPageInfo.getList().stream().map(CustomerAuthItemRespDto::getSkuId).distinct().collect(Collectors.toList());
        req.setAuthItemSkuIds(authSkuIds);
        pageInfo = this.activityDas.queryCombinedPackageActivity(req);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        List activityIdList = pageInfo.getList().stream().map(e -> e.getActivityId()).collect(Collectors.toList());
        TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
        tcbjInventoryActReqDto.setActivityIdList(activityIdList);
        List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
        HashMap inventoryActDetailMap = CollectionUtils.isNotEmpty((Collection)tcbjInventoryActRespDtos) ? tcbjInventoryActRespDtos.stream().collect(Collectors.toMap(TcbjInventoryActRespDto::getActivityId, TcbjInventoryActRespDto::getDetailRespDtoList)) : new HashMap();
        logger.info("\u7ec4\u5408\u5957\u88c5\u6d3b\u52a8\u5546\u54c1\uff0c\u5e93\u5b58\u67e5\u8be2,{}", (Object)JSONObject.toJSONString((Object)tcbjInventoryActRespDtos));
        List trolleyItemRespDtos = this.activityDas.queryTrolleyItemRespDtoList(activityIdList, userSerial);
        HashMap trolleyItemMap = CollectionUtils.isNotEmpty((Collection)trolleyItemRespDtos) ? trolleyItemRespDtos.stream().collect(Collectors.toMap(TrolleyItemRespDto::getItemSerial, e -> e, (a1, a2) -> a2)) : new HashMap();
        List combinedPackageActivityItem = this.activityDas.queryCombinedPackageActivityItem(activityIdList, (Long)customerIdList.get(0));
        if (CollectionUtils.isEmpty((Collection)combinedPackageActivityItem)) {
            return pageInfo;
        }
        Map<Object, Object> itemMediasMap = Maps.newHashMap();
        List itemIds = combinedPackageActivityItem.stream().map(CombinedPackageActivityItemRespDto::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            List itemMediasVos = this.activityDas.queryItemMediasByItemIds(itemIds);
            itemMediasMap = itemMediasVos.stream().collect(Collectors.toMap(ItemMediasVo::getItemId, e -> e.getPicture(), (e1, e2) -> e1));
        }
        HashMap map = Maps.newHashMap();
        for (CombinedPackageActivityItemRespDto dto : combinedPackageActivityItem) {
            dto.setPicture((String)itemMediasMap.get(dto.getItemId()));
            map.computeIfAbsent(dto.getActivityId(), k -> Lists.newArrayList()).add(dto);
        }
        for (CombinedPackageActivityItemRespDto dto : pageInfo.getList()) {
            BigDecimal activitySurplus;
            List combinedPackageActivityItemRespDtos = (List)map.get(dto.getActivityId());
            List tcbjInventoryActDetailRespDtos = null;
            if (inventoryActDetailMap.get(dto.getActivityId()) != null) {
                tcbjInventoryActDetailRespDtos = (List)inventoryActDetailMap.get(dto.getActivityId());
            }
            long stock = 0L;
            if (tcbjInventoryActDetailRespDtos != null && (activitySurplus = tcbjInventoryActDetailRespDtos.stream().filter(e -> e.getCargoCode().equals(((CombinedPackageActivityItemRespDto)combinedPackageActivityItemRespDtos.get(0)).getSkuCode())).map(TcbjInventoryActDetailRespDto::getActivitySurplus).reduce(BigDecimal.ZERO, BigDecimal::add)).intValue() > 0) {
                stock = activitySurplus.divide(new BigDecimal(((CombinedPackageActivityItemRespDto)combinedPackageActivityItemRespDtos.get(0)).getNum()), RoundingMode.CEILING).longValue();
            }
            this.parse((CombinedPackageActivityRespDto)dto);
            dto.setRemainingStock(Long.valueOf(stock));
            TrolleyItemRespDto trolleyItemRespDto = (TrolleyItemRespDto)trolleyItemMap.get(dto.getActivityId());
            if (trolleyItemMap.get(dto.getActivityId()) != null) {
                dto.setShoppingCartItemNum(trolleyItemRespDto.getItemNum());
                dto.setShoppingCartItemId(trolleyItemRespDto.getId());
            }
            dto.setActivityItemRespDtos(combinedPackageActivityItemRespDtos);
        }
        pageInfo.getList().stream().sorted(Comparator.comparing(CombinedPackageActivityRespDto::getRemainingStock).reversed()).collect(Collectors.toList());
        return pageInfo;
    }

    private List<Long> getActivityIdList(CustomerRespDto customerRespDto, List<Long> activityIds) {
        TargetCustomerReqDto dto = new TargetCustomerReqDto();
        CustomerReqDto customerReqDto = (CustomerReqDto)BeanUtil.copyProperties((Object)customerRespDto, CustomerReqDto.class, (String[])new String[0]);
        dto.setCustomerInfo(customerReqDto);
        dto.setActivityIds(activityIds);
        logger.info("\u6821\u9a8c\u76ee\u6807\u5ba2\u6237,{}", (Object)JSONObject.toJSONString((Object)customerReqDto));
        return (List)this.itemActivityStockApi.validateTargetCustomersAndMallType(dto).getData();
    }

    private void parse(CombinedPackageActivityRespDto dto) {
        JSONObject jsonObject = JSON.parseObject((String)dto.getConditionParams());
        CombinationRule combinationRule = (CombinationRule)JSON.parseObject((String)jsonObject.getString("CombinationCondition.rule"), CombinationRule.class);
        dto.setThresholdType(combinationRule.getThresholdType());
        dto.setPromotionType(combinationRule.getPromotionType());
        ComRuleContentDto contents = combinationRule.getComRuleContent();
        if (Objects.nonNull(contents)) {
            dto.setPackagePrice(contents.getTotalPrice());
        }
    }
}

