/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.RelationDealReqDto;
import com.dtyunxi.tcbj.biz.enums.ProviceCityConstant;
import com.dtyunxi.tcbj.biz.service.IRelationDealService;
import com.dtyunxi.tcbj.biz.utils.StringMatchUtils;
import com.dtyunxi.tcbj.dao.das.ReCompareCusStoreRealDas;
import com.dtyunxi.tcbj.dao.eo.ReCompareCusStoreRealEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RalationDealServiceImpl
implements IRelationDealService {
    private static final Logger logger = LoggerFactory.getLogger(RalationDealServiceImpl.class);
    @Resource
    private ReCompareCusStoreRealDas compareCusStoreRealDas;

    @Override
    public String genCusStoreCompRela(RelationDealReqDto reqDto) {
        int numThreads = 4;
        ExecutorService threadPool = RalationDealServiceImpl.createThreadPool(numThreads);
        ReCompareCusStoreRealEo realSearchEo = new ReCompareCusStoreRealEo();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrgIdList())) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"merchant_id", (Object)reqDto.getOrgIdList()));
            realSearchEo.setSqlFilters(filters);
        }
        int i = 1;
        while (i <= numThreads) {
            int finalI = i++;
            threadPool.execute(() -> {
                Integer pageNum = finalI;
                List<ReCompareCusStoreRealEo> realEoList = this.getList(realSearchEo, pageNum);
                ArrayList upEoList = new ArrayList();
                ReCompareCusStoreRealEo upEo = null;
                String storeNameDeal = null;
                String customrNameDeal = null;
                while (CollectionUtils.isNotEmpty(realEoList)) {
                    pageNum = pageNum + numThreads;
                    for (ReCompareCusStoreRealEo eo : realEoList) {
                        try {
                            storeNameDeal = RalationDealServiceImpl.remove(eo.getStoreName(), reqDto);
                            customrNameDeal = RalationDealServiceImpl.remove(eo.getCustomerName(), reqDto);
                            upEo = new ReCompareCusStoreRealEo();
                            upEo.setId(eo.getId());
                            upEo.setNameMatchRate(Math.round(100.0 * StringMatchUtils.pickAlgorithm(storeNameDeal, customrNameDeal, null)) + "%");
                            ProviceCityConstant.compareArea(eo, upEo);
                            upEo.setStoreNameDeal(storeNameDeal);
                            upEo.setCustomerNameDeal(customrNameDeal);
                            this.compareCusStoreRealDas.updateSelective((BaseEo)upEo);
                        }
                        catch (Exception e) {
                            logger.error("\u3010\u5b57\u7b26\u4e32\u5339\u914d\u3011\u7b97\u6cd5\u8ba1\u7b97\u5f02\u5e38");
                            e.printStackTrace();
                        }
                    }
                    realEoList = this.getList(realSearchEo, pageNum);
                }
            });
        }
        threadPool.shutdown();
        return "\u66f4\u65b0\u8fdb\u884c\u4e2d\uff0c\u8bf7\u67e5\u770b\u6570\u636e\u5e93\u975e\u7a7a\u8868\u793a\u6267\u884c\u5b8c\u6bd5";
    }

    private List<ReCompareCusStoreRealEo> getList(ReCompareCusStoreRealEo realSearchEo, Integer pageNum) {
        return this.compareCusStoreRealDas.selectLimitSizeWithColumn((BaseEo)realSearchEo, pageNum, Integer.valueOf(2000), new String[]{"id", "store_name", "store_province", "store_city", "store_county", "customer_name", "customer_province", "customer_city", "customer_county"});
    }

    public static String remove(String str, RelationDealReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (!(str.contains("(") || str.contains(")") || str.contains("\uff08") || str.contains("\uff09"))) {
            return ProviceCityConstant.replaceAreaHeader(str, reqDto);
        }
        StringBuilder sb = new StringBuilder();
        int count1 = 0;
        for (char c : str.toCharArray()) {
            if (c == '(' || c == '\uff08') {
                ++count1;
                continue;
            }
            if (c == ')' || c == '\uff09') {
                --count1;
                continue;
            }
            if (count1 != 0) continue;
            sb.append(c);
        }
        return ProviceCityConstant.replaceAreaHeader(sb.toString(), reqDto);
    }

    public static ExecutorService createThreadPool(int numThreads) {
        return new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public String reCompareCusStoreRealAuto(RelationDealReqDto reqDto) {
        long startTime = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: ----start");
        if (BeanUtil.isEmpty((Object)reqDto, (String[])new String[0])) {
            reqDto = this.getCompareCusStoreRealDefaultParam(reqDto);
        }
        long startTime1 = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: step1 truncate table. --start");
        this.compareCusStoreRealDas.compareCusStoreRealTruncate();
        long endTime1 = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: step1 truncate table. --end. use time: {}", (Object)(endTime1 - startTime1 + "ms"));
        long startTime2 = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: step2 insert. --start");
        this.compareCusStoreRealDas.compareCusStoreRealInsert();
        long endTime2 = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: step2 insert. --end. use time: {}", (Object)(endTime2 - startTime2 + "ms"));
        long startTime3 = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: step3 genCusStoreCompRela. --start \u8be5\u4efb\u52a1\u4e3a\u5f02\u6b65\uff0c\u4e3b\u7ebf\u7a0bend\u4e0d\u4ee3\u8868\u4efb\u52a1\u8dd1\u5b8c");
        this.genCusStoreCompRela(reqDto);
        long endTime3 = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: step3 genCusStoreCompRela. --end. use time: {}", (Object)(endTime3 - startTime3 + "ms"));
        long endTime = new Date().getTime();
        logger.info("\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8: ----end total time: {}", (Object)(endTime - startTime + "ms"));
        return "\u5ba2\u6237\u548c\u95e8\u5e97\u771f\u5b9e\u6027\u7edf\u8ba1-\u81ea\u52a8 \u5904\u7406\u5b8c\u6210\uff0c\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "ms. \u5176\u4e2d\uff1a\r\nstep1 truncate table. \u8017\u65f6" + (endTime1 - startTime1) + "ms.\r\nstep2 insert. \u8017\u65f6" + (endTime2 - startTime2) + "ms.\r\nstep3 genCusStoreCompRela(\u5f02\u6b65). \u8017\u65f6" + (endTime3 - startTime3) + "ms";
    }

    private RelationDealReqDto getCompareCusStoreRealDefaultParam(RelationDealReqDto reqDto) {
        String defaultParamStr = "{\n   \n    \"excludeMap\": {\n        \"\u533a\": [\"\u897f\u533a\",\"\u793e\u533a\",\"\u5c0f\u533a\",\"\u6587\u5723\u533a\",\"\u7231\u6c11\u533a\",\"\u65b0\u533a\",\"\u6821\u533a\",\"\u533a\u5e97\"],\n        \"\u53bf\": [\"\u4e50\u4ead\"],\n        \"\u5e02\": [\"\u5e02\u573a\",\"\u8d85\u5e02\",\"\u95e8\u5e02\",\"\u65b0\u5e02\",\"\u5e02\u59d4\"],\n        \"\u5dde\": null,\n        \"\u7701\": null\n    },\n    \"supplyReplaceList\":[\"\u6709\u9650\",\"\u8d23\u4efb\",\"\u516c\u53f8\",\"\u8fde\u9501\",\"\u96f6\u552e\",\"\u4e50\u4ead\u53bf\",\"\u4e50\u4ead\",\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"A\",\"B\",\"C\",\"D\",\"E\",\"F\",\"G\",\"H\",\"I\",\"J\",\"K\",\"L\",\"M\",\"N\",\"O\",\"P\",\"Q\",\"R\",\"S\",\"T\",\"U\",\"V\",\"W\",\"X\",\"Y\",\"Z\"]\n}";
        return (RelationDealReqDto)JSON.parseObject((String)defaultParamStr, RelationDealReqDto.class);
    }
}

