/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.response.CompanySimpleInfoDto;
import com.dtyunxi.tcbj.api.dto.response.OrganizationInfoExtTemporaryDto;
import com.dtyunxi.tcbj.biz.service.IUserExtV2Service;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.OrganizationDas;
import com.dtyunxi.tcbj.dao.das.UserDas;
import com.dtyunxi.tcbj.dao.eo.OrganizationEo;
import com.dtyunxi.tcbj.dao.eo.OrganizationInfoEo;
import com.dtyunxi.tcbj.dao.mapper.OrganizationInfoMapper;
import com.dtyunxi.tcbj.dao.mapper.OrganizationMapper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserExtV2ServiceImpl
implements IUserExtV2Service {
    private static final Logger logger = LoggerFactory.getLogger(UserExtV2ServiceImpl.class);
    @Resource
    private UserDas userDas;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private OrganizationInfoMapper organizationInfoMapper;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private CsCustomerDas csCustomerDas;

    @Override
    public List<Long> queryUserByName(String name) {
        return this.userDas.queryUserByName(name);
    }

    @Override
    public List<OrganizationInfoExtTemporaryDto> queryOrgInfoByOrgId(List<Long> orgIdList) {
        QueryWrapper orgEo = new QueryWrapper();
        orgEo.in((Object)"id", orgIdList);
        orgEo.eq((Object)"dr", (Object)0);
        List organizationEos = this.organizationMapper.selectList((Wrapper)orgEo);
        if (CollectionUtils.isEmpty((Collection)organizationEos)) {
            return Lists.newArrayList();
        }
        Map orgMap = organizationEos.stream().collect(Collectors.toMap(OrganizationEo::getCode, Function.identity()));
        List orgCodeList = organizationEos.stream().map(OrganizationEo::getCode).distinct().collect(Collectors.toList());
        QueryWrapper orgInfoEo = new QueryWrapper();
        orgInfoEo.in((Object)"org_code", orgCodeList);
        orgInfoEo.eq((Object)"dr", (Object)0);
        List orgInfoList = this.organizationInfoMapper.selectList((Wrapper)orgInfoEo);
        if (CollectionUtils.isEmpty((Collection)orgInfoList)) {
            return Lists.newArrayList();
        }
        Map orgInfoMap = orgInfoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)orgInfoList, OrganizationInfoExtTemporaryDto.class);
        for (OrganizationInfoExtTemporaryDto infoExtDto : dtoList) {
            OrganizationInfoEo infoEo;
            if (!orgMap.isEmpty() && orgMap.containsKey(infoExtDto.getOrgCode())) {
                infoExtDto.setOrgId(((OrganizationEo)orgMap.get(infoExtDto.getOrgCode())).getId());
            }
            if (!ObjectUtils.isNotEmpty((Object)(infoEo = (OrganizationInfoEo)orgInfoMap.get(infoExtDto.getId())).getBusinessTermType())) continue;
            infoExtDto.setBusinessTermType(String.valueOf(infoEo.getBusinessTermType()));
        }
        return dtoList;
    }

    @Override
    public List<OrganizationDto> getOrgInfoByUserId(Long userId) {
        List orgIdList = this.userDas.getEmployeeOrgIdByUserId(userId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgIdList)) {
            logger.info("\u7528\u6237id[{}]\u67e5\u8be2\u7ec4\u7ec7id\u4e3a\u7a7a", (Object)userId);
            return Lists.newArrayList();
        }
        ArrayList orgList = Lists.newArrayList();
        List orgEoList = this.organizationDas.findByIds(orgIdList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgEoList)) {
            return orgList;
        }
        CubeBeanUtils.copyCollection((Collection)orgList, (Collection)orgEoList, OrganizationDto.class);
        List csCustomerList = this.csCustomerDas.getCustomerByOrgInfoIds(orgIdList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)csCustomerList)) {
            return orgList;
        }
        Map<Long, String> nameMap = csCustomerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, CustomerRespDto::getName, (e1, e2) -> e1));
        for (OrganizationDto orgDto : orgList) {
            if (!StringUtils.isNotBlank((String)nameMap.get(orgDto.getId()))) continue;
            orgDto.setName(nameMap.get(orgDto.getId()));
        }
        return orgList;
    }

    @Override
    public Map<Long, CompanySimpleInfoDto> queryCompanyNameByCusId(List<Long> cusIdList) {
        List list;
        Map<Long, Object> compMap = null;
        compMap = CollectionUtils.isNotEmpty(cusIdList) ? (CollectionUtils.isNotEmpty((Collection)(list = this.organizationInfoMapper.queryCompanyNameByCusId(cusIdList))) ? list.stream().collect(Collectors.toMap(e -> e.getCustomerId(), e -> e, (e1, e2) -> e1)) : new HashMap()) : new HashMap<Long, CompanySimpleInfoDto>();
        return compMap;
    }
}

