/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.biz.config.ApiNoticeConfig;
import com.dtyunxi.tcbj.biz.service.ICustomerSalesmanService;
import com.dtyunxi.tcbj.biz.service.ICustomerUserExpireDateService;
import com.dtyunxi.tcbj.biz.utils.DingdingSender;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.EmployeeDas;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.vo.ExpireEmployeeRespVo;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerUserExpireDateServiceImpl
implements ICustomerUserExpireDateService {
    private static Logger logger = LoggerFactory.getLogger(CustomerUserExpireDateServiceImpl.class);
    private static final Long CUSTOMER_STATUS_ID_EXPIRE = 1256288052502004816L;
    private static Integer limitCount = 1000;
    @Resource
    private CsCustomerDas customerDas;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private EmployeeDas employeeDas;
    @Resource
    private ICustomerSalesmanService customerSalesmanService;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ApiNoticeConfig apiNoticeConfig;

    @Override
    public void expireDate() {
        Date curDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = format.format(curDate);
        try {
            List expireCustomerList;
            List expireEmployeeList = this.employeeDas.getExpiredEmployeeInfo();
            logger.info("\u8fc7\u671f\u9700\u7981\u7528\u7684\u4eba\u5458\u4e3a:{}", (Object)expireEmployeeList);
            if (CollectionUtils.isNotEmpty((Collection)expireEmployeeList)) {
                ArrayList orgIds = new ArrayList();
                for (ExpireEmployeeRespVo employeeRespVo : expireEmployeeList) {
                    this.customerSalesmanService.employeeExpired(employeeRespVo, dateStr);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(expireCustomerList = this.customerDas.queryExpiredCustomer()))) {
                logger.info("{}-\u65e0\u9700\u8981\u8fc7\u671f\u7981\u7528\u7684\u5c0fB\u5ba2\u6237", (Object)dateStr);
            } else {
                logger.info("{}-\u8fc7\u671f\u9700\u7981\u7528\u7684\u5c0fB\u5ba2\u6237\u4e3a:{}", (Object)dateStr, (Object)expireCustomerList);
                for (CsCustomerEo customerEo : expireCustomerList) {
                    try {
                        logger.info("\u5f00\u59cb\u7981\u7528\u8fc7\u671f\u7528\u6237:{}", (Object)customerEo);
                        RestResponseHelper.extractData((RestResponse)this.customerExtThreeApi.updateCustomerStatus(customerEo.getId(), CUSTOMER_STATUS_ID_EXPIRE));
                        logger.info("\u6210\u529f\u7981\u7528\u8fc7\u671f\u7528\u6237:{}", (Object)customerEo);
                    }
                    catch (Exception e) {
                        String str = "\u7981\u7528\u8fc7\u671f\u7528\u6237\u5f02\u5e38:" + JSON.toJSONString((Object)customerEo) + ",\u5f02\u5e38\u4fe1\u606f\u4e3a:" + e.getMessage();
                        logger.info(str);
                        DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                        msgReqDto.setRemindPhones(this.apiNoticeConfig.getCommonList());
                        msgReqDto.setRemindType(1);
                        msgReqDto.setSendMessage(str);
                        this.dingdingSender.sendMessage(msgReqDto);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info("\u6267\u884c\u8fc7\u671f\u7981\u7528\u5ba2\u6237\u548c\u4eba\u5458\u5f02\u5e38:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

