/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.biz.service.IInventoryComparisonReportService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="inventoryComparisonReport")
@Scope(value="prototype")
public class InventoryComparisonReportJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(InventoryComparisonReportJob.class);
    @Resource
    private IInventoryComparisonReportService inventoryComparisonReportService;
    @Resource
    private ICommonsMqService commonsMqService;

    public void before(TaskMsg taskMsg) {
        logger.info("\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            logger.error("\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f00\u59cb");
            this.inventoryComparisonReportService.executeJob();
            this.inventorySnapWmsBalanceUpdate();
        }
        catch (Exception e) {
            logger.error("\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private void inventorySnapWmsBalanceUpdate() {
        logger.info("\u89e6\u53d1\u66f4\u65b0\u5e93\u5b58\u5feb\u7167wms\u671f\u672b\u5e93\u5b58\u66f4\u65b0");
        try {
            String data = JSON.toJSONString((Object)new Date());
            this.commonsMqService.sendDelaySingleMessageAsync("SNAP_WMS_BALANCE_UPDATE", (Object)data, Long.valueOf(1800L));
        }
        catch (Exception e) {
            logger.error("\u89e6\u53d1\u66f4\u65b0\u5e93\u5b58\u5feb\u7167wms\u671f\u672b\u5e93\u5b58\u66f4\u65b0\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

