/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.CargoOccupyReqDto;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryCountReDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.MaterialReqDto;
import com.dtyunxi.tcbj.api.dto.request.OutOtherDetailReportQueryDto;
import com.dtyunxi.tcbj.api.dto.response.CargoOccupyRespDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutOtherDetailReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptSourceNoRespDto;
import com.dtyunxi.tcbj.api.dto.response.RelShareInventoryRespDto;
import com.dtyunxi.tcbj.biz.service.query.IInventoryReportService;
import com.dtyunxi.tcbj.dao.das.ChannelInventoryDas;
import com.dtyunxi.tcbj.dao.das.InCargoOccupyDas;
import com.dtyunxi.tcbj.dao.das.InventoryDetailReportDas;
import com.dtyunxi.tcbj.dao.das.ItemsDas;
import com.dtyunxi.tcbj.dao.eo.ChannelInventoryEo;
import com.dtyunxi.tcbj.dao.eo.ItemEo;
import com.dtyunxi.tcbj.dao.eo.RelVirtualWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.VirtualInventoryEo;
import com.dtyunxi.tcbj.dao.mapper.RelVirtualWarehouseMapper;
import com.dtyunxi.tcbj.dao.mapper.VirtualInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class IInventoryReportServiceImpl
implements IInventoryReportService {
    private static final Logger log = LoggerFactory.getLogger(IInventoryReportServiceImpl.class);
    @Resource
    InCargoOccupyDas cargoOccupyDas;
    @Resource
    ItemsDas itemsDas;
    @Resource
    InventoryDetailReportDas inventoryDetailReportDas;
    @Autowired
    ChannelInventoryDas channelInventoryDas;
    @Autowired
    RelVirtualWarehouseMapper relVirtualWarehouseMapper;
    @Autowired
    VirtualInventoryMapper virtualInventoryMapper;

    @Override
    public List<CargoOccupyRespDto> queryOrderCargoOccupy(CargoOccupyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getTenantId(), (String)"\u7ec4\u7ec7id(tenantId)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (CollectionUtils.isEmpty((Collection)reqDto.getMaterialList())) {
            return new ArrayList<CargoOccupyRespDto>(0);
        }
        List materialNoList = reqDto.getMaterialList().stream().map(MaterialReqDto::getMaterialNo).collect(Collectors.toList());
        ItemEo queryItemEo = new ItemEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"code", materialNoList));
        queryItemEo.setSqlFilters((List)filterList);
        List itemEoList = this.itemsDas.select((BaseEo)queryItemEo);
        List longCodeList = Optional.ofNullable(itemEoList).orElseGet(Collections::emptyList).stream().map(ItemEo::getLongCode).collect(Collectors.toList());
        List inCargoOccupyEos = this.cargoOccupyDas.statCargoOccupy(longCodeList, reqDto.getTenantId());
        ArrayList<CargoOccupyRespDto> list = new ArrayList<CargoOccupyRespDto>();
        inCargoOccupyEos.forEach(dto -> {
            CargoOccupyRespDto respDto = new CargoOccupyRespDto();
            respDto.setMaterialNo(dto.getCargoCode());
            respDto.setFreezeNum(Integer.valueOf(dto.getNum().intValue()));
            list.add(respDto);
        });
        return list;
    }

    @Override
    public PageInfo<PreemptSourceNoRespDto> queryPreemptSourceNo(Integer pageNum, Integer pageSize, List<String> sourceNoList) {
        log.info("\u67e5\u8be2\u9884\u5360\u8868\u53bb\u91cd\u540e\u5355\u53f7\u5165\u53c2pageNum\uff1a{}\uff0cpageSize\uff1a{}\uff0csourceNoList\uff1a{}", new Object[]{pageNum, pageSize, JSON.toJSONString(sourceNoList)});
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.cargoOccupyDas.queryPreemptSourceNo(sourceNoList);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public PageInfo<OutOtherDetailReportRespDto> queryOutOtherDetailReportPage(OutOtherDetailReportQueryDto queryDto) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u660e\u7ec6\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getType()) && queryDto.getType().equals("out")) {
            PageInfo outOtherDetailReportRespDtoPageInfo = this.inventoryDetailReportDas.queryOutOtherDetailReportPage(queryDto);
            if (CollectionUtils.isNotEmpty((Collection)outOtherDetailReportRespDtoPageInfo.getList())) {
                outOtherDetailReportRespDtoPageInfo.getList().forEach(dto -> dto.setOrderStatusStr(this.formName(dto.getOrderStatus())));
            }
            return outOtherDetailReportRespDtoPageInfo;
        }
        PageInfo outOtherDetailReportRespDtoPageInfo = this.inventoryDetailReportDas.queryOutOtherDetailPage(queryDto);
        if (CollectionUtils.isNotEmpty((Collection)outOtherDetailReportRespDtoPageInfo.getList())) {
            outOtherDetailReportRespDtoPageInfo.getList().forEach(dto -> dto.setOrderStatusStr(this.formName(dto.getOrderStatus())));
        }
        return outOtherDetailReportRespDtoPageInfo;
    }

    @Override
    public PageInfo<ChannelInventoryRespDto> queryChannelInventoryPage(InventoryQueryReqDto inventoryQueryReqDto) {
        ExtQueryChainWrapper filter = this.channelInventoryDas.filter();
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getCargoCode())) {
            filter.like((Object)"sku_code", (Object)inventoryQueryReqDto.getCargoCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getCargoName())) {
            filter.like((Object)"sku_name", (Object)inventoryQueryReqDto.getCargoName());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)inventoryQueryReqDto.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)inventoryQueryReqDto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getIsExceedZero())) {
            filter.ne((Object)"balance", (Object)0);
        }
        if (StringUtils.isNotEmpty((CharSequence)inventoryQueryReqDto.getSearchDimension())) {
            AssertUtils.isTrue((inventoryQueryReqDto.getMinQuantity() != null || inventoryQueryReqDto.getMaxQuantity() != null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u533a\u95f4\u65e0\u6548");
            if (inventoryQueryReqDto.getMinQuantity() != null) {
                filter.ge((Object)inventoryQueryReqDto.getSearchDimension(), (Object)inventoryQueryReqDto.getMinQuantity());
            }
            if (inventoryQueryReqDto.getMaxQuantity() != null) {
                filter.le((Object)inventoryQueryReqDto.getSearchDimension(), (Object)inventoryQueryReqDto.getMaxQuantity());
            }
        }
        filter.in(CollectionUtils.isNotEmpty((Collection)inventoryQueryReqDto.getWarehouseCodes()), (Object)"warehouse_code", (Collection)inventoryQueryReqDto.getWarehouseCodes());
        filter.in(CollectionUtils.isNotEmpty((Collection)inventoryQueryReqDto.getCargoCodes()), (Object)"sku_code", (Collection)inventoryQueryReqDto.getCargoCodes());
        PageInfo eoPageInfo = filter.page(inventoryQueryReqDto.getPageNum(), inventoryQueryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List eoList = eoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return dtoPageInfo;
        }
        Set cargoCodes = eoList.stream().map(ChannelInventoryEo::getSkuCode).collect(Collectors.toSet());
        Set channelWarehouseIds = eoList.stream().map(ChannelInventoryEo::getWarehouseId).collect(Collectors.toSet());
        List relVirtualWarehouseEos = this.relVirtualWarehouseMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"channel_warehouse_id", channelWarehouseIds)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return dtoPageInfo;
        }
        Set virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).collect(Collectors.toSet());
        List virtualInventoryEos = this.virtualInventoryMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_id", virtualWarehouseIds)).in((Object)"sku_code", cargoCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)virtualInventoryEos)) {
            return dtoPageInfo;
        }
        ArrayList<ChannelInventoryRespDto> dtoList = new ArrayList<ChannelInventoryRespDto>();
        for (ChannelInventoryEo eo : eoList) {
            ChannelInventoryRespDto dto = new ChannelInventoryRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            List channelRelVirtualEos = relVirtualWarehouseEos.stream().filter(o -> Objects.equals(eo.getWarehouseId(), o.getChannelWarehouseId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(channelRelVirtualEos)) {
                dtoList.add(dto);
                continue;
            }
            ArrayList relShareInventoryRespDtoList = Lists.newArrayList();
            for (RelVirtualWarehouseEo relVirtualWarehouseEo : channelRelVirtualEos) {
                RelShareInventoryRespDto relShareInventoryRespDto = new RelShareInventoryRespDto();
                relShareInventoryRespDto.setId(relVirtualWarehouseEo.getId());
                relShareInventoryRespDto.setAvailable(BigDecimal.ZERO);
                relShareInventoryRespDto.setPreempt(BigDecimal.ZERO);
                relShareInventoryRespDto.setBalance(BigDecimal.ZERO);
                relShareInventoryRespDto.setShareWarehouseType("to_channel");
                relShareInventoryRespDto.setReceiveWarehouseCode(eo.getWarehouseCode());
                relShareInventoryRespDto.setCargoCode(eo.getSkuCode());
                VirtualInventoryEo virtualInventoryEo = virtualInventoryEos.stream().filter(o -> Objects.equals(o.getWarehouseId(), relVirtualWarehouseEo.getVirtualWarehouseId()) && StringUtils.equals((CharSequence)eo.getSkuCode(), (CharSequence)o.getCargoCode())).findFirst().orElse(null);
                if (null != virtualInventoryEo) {
                    relShareInventoryRespDto.setShareWarehouseCode(virtualInventoryEo.getWarehouseCode());
                    relShareInventoryRespDto.setBalance(virtualInventoryEo.getBalance());
                    relShareInventoryRespDto.setAvailable(virtualInventoryEo.getAvailable());
                }
                relShareInventoryRespDtoList.add(relShareInventoryRespDto);
            }
            dto.setRelShareInventoryList((List)relShareInventoryRespDtoList);
            dtoList.add(dto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ChannelInventoryCountRespDto queryChannelInventoryByCount(ChannelInventoryCountReDto channelInventoryCountReDto) {
        return this.channelInventoryDas.queryChannelInventoryByCount(channelInventoryCountReDto);
    }

    private String formName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        for (CsOtherStorageOrderStatusEnum.OUT statusEnum : CsOtherStorageOrderStatusEnum.OUT.values()) {
            if (!name.equals(statusEnum.getCode())) continue;
            return statusEnum.getDesc();
        }
        return "";
    }
}

