/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.ReSalesOrderOtherReqDto;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderShipmentStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderShipmentStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsDto;
import com.dtyunxi.tcbj.api.dto.response.StatisticsDetailRespDto;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.service.ISalesOrderShipmentStatisticsService;
import com.dtyunxi.tcbj.biz.utils.DateUtils;
import com.dtyunxi.tcbj.dao.das.ReSalesOrderOtherDas;
import com.dtyunxi.tcbj.dao.das.SalesOrderShipmentStatisticsDas;
import com.dtyunxi.tcbj.dao.eo.ReSalesOrderOtherEo;
import com.dtyunxi.tcbj.dao.eo.SalesOrderShipmentStatisticsEo;
import com.dtyunxi.tcbj.dao.vo.QueryStatisticVo;
import com.dtyunxi.tcbj.dao.vo.SaleDeliveryGoodsVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesOrderShipmentStatisticsServiceImpl
implements ISalesOrderShipmentStatisticsService {
    @Resource
    private SalesOrderShipmentStatisticsDas salesOrderShipmentStatisticsDas;
    @Resource
    private IHomePageStatisticsAssistService homePageStatisticsAssistService;
    @Resource
    private ReSalesOrderOtherDas reSalesOrderOtherDas;

    @Override
    public Long addSalesOrderShipmentStatistics(SalesOrderShipmentStatisticsReqDto addReqDto) {
        SalesOrderShipmentStatisticsEo salesOrderShipmentStatisticsEo = new SalesOrderShipmentStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)salesOrderShipmentStatisticsEo);
        this.salesOrderShipmentStatisticsDas.insert((BaseEo)salesOrderShipmentStatisticsEo);
        return salesOrderShipmentStatisticsEo.getId();
    }

    @Override
    public void modifySalesOrderShipmentStatistics(SalesOrderShipmentStatisticsReqDto modifyReqDto) {
        SalesOrderShipmentStatisticsEo salesOrderShipmentStatisticsEo = new SalesOrderShipmentStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)salesOrderShipmentStatisticsEo);
        this.salesOrderShipmentStatisticsDas.updateSelective((BaseEo)salesOrderShipmentStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSalesOrderShipmentStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.salesOrderShipmentStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SalesOrderShipmentStatisticsRespDto queryById(Long id) {
        SalesOrderShipmentStatisticsEo salesOrderShipmentStatisticsEo = (SalesOrderShipmentStatisticsEo)this.salesOrderShipmentStatisticsDas.selectByPrimaryKey(id);
        SalesOrderShipmentStatisticsRespDto salesOrderShipmentStatisticsRespDto = new SalesOrderShipmentStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)salesOrderShipmentStatisticsEo, (BaseVo)salesOrderShipmentStatisticsRespDto);
        return salesOrderShipmentStatisticsRespDto;
    }

    @Override
    public PageInfo<SalesOrderShipmentStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SalesOrderShipmentStatisticsReqDto salesOrderShipmentStatisticsReqDto = (SalesOrderShipmentStatisticsReqDto)JSON.parseObject((String)filter, SalesOrderShipmentStatisticsReqDto.class);
        SalesOrderShipmentStatisticsEo salesOrderShipmentStatisticsEo = new SalesOrderShipmentStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)salesOrderShipmentStatisticsReqDto, (BaseEo)salesOrderShipmentStatisticsEo);
        PageInfo eoPageInfo = this.salesOrderShipmentStatisticsDas.selectPage((BaseEo)salesOrderShipmentStatisticsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SalesOrderShipmentStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncSalesOrderShipmentStatistics(Date startDate, Date endDate) {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList<SaleDeliveryGoodsVo> allVoList = new ArrayList<SaleDeliveryGoodsVo>();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            queryVo.setStartTime(startDate);
            queryVo.setEndTime(endDate);
            List<SaleDeliveryGoodsVo> voList = this.homePageStatisticsAssistService.querySaleDeliveryGoods(queryVo);
            if (CollectionUtil.isEmpty(voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isNotEmpty(allVoList)) {
            List<SalesOrderShipmentStatisticsEo> eoList = this.handleData(allVoList);
            this.save(eoList);
        }
    }

    @Override
    public void syncSalesOrderNutritionist(Date startDate, Date endDate) {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList<SaleDeliveryGoodsVo> allVoList = new ArrayList<SaleDeliveryGoodsVo>();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            queryVo.setStartTime(startDate);
            queryVo.setEndTime(endDate);
            List<SaleDeliveryGoodsVo> voList = this.homePageStatisticsAssistService.querySaleNutritionistGoods(queryVo);
            if (CollectionUtil.isEmpty(voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isNotEmpty(allVoList)) {
            List<ReSalesOrderOtherEo> eoList = this.handleNutritionistData(allVoList);
            this.saveNutritionist(eoList);
        }
    }

    @Override
    public void syncOtherDeliveryOrder(Date startDate, Date endDate) {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList<SaleDeliveryGoodsVo> allVoList = new ArrayList<SaleDeliveryGoodsVo>();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            queryVo.setStartTime(startDate);
            queryVo.setEndTime(endDate);
            List<SaleDeliveryGoodsVo> voList = this.homePageStatisticsAssistService.queryOtherDeliveryOrderGoods(queryVo);
            if (CollectionUtil.isEmpty(voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isNotEmpty(allVoList)) {
            List<ReSalesOrderOtherEo> eoList = this.handleNutritionistData(allVoList);
            this.saveNutritionist(eoList);
        }
    }

    @Override
    public List<SalesOrderStatisticsDto> salesOrderShipmentStatistics(SalesOrderStatisticsQueryDto queryDto) {
        List eoList;
        String date = queryDto.getDeliverGoodsDate();
        if (StringUtils.isBlank((CharSequence)date)) {
            date = DateUtil.format((Date)new Date(), (String)DatePattern.MONTH_PATTERN.getPattern());
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)this.salesOrderShipmentStatisticsDas.filter().likeRight((Object)"deliver_goods_date", (Object)date);
        if (queryDto.getOrganizationId() != null) {
            filter.eq((Object)"organization_id", (Object)queryDto.getOrganizationId());
        }
        if (CollectionUtil.isEmpty((Collection)(eoList = filter.list()))) {
            return Lists.newArrayList();
        }
        Map<String, List<SalesOrderShipmentStatisticsEo>> eoMap = eoList.stream().collect(Collectors.groupingBy(SalesOrderShipmentStatisticsEo::getDeliverGoodsDate));
        HashMap map = Maps.newHashMap();
        eoMap.forEach((key, value) -> {
            Integer day = DateUtils.getDay(key);
            ArrayList eos = Lists.newArrayList();
            Map<String, List<SalesOrderShipmentStatisticsEo>> whKeyMap = value.stream().collect(Collectors.groupingBy(SalesOrderShipmentStatisticsEo::getWarehouseCode));
            whKeyMap.forEach((k, v) -> eos.add(this.getStatisticsDetailRespDto((List<SalesOrderShipmentStatisticsEo>)v)));
            map.put(day, eos);
        });
        Integer days = DateUtils.getDays(date);
        ArrayList respList = Lists.newArrayList();
        for (int i = 1; i <= days; ++i) {
            SalesOrderStatisticsDto dto = new SalesOrderStatisticsDto();
            dto.setDate(String.format("%s%s", i, "\u53f7"));
            if (map.containsKey(i)) {
                List details = (List)map.get(i);
                Long totalNumber = 0L;
                BigDecimal totalVolume = BigDecimal.ZERO;
                for (StatisticsDetailRespDto detail : details) {
                    totalNumber = totalNumber + detail.getNumber();
                    totalVolume = totalVolume.add(detail.getVolume());
                }
                dto.setTotalVolume(totalVolume.setScale(0, RoundingMode.HALF_UP));
                dto.setTotalNumber(totalNumber);
                dto.setDetail(details);
            } else {
                dto.setDetail((List)Lists.newArrayList());
            }
            respList.add(dto);
        }
        return respList;
    }

    @Override
    public List<SalesOrderStatisticsDto> salesOrderNutritionistStatistics(SalesOrderStatisticsQueryDto queryDto) {
        List eoList;
        String date = queryDto.getDeliverGoodsDate();
        if (StringUtils.isBlank((CharSequence)date)) {
            date = DateUtil.format((Date)new Date(), (String)DatePattern.MONTH_PATTERN.getPattern());
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reSalesOrderOtherDas.filter().likeRight((Object)"sale_create_date", (Object)date)).eq((Object)"type", (Object)queryDto.getType());
        if (queryDto.getOrganizationId() != null) {
            filter.eq((Object)"organization_id", (Object)queryDto.getOrganizationId());
        }
        if (CollectionUtil.isEmpty((Collection)(eoList = filter.list()))) {
            return Lists.newArrayList();
        }
        Map<String, List<ReSalesOrderOtherEo>> eoMap = eoList.stream().collect(Collectors.groupingBy(ReSalesOrderOtherEo::getSaleCreateDate));
        HashMap map = Maps.newHashMap();
        eoMap.forEach((key, value) -> {
            Integer day = DateUtils.getDay(key);
            ArrayList eos = Lists.newArrayList();
            Map<String, List<ReSalesOrderOtherEo>> whKeyMap = value.stream().collect(Collectors.groupingBy(ReSalesOrderOtherEo::getWarehouseCode));
            whKeyMap.forEach((k, v) -> eos.add(this.getNutritionistDetailRespDto((List<ReSalesOrderOtherEo>)v)));
            map.put(day, eos);
        });
        Integer days = DateUtils.getDays(date);
        ArrayList respList = Lists.newArrayList();
        for (int i = 1; i <= days; ++i) {
            SalesOrderStatisticsDto dto = new SalesOrderStatisticsDto();
            dto.setDate(String.format("%s%s", i, "\u53f7"));
            if (map.containsKey(i)) {
                List details = (List)map.get(i);
                Long totalNumber = 0L;
                BigDecimal totalVolume = BigDecimal.ZERO;
                for (StatisticsDetailRespDto detail : details) {
                    totalNumber = totalNumber + detail.getNumber();
                    totalVolume = totalVolume.add(detail.getVolume());
                }
                dto.setTotalVolume(totalVolume.setScale(0, RoundingMode.HALF_UP));
                dto.setTotalNumber(totalNumber);
                dto.setDetail(details);
            } else {
                dto.setDetail((List)Lists.newArrayList());
            }
            respList.add(dto);
        }
        return respList;
    }

    private StatisticsDetailRespDto getStatisticsDetailRespDto(List<SalesOrderShipmentStatisticsEo> list) {
        SalesOrderShipmentStatisticsEo soEo = list.get(0);
        StatisticsDetailRespDto shsEo = new StatisticsDetailRespDto();
        shsEo.setDeliverGoodsDate(soEo.getDeliverGoodsDate());
        shsEo.setWarehouseCode(soEo.getWarehouseCode());
        shsEo.setWarehouseName(soEo.getWarehouseName());
        Long number = 0L;
        BigDecimal volume = BigDecimal.ZERO;
        for (SalesOrderShipmentStatisticsEo o : list) {
            number = number + o.getNumber();
            volume = volume.add(o.getVolume());
        }
        shsEo.setNumber(number);
        shsEo.setVolume(volume);
        return shsEo;
    }

    private StatisticsDetailRespDto getNutritionistDetailRespDto(List<ReSalesOrderOtherEo> list) {
        ReSalesOrderOtherEo soEo = list.get(0);
        StatisticsDetailRespDto shsEo = new StatisticsDetailRespDto();
        shsEo.setDeliverGoodsDate(soEo.getSaleCreateDate());
        shsEo.setWarehouseCode(soEo.getWarehouseCode());
        shsEo.setWarehouseName(soEo.getWarehouseName());
        Long number = 0L;
        BigDecimal volume = BigDecimal.ZERO;
        for (ReSalesOrderOtherEo o : list) {
            number = number + o.getNumber();
            volume = volume.add(o.getVolume());
        }
        shsEo.setNumber(number);
        shsEo.setVolume(volume);
        return shsEo;
    }

    public static void main(String[] args) {
    }

    @Transactional(rollbackFor={Exception.class})
    private void save(List<SalesOrderShipmentStatisticsEo> eoList) {
        List dateList = eoList.stream().map(SalesOrderShipmentStatisticsEo::getDeliverGoodsDate).distinct().collect(Collectors.toList());
        this.salesOrderShipmentStatisticsDas.deleteAll(dateList);
        this.salesOrderShipmentStatisticsDas.insertBatch(eoList);
    }

    @Transactional(rollbackFor={Exception.class})
    void saveNutritionist(List<ReSalesOrderOtherEo> eoList) {
        List dateList = eoList.stream().map(ReSalesOrderOtherEo::getSaleCreateDate).distinct().collect(Collectors.toList());
        ReSalesOrderOtherReqDto dto = new ReSalesOrderOtherReqDto();
        dto.setDateList(dateList);
        dto.setType(eoList.get(0).getType());
        this.reSalesOrderOtherDas.deleteAll(dto);
        this.reSalesOrderOtherDas.insertBatch(eoList);
    }

    private List<SalesOrderShipmentStatisticsEo> handleData(List<SaleDeliveryGoodsVo> voList) {
        return voList.stream().map(i -> {
            SalesOrderShipmentStatisticsEo eo = new SalesOrderShipmentStatisticsEo();
            eo.setDeliverGoodsDate(i.getDeliveryTime());
            eo.setWarehouseCode(i.getPhysicsWarehouseCode());
            eo.setWarehouseName(i.getPhysicsWarehouseName());
            eo.setOrganizationId(i.getOrganizationId());
            eo.setOrganizationName(i.getOrganizationName());
            eo.setNumber(i.getNum());
            eo.setVolume(i.getVolume());
            return eo;
        }).collect(Collectors.toList());
    }

    private List<ReSalesOrderOtherEo> handleNutritionistData(List<SaleDeliveryGoodsVo> voList) {
        return voList.stream().map(i -> {
            ReSalesOrderOtherEo eo = new ReSalesOrderOtherEo();
            eo.setSaleCreateDate(i.getDeliveryTime());
            eo.setWarehouseCode(i.getPhysicsWarehouseCode());
            eo.setWarehouseName(i.getPhysicsWarehouseName());
            eo.setOrganizationId(i.getOrganizationId());
            eo.setOrganizationName(i.getOrganizationName());
            eo.setNumber(i.getNum());
            eo.setVolume(i.getVolume());
            eo.setType(i.getType());
            return eo;
        }).collect(Collectors.toList());
    }
}

