/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.StringCheckResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.StringCheckResultRespDto;
import com.dtyunxi.tcbj.biz.service.IStringCheckResultService;
import com.dtyunxi.tcbj.dao.das.StringCheckResultDas;
import com.dtyunxi.tcbj.dao.das.StringCheckResultDetailDas;
import com.dtyunxi.tcbj.dao.eo.ItemEo;
import com.dtyunxi.tcbj.dao.eo.StringCheckResultDetailEo;
import com.dtyunxi.tcbj.dao.eo.StringCheckResultEo;
import com.dtyunxi.tcbj.dao.mapper.ItemMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StringCheckResultServiceImpl
implements IStringCheckResultService {
    private static final Logger log = LoggerFactory.getLogger(StringCheckResultServiceImpl.class);
    @Resource
    private StringCheckResultDas stringCheckResultDas;
    @Resource
    private StringCheckResultDetailDas stringCheckResultDetailDas;
    @Resource
    private ItemMapper itemMapper;

    @Override
    public Long addStringCheckResult(StringCheckResultReqDto addReqDto) {
        StringCheckResultEo stringCheckResultEo = new StringCheckResultEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)stringCheckResultEo);
        this.stringCheckResultDas.insert((BaseEo)stringCheckResultEo);
        return stringCheckResultEo.getId();
    }

    @Override
    public void modifyStringCheckResult(StringCheckResultReqDto modifyReqDto) {
        StringCheckResultEo stringCheckResultEo = new StringCheckResultEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)stringCheckResultEo);
        this.stringCheckResultDas.updateSelective((BaseEo)stringCheckResultEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStringCheckResult(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.stringCheckResultDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StringCheckResultRespDto queryById(Long id) {
        StringCheckResultEo stringCheckResultEo = (StringCheckResultEo)this.stringCheckResultDas.selectByPrimaryKey(id);
        StringCheckResultRespDto stringCheckResultRespDto = new StringCheckResultRespDto();
        DtoHelper.eo2Dto((BaseEo)stringCheckResultEo, (BaseVo)stringCheckResultRespDto);
        return stringCheckResultRespDto;
    }

    @Override
    public PageInfo<StringCheckResultRespDto> queryByPage(StringCheckResultReqDto stringCheckResultReqDto) {
        StringCheckResultEo stringCheckResultEo = new StringCheckResultEo();
        DtoHelper.dto2Eo((BaseVo)stringCheckResultReqDto, (BaseEo)stringCheckResultEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.stringCheckResultDas.filter().setEntity((Object)stringCheckResultEo)).in(CollectionUtil.isNotEmpty((Collection)stringCheckResultReqDto.getEasSaleOrderNos()), (Object)"eas_sale_order_no", (Collection)stringCheckResultReqDto.getEasSaleOrderNos())).in(CollectionUtil.isNotEmpty((Collection)stringCheckResultReqDto.getDocumentNos()), (Object)"document_no", (Collection)stringCheckResultReqDto.getDocumentNos())).page(stringCheckResultReqDto.getPageNum(), stringCheckResultReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtil.isEmpty((Collection)eoPageInfo.getList())) {
            return dtoPageInfo;
        }
        Map<String, String> itemNameMap = this.itemMapper.selectList((Wrapper)Wrappers.query((Object)new ItemEo()).in((Object)"long_code", (Collection)eoPageInfo.getList().stream().map(StringCheckResultEo::getLongCode).collect(Collectors.toSet()))).stream().collect(Collectors.toMap(ItemEo::getLongCode, ItemEo::getName, (o, o1) -> o));
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StringCheckResultRespDto.class);
        dtoPageInfo.setList(dtoList.stream().peek(d -> d.setItemName((String)itemNameMap.get(d.getLongCode()))).collect(Collectors.toList()));
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<StringCheckResultEo> list) {
        log.info("\u4e32\u7801\u5217\u8868\u5165\u53c2list:{}", (Object)JSON.toJSONString(list));
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Optional.of(list.stream().map(StringCheckResultEo::getEasSaleOrderNo).distinct().collect(Collectors.toList())).filter(CollUtil::isNotEmpty).ifPresent(no -> this.stringCheckResultDas.getMapper().delete((Wrapper)Wrappers.query((Object)new StringCheckResultEo()).in((Object)"eas_sale_order_no", (Collection)no)));
        Optional.of(list.stream().map(StringCheckResultEo::getEasSaleOrderNo).distinct().collect(Collectors.toList())).filter(CollUtil::isNotEmpty).ifPresent(no -> this.stringCheckResultDetailDas.getMapper().delete((Wrapper)Wrappers.query((Object)new StringCheckResultDetailEo()).in((Object)"eas_sale_order_no", (Collection)no)));
        this.stringCheckResultDas.insertBatch(list);
        ArrayList<StringCheckResultDetailEo> detailEos = new ArrayList<StringCheckResultDetailEo>();
        for (StringCheckResultEo eo : list) {
            if (CollectionUtil.isEmpty((Collection)eo.getSerialNoList())) continue;
            for (String no2 : eo.getSerialNoList()) {
                StringCheckResultDetailEo detailEo = new StringCheckResultDetailEo();
                detailEo.setEasSaleOrderNo(eo.getEasSaleOrderNo());
                detailEo.setDocumentNo(eo.getDocumentNo());
                detailEo.setStringCode(eo.getStringCode());
                detailEo.setLongCode(eo.getLongCode());
                detailEo.setSecurityCode(no2);
                detailEo.setPcpNum(eo.getPcpNum());
                detailEo.setEasNum(eo.getPcpNum());
                detailEo.setStatus(eo.getStatus());
                detailEos.add(detailEo);
            }
        }
        this.stringCheckResultDetailDas.insertBatch(detailEos);
    }
}

