/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.dtyunxi.tcbj.api.dto.constant.enums.BillExceptionInfoEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsExceptionStorageBill;
import com.dtyunxi.tcbj.api.dto.constant.enums.OperationStorageEnum;
import com.dtyunxi.tcbj.api.dto.response.FinStorageContractRespDto;
import com.dtyunxi.tcbj.dao.eo.StorageChargeDetailEo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class StorageChargeHelper {
    private static Logger logger = LoggerFactory.getLogger(StorageChargeHelper.class);
    @Value(value="${storage.propertyRightOrganizationIds}")
    public String propertyRightOrganizationIds;
    @Value(value="${storage.physicsWarehouseCodes}")
    public String physicsWarehouseCodes;
    @Value(value="${storage.transferOrderTypes}")
    public String transferOrderTypes;
    @Value(value="${storage.syncBill.switch}")
    private String syncBillSwitch;
    public static final String SYNC_BILL_SWITCH = "true";
    public static final String TRANSFER_ORDER_STATUS = "finish";
    public static final String INNER_TRADE_ORDER_NOTICE = "innerTradeOrderNotice";
    public static AtomicInteger counter = new AtomicInteger(1);
    public static ThreadPoolExecutor storageExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(3, true), r -> new Thread(r, "Thread-storage[" + counter.addAndGet(1) + "]"), new ThreadPoolExecutor.CallerRunsPolicy());
    private static ThreadLocal<Map<String, BigDecimal>> threadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, BigDecimal>> storageLogicWarehouseThreadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, BigDecimal>> storageCostThreadLocal = new ThreadLocal();

    public String getPropertyRightOrganizationIds() {
        return this.propertyRightOrganizationIds;
    }

    public String getPhysicsWarehouseCodes() {
        return this.physicsWarehouseCodes;
    }

    public String getTransferOrderTypes() {
        return this.transferOrderTypes;
    }

    public String getSyncBillSwitch() {
        return this.syncBillSwitch;
    }

    public static Integer getSupport(Integer inventoryNum, Integer bigRatio, Integer zhTrayNum) {
        if (null == bigRatio || null == zhTrayNum || bigRatio.equals(IsExceptionStorageBill.IS_EXCEPTION.getVal()) || zhTrayNum.equals(IsExceptionStorageBill.IS_EXCEPTION.getVal())) {
            return IsExceptionStorageBill.IS_EXCEPTION.getVal();
        }
        if (bigRatio.equals(0) || zhTrayNum.equals(0) || inventoryNum.equals(0)) {
            return 0;
        }
        int val = new BigDecimal(inventoryNum).divide(new BigDecimal(bigRatio), 2, 5).divide(new BigDecimal(zhTrayNum), 0, 0).intValue();
        return val;
    }

    public static BigDecimal calculateOrgSupport(Integer index, Integer size, List<StorageChargeDetailEo> storageChargeDetailList, BigDecimal endInventoryNum, BigDecimal sum, BigDecimal support) {
        BigDecimal isException = new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
        if (support.compareTo(isException) == 0) {
            return isException;
        }
        if (index != size - 1) {
            if (null == sum || sum.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal orgSupport = endInventoryNum.divide(sum, 4, 1).multiply(support).setScale(4, 1);
            return orgSupport;
        }
        BigDecimal bigDecimal = storageChargeDetailList.stream().limit(size - 1).map(c -> c.getOrganizationSupport()).reduce(BigDecimal.ZERO, BigDecimal::add);
        return support.subtract(bigDecimal);
    }

    public static BigDecimal calculateContractAverageSupport(BigDecimal monthSupport, BigDecimal warehouseSupportAll, String warehouseCode, String logicWarehouseCode, FinStorageContractRespDto storageContractRespDto) {
        if (ObjectUtils.isEmpty((Object)storageContractRespDto) || monthSupport.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0 || warehouseSupportAll.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            return new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
        }
        HashMap contractAverageSupportMap = ObjectUtils.isEmpty(threadLocal.get()) ? Maps.newHashMap() : threadLocal.get();
        HashMap logicWarehouseSupportMap = ObjectUtils.isEmpty(storageLogicWarehouseThreadLocal.get()) ? Maps.newHashMap() : storageLogicWarehouseThreadLocal.get();
        BigDecimal orDefault = contractAverageSupportMap.getOrDefault(warehouseCode, new BigDecimal(storageContractRespDto.getContractAverageSupport()));
        if (monthSupport.compareTo(BigDecimal.ZERO) == 0 || warehouseSupportAll.compareTo(BigDecimal.ZERO) == 0 || orDefault.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal contractAverageSupport = logicWarehouseSupportMap.getOrDefault(warehouseCode, null);
        if (null != contractAverageSupport) {
            return contractAverageSupport;
        }
        logger.info("\u5408\u540c\u6bcf\u6708\u65e5\u5747\u677f\u6570\u8ba1\u7b97\uff0c\u8ba1\u7b97\u7ec4\u7ec7\u6708\u603b\u677f\u6570\uff1a{}\uff0c\u4ed3\u5e93\u6708\u603b\u677f\u6570\uff1a{}\uff0c\u5408\u540c\u677f\u6570\uff1a{}", new Object[]{monthSupport, warehouseSupportAll, storageContractRespDto.getContractAverageSupport()});
        BigDecimal i = monthSupport.divide(warehouseSupportAll, 6, 4).multiply(new BigDecimal(storageContractRespDto.getContractAverageSupport())).setScale(6, 0);
        if (orDefault.compareTo(i) <= 0) {
            contractAverageSupportMap.put(warehouseCode, BigDecimal.ZERO);
            i = orDefault;
        } else {
            BigDecimal result = orDefault.subtract(i);
            contractAverageSupportMap.put(warehouseCode, result);
        }
        return i;
    }

    public static BigDecimal calculateStorageCost(FinStorageContractRespDto storageContractRespDto, BigDecimal warehouseSupportAll, BigDecimal unitPrice, BigDecimal monthSupport, int day) {
        BigDecimal initSupport;
        if (ObjectUtils.isEmpty((Object)storageContractRespDto) || unitPrice.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0 || warehouseSupportAll.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0 || monthSupport.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            return new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
        }
        if (monthSupport.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        HashMap contractSupportMap = ObjectUtils.isEmpty(storageCostThreadLocal.get()) ? Maps.newHashMap() : storageCostThreadLocal.get();
        BigDecimal support = monthSupport.divide(warehouseSupportAll, 6, 4).multiply(new BigDecimal(storageContractRespDto.getContractAverageSupport())).setScale(6, 0);
        if (support.compareTo(initSupport = contractSupportMap.getOrDefault(storageContractRespDto.getWarehouseCode(), new BigDecimal(storageContractRespDto.getContractAverageSupport()))) >= 0) {
            support = initSupport;
            contractSupportMap.put(storageContractRespDto.getWarehouseCode(), BigDecimal.ZERO);
        } else {
            BigDecimal result = initSupport.subtract(support);
            contractSupportMap.put(storageContractRespDto.getWarehouseCode(), result);
        }
        return support.multiply(new BigDecimal(day)).multiply(unitPrice);
    }

    public static BigDecimal calculateIsSatisfyCost(BigDecimal monthSupport, BigDecimal unitPrice) {
        BigDecimal exceptionFlag = new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
        if (monthSupport.compareTo(exceptionFlag) == 0 || unitPrice.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            return exceptionFlag;
        }
        return unitPrice.multiply(monthSupport);
    }

    public static BigDecimal calculateAllOutVolume(BigDecimal volume, int outDeliveryNum) {
        if (0 == outDeliveryNum) {
            return BigDecimal.ZERO;
        }
        return null == volume ? new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal()) : volume.multiply(new BigDecimal(outDeliveryNum)).setScale(6);
    }

    public static Integer getAllInventoryNum(Integer operation, Integer endDeliveryNum, Integer adjustDeliveryNum) {
        OperationStorageEnum operationStorageEnum = OperationStorageEnum.keyOfEnum((Integer)operation);
        if (null == operationStorageEnum) {
            return endDeliveryNum;
        }
        switch (operationStorageEnum) {
            case ADD: {
                return endDeliveryNum + adjustDeliveryNum;
            }
            case SUBTRACT: {
                return endDeliveryNum - adjustDeliveryNum;
            }
        }
        return endDeliveryNum;
    }

    public static HashSet<String> verifyStorageDetailException(Integer zhTrayNum, BigDecimal volume, Integer packingQuantity) {
        HashSet exceptionInfoSet = Sets.newHashSet();
        if (null == zhTrayNum) {
            exceptionInfoSet.add(BillExceptionInfoEnum.STORAGE_SUPPORT_IS_EXCEPTION.getDesc());
        }
        if (null == volume) {
            exceptionInfoSet.add(BillExceptionInfoEnum.STORAGE_VOLUME_IS_EXCEPTION.getDesc());
        }
        if (null == packingQuantity) {
            exceptionInfoSet.add(BillExceptionInfoEnum.STORAGE_PACKING_QUANTITY_IS_EXCEPTION.getDesc());
        }
        return exceptionInfoSet;
    }

    public static HashSet<String> verifyStorageBillException(int outDeliverySupportTotal, BigDecimal monthSupport, BigDecimal unitPrice, BigDecimal outDeliveryVolumeTotal, BigDecimal warehouseSupportAll) {
        HashSet exceptionInfoSet = Sets.newHashSet();
        if (outDeliverySupportTotal == IsExceptionStorageBill.IS_EXCEPTION.getVal()) {
            exceptionInfoSet.add(BillExceptionInfoEnum.STORAGE_SUPPORT_IS_EXCEPTION.getDesc());
            exceptionInfoSet.add(BillExceptionInfoEnum.STORAGE_PACKING_QUANTITY_IS_EXCEPTION.getDesc());
        }
        if (monthSupport.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            exceptionInfoSet.add(BillExceptionInfoEnum.ORG_SUPPORT_EXCEPTION.getDesc());
        }
        if (unitPrice.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            exceptionInfoSet.add(BillExceptionInfoEnum.NOT_EXIT_STORAGE_UNIT_PRICE.getDesc());
        }
        if (outDeliveryVolumeTotal.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            exceptionInfoSet.add(BillExceptionInfoEnum.ORG_VOLUME_EXCEPTION.getDesc());
        }
        if (warehouseSupportAll.compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0) {
            exceptionInfoSet.add(BillExceptionInfoEnum.PHYSICAL_ALL_SUPPORT_EXCEPTION.getDesc());
        }
        return exceptionInfoSet;
    }

    public static boolean hasOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }
}

