/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.InitDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapCondition;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapReqDto;
import com.dtyunxi.tcbj.api.dto.request.SnapUpdateAbnormalDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryComparisonReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapStatusCountRespDto;
import com.dtyunxi.tcbj.biz.dto.SyncStorageDetailAndBillVo;
import com.dtyunxi.tcbj.biz.service.ILogicInventorySnapService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeDetailService;
import com.dtyunxi.tcbj.dao.das.InventoryComparisonReportDas;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.das.ItemsDas;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.das.LogicInventorySnapDas;
import com.dtyunxi.tcbj.dao.das.PcpPhysicalTrayDas;
import com.dtyunxi.tcbj.dao.eo.InventoryComparisonReportEo;
import com.dtyunxi.tcbj.dao.eo.ItemEo;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventoryEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventorySnapEo;
import com.dtyunxi.tcbj.dao.eo.PcpPhysicalTrayEo;
import com.dtyunxi.tcbj.dao.eo.WmsBalanceReportEo;
import com.dtyunxi.tcbj.dao.mapper.WmsBalanceReportMapper;
import com.dtyunxi.tcbj.dao.vo.LogicWarehouseRefVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicInventorySnapServiceImpl
implements ILogicInventorySnapService {
    private static final Logger log = LoggerFactory.getLogger(LogicInventorySnapServiceImpl.class);
    @Resource
    private LogicInventorySnapDas logicInventorySnapDas;
    @Resource
    private ItemsDas itemsDas;
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private IStorageChargeDetailService storageChargeDetailService;
    @Autowired
    private LogicInventoryDas logicInventoryDas;
    @Autowired
    private InventoryComparisonReportDas inventoryComparisonReportDas;
    @Autowired
    private PcpPhysicalTrayDas pcpPhysicalTrayDas;
    @Autowired
    private WmsBalanceReportMapper wmsBalanceReportMapper;

    @Override
    public Long addLogicInventorySnap(LogicInventorySnapReqDto addReqDto) {
        LogicInventorySnapEo logicInventorySnapEo = new LogicInventorySnapEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logicInventorySnapEo);
        this.logicInventorySnapDas.insert((BaseEo)logicInventorySnapEo);
        return logicInventorySnapEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyLogicInventorySnap(LogicInventorySnapReqDto modifyReqDto) {
        log.info("\u4fee\u6539\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167Id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyReqDto.getTrayNum(), (String)"\u7801\u6258\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyReqDto.getBigBox(), (String)"\u88c5\u7bb1\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (modifyReqDto.getTrayNum() <= 0L) {
            throw new BizException("-1", "\u7801\u6258\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (modifyReqDto.getBigBox() <= 0) {
            throw new BizException("-1", "\u88c5\u7bb1\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        this.updateDataSync(modifyReqDto);
    }

    private void updateSnapTotalBalanceAndBoardSingleByEo(LogicInventorySnapEo updateEo, String startDate, String endDate) {
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\uff08\u5355\u6761\u66f4\u65b0\uff09\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        int num = 1;
        int size = 1000;
        List snapEoList = this.logicInventorySnapDas.queryUpdateDayTotal(updateEo, startDate, endDate, Integer.valueOf(num), Integer.valueOf(size));
        while (CollectionUtils.isNotEmpty((Collection)snapEoList) && snapEoList.size() > 0) {
            snapEoList.forEach(eo -> {
                if (ObjectUtils.isNotEmpty((Object)eo.getId())) {
                    this.logicInventorySnapDas.updateSelective((BaseEo)eo);
                }
            });
            snapEoList = this.logicInventorySnapDas.queryUpdateDayTotal(updateEo, startDate, endDate, Integer.valueOf(++num), Integer.valueOf(size));
        }
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\uff08\u5355\u6761\u66f4\u65b0\uff09\u5904\u7406\u5b8c\u6bd5");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importModifyLogicInventorySnap(List<LogicInventorySnapReqDto> logicInventorySnapReqDtos) {
        log.info("\u5bfc\u5165\u4fee\u6539\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(logicInventorySnapReqDtos));
        if (CollectionUtil.isEmpty(logicInventorySnapReqDtos)) {
            return;
        }
        ExecutorService executorService = Executors.newWorkStealingPool(5);
        for (final LogicInventorySnapReqDto modifyReqDto : logicInventorySnapReqDtos) {
            AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167Id\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)modifyReqDto.getTrayNum(), (String)"\u7801\u6258\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)modifyReqDto.getBigBox(), (String)"\u88c5\u7bb1\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            if (modifyReqDto.getTrayNum() <= 0L) {
                throw new BizException("-1", "\u7801\u6258\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (modifyReqDto.getBigBox() <= 0) {
                throw new BizException("-1", "\u88c5\u7bb1\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    try {
                        LogicInventorySnapServiceImpl.this.updateDataSync(modifyReqDto);
                    }
                    catch (Exception e) {
                        log.error("\u5f02\u6b65\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u5f02\u5e38", (Throwable)e);
                    }
                }
            });
        }
    }

    private void updateDataSync(LogicInventorySnapReqDto modifyReqDto) {
        log.info("\u66f4\u65b0\u5e93\u5b58\u5feb\u7167={}", (Object)modifyReqDto.getId());
        LogicInventorySnapEo oldEo = (LogicInventorySnapEo)this.logicInventorySnapDas.selectByPrimaryKey(modifyReqDto.getId());
        AssertUtils.notNull((Object)oldEo, (String)"\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167\u4e0d\u5b58\u5728");
        LogicInventorySnapEo logicInventorySnapEo = new LogicInventorySnapEo();
        logicInventorySnapEo.setId(modifyReqDto.getId());
        logicInventorySnapEo.setBalance(modifyReqDto.getBalance());
        logicInventorySnapEo.setSnapBalance(modifyReqDto.getBalance());
        logicInventorySnapEo.setWmsBalance(modifyReqDto.getBalance());
        logicInventorySnapEo.setDiffBalance(BigDecimal.ZERO);
        logicInventorySnapEo.setTrayNum(modifyReqDto.getTrayNum());
        logicInventorySnapEo.setBigBox(modifyReqDto.getBigBox());
        BigDecimal boardNum = Optional.ofNullable(oldEo.getBalance()).orElse(BigDecimal.ZERO).divide(new BigDecimal(logicInventorySnapEo.getTrayNum()), 2, RoundingMode.HALF_UP).divide(new BigDecimal(logicInventorySnapEo.getBigBox()), 0, RoundingMode.UP);
        logicInventorySnapEo.setBoardNum(Integer.valueOf(boardNum.intValue()));
        logicInventorySnapEo.setRemark(modifyReqDto.getRemark());
        this.logicInventorySnapDas.updateSelective((BaseEo)logicInventorySnapEo);
        List reportEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryComparisonReportDas.filter().eq((Object)"statistics_time", (Object)oldEo.getStatisticalTime())).eq((Object)"long_code", (Object)oldEo.getLongCode())).eq((Object)"batch", (Object)oldEo.getBatch())).eq((Object)"warehouse_code", (Object)oldEo.getWarehouseCode())).list();
        if (reportEos.size() == 1) {
            InventoryComparisonReportEo eo2 = (InventoryComparisonReportEo)reportEos.get(0);
            InventoryComparisonReportEo comparisonReportEo = new InventoryComparisonReportEo();
            comparisonReportEo.setId(eo2.getId());
            comparisonReportEo.setBalance(modifyReqDto.getBalance());
            comparisonReportEo.setEasNum(modifyReqDto.getBalance());
            comparisonReportEo.setWmsNum(modifyReqDto.getBalance());
            comparisonReportEo.setPcpEas(BigDecimal.ZERO);
            comparisonReportEo.setPcpWms(BigDecimal.ZERO);
            comparisonReportEo.setEasWms(BigDecimal.ZERO);
            comparisonReportEo.setDiff(Integer.valueOf(0));
            this.inventoryComparisonReportDas.updateSelective((BaseEo)comparisonReportEo);
        }
        String dateFormat = DateUtil.getDateFormat((Date)oldEo.getStatisticalTime(), (String)"yyyy-MM-dd HH:mm:ss");
        this.updateSnapTotalBalanceAndBoardSingleByEo(oldEo, dateFormat, dateFormat);
        int num = 1;
        int size = 5000;
        LogicInventorySnapEo notMaterialEo = new LogicInventorySnapEo();
        notMaterialEo.setPhysicsWarehouseCode(oldEo.getPhysicsWarehouseCode());
        notMaterialEo.setLongCode(oldEo.getLongCode());
        List snapEoList = this.logicInventorySnapDas.queryUpdateDayTotalNotMaterial(notMaterialEo, dateFormat, dateFormat, Integer.valueOf(num), Integer.valueOf(size));
        snapEoList.forEach(eo -> {
            if (ObjectUtils.isNotEmpty((Object)eo.getId())) {
                this.logicInventorySnapDas.updateSelective((BaseEo)eo);
            }
        });
        SyncStorageDetailAndBillVo detailAndBillVo = new SyncStorageDetailAndBillVo();
        detailAndBillVo.setStorageTime(oldEo.getStatisticalTime());
        detailAndBillVo.setLogicWarehouseCodes(Lists.newArrayList((Object[])new String[]{oldEo.getWarehouseCode()}));
        detailAndBillVo.setOpLongCodes(Lists.newArrayList((Object[])new String[]{oldEo.getLongCode()}));
        detailAndBillVo.setBatchs(Lists.newArrayList((Object[])new String[]{oldEo.getBatch()}));
        detailAndBillVo.setWarehouseCode(oldEo.getPhysicsWarehouseCode());
        this.storageChargeDetailService.updateStorageDetailBySnap(detailAndBillVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLogicInventorySnap(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.logicInventorySnapDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public LogicInventorySnapRespDto queryById(Long id) {
        LogicInventorySnapEo logicInventorySnapEo = (LogicInventorySnapEo)this.logicInventorySnapDas.selectByPrimaryKey(id);
        LogicInventorySnapRespDto logicInventorySnapRespDto = new LogicInventorySnapRespDto();
        DtoHelper.eo2Dto((BaseEo)logicInventorySnapEo, (BaseVo)logicInventorySnapRespDto);
        return logicInventorySnapRespDto;
    }

    @Override
    public PageInfo<LogicInventorySnapRespDto> queryByPage(LogicInventorySnapReqDto logicInventorySnapReqDto) {
        PageInfo eoPageInfo = this.logicInventorySnapDas.queryByPage(logicInventorySnapReqDto);
        if (CollectionUtil.isEmpty((Collection)eoPageInfo.getList())) {
            return new PageInfo();
        }
        List dtoList = eoPageInfo.getList();
        dtoList.forEach(p -> {
            p.setSnapBalance(Optional.ofNullable(p.getSnapBalance()).orElse(BigDecimal.ZERO));
            p.setWmsBalance(Optional.ofNullable(p.getWmsBalance()).orElse(BigDecimal.ZERO));
            p.setDiffBalance(BigDecimalUtils.subtract((BigDecimal)p.getSnapBalance(), (BigDecimal)p.getWmsBalance()));
        });
        eoPageInfo.setList(dtoList);
        return eoPageInfo;
    }

    @Override
    public PageInfo<LogicInventorySnapRespDto> exportQueryByPage(LogicInventorySnapReqDto reqDto) {
        PageInfo eoPageInfo = this.logicInventorySnapDas.exportQueryByPage(reqDto);
        if (CollectionUtil.isEmpty((Collection)eoPageInfo.getList())) {
            return new PageInfo();
        }
        List dtoList = eoPageInfo.getList();
        dtoList.forEach(p -> {
            p.setSnapBalance(Optional.ofNullable(p.getSnapBalance()).orElse(BigDecimal.ZERO));
            p.setWmsBalance(Optional.ofNullable(p.getWmsBalance()).orElse(BigDecimal.ZERO));
            p.setDiffBalance(BigDecimalUtils.subtract((BigDecimal)p.getSnapBalance(), (BigDecimal)p.getWmsBalance()));
        });
        eoPageInfo.setList(dtoList);
        return eoPageInfo;
    }

    @Override
    public LogicInventorySnapStatusCountRespDto count(LogicInventorySnapReqDto reqDto) {
        return this.logicInventorySnapDas.count(reqDto);
    }

    @Override
    public PageInfo<LogicInventorySnapRespDto> queryStatisticsPage(LogicInventorySnapReqDto logicInventorySnapReqDto) {
        PageInfo eoPageInfo = this.logicInventorySnapDas.queryStatisticsPage(logicInventorySnapReqDto);
        String dateStr = logicInventorySnapReqDto.getStatisticalTimeStarter() + "~" + logicInventorySnapReqDto.getStatisticalTimeEnd();
        this.dataWrapper((PageInfo<LogicInventorySnapRespDto>)eoPageInfo, r -> r.setStatisticalTimeStr(dateStr));
        return eoPageInfo;
    }

    private void dataWrapper(PageInfo<LogicInventorySnapRespDto> eoPageInfo, Consumer<LogicInventorySnapRespDto> func) {
        if (CollectionUtil.isEmpty((Collection)eoPageInfo.getList())) {
            return;
        }
        Set longCodes = eoPageInfo.getList().stream().map(LogicInventorySnapRespDto::getLongCode).collect(Collectors.toSet());
        Map<String, Integer> itemTypeMap = ((ExtQueryChainWrapper)this.itemsDas.filter().select(new String[]{"sub_type", "long_code"}).in((Object)"long_code", longCodes)).list().stream().filter(r -> Objects.nonNull(r.getSubType())).collect(Collectors.toMap(ItemEo::getLongCode, ItemEo::getSubType, (o, o1) -> o));
        Map extendEoMap = ((ExtQueryChainWrapper)this.itemExtendDas.filter().select(new String[]{"unit_id", "item_code", "specification"}).in((Object)"item_code", longCodes)).list().stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity(), (o, o1) -> o));
        eoPageInfo.getList().forEach(r -> {
            func.accept((LogicInventorySnapRespDto)r);
            r.setItemType((Integer)itemTypeMap.get(r.getLongCode()));
            Optional.ofNullable(extendEoMap.get(r.getLongCode())).ifPresent(ext -> {
                r.setUnit(ext.getUnitId());
                r.setSpecification(ext.getSpecification());
            });
            long outNum = this.getOutNum((LogicInventorySnapRespDto)r);
            long inNum = this.getInNum((LogicInventorySnapRespDto)r);
            r.setInventoryDiff(Long.valueOf(this.getInventoryDiff((LogicInventorySnapRespDto)r, outNum, inNum)));
        });
    }

    private long getInventoryDiff(LogicInventorySnapRespDto r, long outNum, long inNum) {
        return this.getValue(r.getDateEnd()) - outNum + inNum - this.getValue(r.getDateStart()) - this.getValue(r.getAdjustIn());
    }

    private long getInNum(LogicInventorySnapRespDto r) {
        return this.getValue(r.getOtherIn()) + this.getValue(r.getSaleRefundIn()) + this.getValue(r.getOutsourceIn()) + this.getValue(r.getProductionIn()) + this.getValue(r.getTransferIn());
    }

    private long getOutNum(LogicInventorySnapRespDto r) {
        return this.getValue(r.getOtherOut()) + this.getValue(r.getSaleOut()) + this.getValue(r.getOutsourceOut()) + this.getValue(r.getProductionOut()) + this.getValue(r.getTransferOut());
    }

    @Override
    public PageInfo<LogicInventorySnapRespDto> queryStatisticsDetailPage(LogicInventorySnapReqDto logicInventorySnapReqDto) {
        PageInfo dtoPageInfo = this.logicInventorySnapDas.queryStatisticsDetailPage(logicInventorySnapReqDto);
        this.dataWrapper((PageInfo<LogicInventorySnapRespDto>)dtoPageInfo, r -> r.setStatisticalTimeStr(DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)r.getStatisticalTime())));
        return dtoPageInfo;
    }

    @Override
    public LogicInventorySnapCountRespDto queryStatisticsCount(LogicInventorySnapReqDto logicInventorySnapReqDto) {
        LogicInventorySnapRespDto respDto = Optional.ofNullable(this.logicInventorySnapDas.queryStatisticsCount(logicInventorySnapReqDto)).orElse(new LogicInventorySnapRespDto());
        LogicInventorySnapCountRespDto countRespDto = new LogicInventorySnapCountRespDto();
        countRespDto.setDateStart(respDto.getDateStart());
        countRespDto.setAdjustIn(respDto.getAdjustIn());
        long inNum = this.getInNum(respDto);
        long outNum = this.getOutNum(respDto);
        countRespDto.setAllIn(Long.valueOf(this.getInNum(respDto)));
        countRespDto.setAllOut(Long.valueOf(this.getOutNum(respDto)));
        countRespDto.setInventoryDiff(Long.valueOf(this.getInventoryDiff(respDto, outNum, inNum)));
        return countRespDto;
    }

    @Override
    public void updateAbnormalData(SnapUpdateAbnormalDataReqDto logicInventorySnapReqDto) {
        this.logicInventorySnapDas.updateAbnormalData(logicInventorySnapReqDto);
    }

    @Override
    public List<LogicInventorySnapRespDto> queryByCondition(LogicInventorySnapCondition reqDto) {
        ArrayList list = Lists.newArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(LogicInventorySnapEo::getWarehouseCode, (Collection)reqDto.getLogicWarehouseCodes())).in(LogicInventorySnapEo::getLongCode, (Collection)reqDto.getLongCodes())).in(LogicInventorySnapEo::getBatch, (Collection)reqDto.getBatchs())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getStorageTime()), LogicInventorySnapEo::getStatisticalTime, (Collection)reqDto.getStorageTime());
        List eos = this.logicInventorySnapDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            for (LogicInventorySnapEo eo : eos) {
                LogicInventorySnapRespDto respDto = new LogicInventorySnapRespDto();
                BeanUtil.copyProperties((Object)eo, (Object)respDto, (String[])new String[0]);
                list.add(respDto);
            }
        }
        return list;
    }

    @Override
    public void initDataExt(InitDataReqDto initDataReqDto) {
        log.info("[\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167],\u540c\u6b65\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)initDataReqDto));
        Date date = initDataReqDto.getDate();
        long start = System.currentTimeMillis();
        Date dayBegin = DateUtil.getDayBegin((Date)date);
        LogicInventorySnapEo snapEo = new LogicInventorySnapEo();
        snapEo.setStatisticalTime(dayBegin);
        int count = this.logicInventorySnapDas.count((BaseEo)snapEo);
        if (initDataReqDto.isReInit() && count != 0) {
            this.logicInventorySnapDas.deleteByExample((BaseEo)snapEo);
        } else if (!initDataReqDto.isReInit() && count != 0) {
            log.info("[\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167],\u5b58\u5728\u5feb\u7167\u6570\u636e\uff1a{}", (Object)dayBegin);
            return;
        }
        LogicInventoryEo logicInventoryEo = new LogicInventoryEo();
        Integer pageNum = initDataReqDto.getPageNum();
        while (true) {
            PageInfo page;
            if ((page = this.logicInventoryDas.selectPage((BaseEo)logicInventoryEo, pageNum, initDataReqDto.getPageSize())) == null || CollectionUtils.isEmpty((Collection)page.getList())) {
                log.info("[\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167],\u540c\u6b65\u7ed3\u675f\u8017\u65f6(\u6beb\u79d2)\uff1a{}", (Object)(System.currentTimeMillis() - start));
                return;
            }
            ArrayList logicWarehouseCodes = Lists.newArrayList();
            ArrayList longCodes = Lists.newArrayList();
            ArrayList batchs = Lists.newArrayList();
            for (LogicInventoryEo inventoryEo : page.getList()) {
                logicWarehouseCodes.add(inventoryEo.getWarehouseCode());
                longCodes.add(inventoryEo.getSkuCode());
                batchs.add(inventoryEo.getBatch());
            }
            LambdaQueryWrapper snapQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)snapQueryWrapper.eq(BaseEo::getDr, (Object)0)).in(LogicInventorySnapEo::getWarehouseCode, (Collection)logicWarehouseCodes)).in(LogicInventorySnapEo::getLongCode, (Collection)longCodes)).in(LogicInventorySnapEo::getBatch, (Collection)batchs)).eq(LogicInventorySnapEo::getStatisticalTime, (Object)DateUtil.addDays((Date)dayBegin, (int)-1));
            List logicInventorySnapEos = this.logicInventorySnapDas.getMapper().selectList((Wrapper)snapQueryWrapper);
            Map<String, LogicInventorySnapEo> snapEoMap = logicInventorySnapEos.stream().collect(Collectors.toMap(e -> this.buildKey(e.getWarehouseCode(), e.getLongCode(), e.getBatch()), e -> e, (e1, e2) -> e1));
            List warehouseRefVos = this.logicInventoryDas.queryReWarehouseByCode((List)logicWarehouseCodes);
            Map<String, LogicWarehouseRefVo> refVoMap = Optional.ofNullable(warehouseRefVos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(LogicWarehouseRefVo::getWarehouseCode, e -> e, (e1, e2) -> e1));
            List wmsBalanceReportEos = this.wmsBalanceReportMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WmsBalanceReportEo.class).eq(BaseEo::getDr, (Object)0)).in(WmsBalanceReportEo::getLogicWarehouseCode, (Collection)logicWarehouseCodes)).in(WmsBalanceReportEo::getItemCode, (Collection)longCodes)).in(WmsBalanceReportEo::getBatch, (Collection)batchs)).eq(WmsBalanceReportEo::getStatisticsTime, (Object)DateUtil.getDateFormat((Date)dayBegin, (String)"yyyy-MM-dd")));
            Map<String, WmsBalanceReportEo> wmsBalanceReportEoMap = wmsBalanceReportEos.stream().collect(Collectors.toMap(e -> this.buildKey(e.getLogicWarehouseCode(), e.getItemCode(), e.getBatch()), e -> e, (e1, e2) -> e1));
            List itemExtendEos = this.itemExtendDas.queryBasicByLongCodes((List)longCodes);
            Map<String, ItemExtendEo> itemExtendEoMap = Optional.ofNullable(itemExtendEos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, e -> e, (e1, e2) -> e1));
            List itemIds = itemExtendEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            Set phyWareCodes = warehouseRefVos.stream().map(LogicWarehouseRefVo::getPhysicsWarehouseCode).collect(Collectors.toSet());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(PcpPhysicalTrayEo::getItemId, itemIds)).in(PcpPhysicalTrayEo::getPhysicalWarehouseCode, phyWareCodes);
            List pcpPhysicalTrayEos = this.pcpPhysicalTrayDas.getMapper().selectList((Wrapper)queryWrapper);
            Map<String, PcpPhysicalTrayEo> trayEoMap = pcpPhysicalTrayEos.stream().collect(Collectors.toMap(e -> this.buildKey(e.getPhysicalWarehouseCode(), e.getItemId() + ""), e -> e, (e1, e2) -> e1));
            List<LogicInventorySnapEo> inventorySnapEos = this.buildEo(dayBegin, page.getList(), refVoMap, snapEoMap, wmsBalanceReportEoMap, itemExtendEoMap, trayEoMap);
            log.info("[\u4ed3\u50a8\u5e93\u5b58\u5feb\u7167]\uff0c\u6784\u5efa\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)inventorySnapEos.get(0)));
            this.operationTotal(inventorySnapEos);
            this.logicInventorySnapDas.insertBatch(inventorySnapEos);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }

    @Override
    public void wmsBalanceUpdate(String startDate, String endDate) {
        log.info("\u66f4\u65b0\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        List dtoList = this.inventoryComparisonReportDas.queryUpdateWmsBalance(startDate, endDate);
        Map<String, Object> inventoryMap = new HashMap<String, InventoryComparisonReportRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)dtoList)) {
            int size = dtoList.size();
            inventoryMap = dtoList.stream().collect(Collectors.toMap(d -> this.buildKey(d.getWarehouseCode(), d.getLongCode(), d.getBatch()), Function.identity(), (k1, k2) -> {
                k1.setWmsNum(k1.getWmsNum().add(k2.getWmsNum()));
                return k1;
            }));
            log.info(String.format("\u9700\u8981\u4fee\u6539\u7684\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\u6570\u636e\u6709%s\u6761", size));
            executorService.execute(() -> this.inventoryComparisonReportDas.updateWmsBalanceBatch(dtoList));
            executorService.shutdown();
        }
        log.info("\u66f4\u65b0wms\u671f\u672b\u5e93\u5b58\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        if (!inventoryMap.isEmpty()) {
            this.updateSnapWmsBalanceSingle(startDate, endDate, inventoryMap);
        }
    }

    private void updateSnapWmsBalanceSingle(String startDate, String endDate, Map<String, InventoryComparisonReportRespDto> inventoryMap) {
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167WMS\u5e93\u5b58\u548c\u5dee\u5f02\uff08\u5355\u6761\u66f4\u65b0\uff09\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        int num = 1;
        int size = 1000;
        List snapEoList = this.logicInventorySnapDas.queryPageByStatisticalTime(startDate, endDate, Integer.valueOf(num), Integer.valueOf(size));
        while (CollectionUtils.isNotEmpty((Collection)snapEoList) && snapEoList.size() > 0) {
            snapEoList.forEach(eo -> {
                String wmsKey = this.buildKey(eo.getWarehouseCode(), eo.getLongCode(), eo.getBatch());
                if (ObjectUtils.isNotEmpty((Object)eo.getId()) && inventoryMap.containsKey(wmsKey)) {
                    InventoryComparisonReportRespDto inventoryComparisonReportRespDto = (InventoryComparisonReportRespDto)inventoryMap.get(wmsKey);
                    BigDecimal wmsBalance = inventoryComparisonReportRespDto.getWmsNum();
                    this.updateWmsBalanceById((LogicInventorySnapEo)eo, wmsBalance);
                }
            });
            snapEoList = this.logicInventorySnapDas.queryPageByStatisticalTime(startDate, endDate, Integer.valueOf(++num), Integer.valueOf(size));
        }
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167WMS\u5e93\u5b58\u548c\u5dee\u5f02\uff08\u5355\u6761\u66f4\u65b0\uff09\u5904\u7406\u5b8c\u6bd5");
    }

    private void updateWmsBalanceById(LogicInventorySnapEo eo, BigDecimal wmsBalance) {
        LogicInventorySnapEo updateEo = new LogicInventorySnapEo();
        updateEo.setId(eo.getId());
        updateEo.setWmsBalance(wmsBalance);
        BigDecimal diffBalance = eo.getSnapBalance().subtract(updateEo.getWmsBalance());
        updateEo.setDiffBalance(diffBalance);
        updateEo.setUpdateTime(new Date());
        this.logicInventorySnapDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void wmsBalanceSnapUpdate(String startDate, String endDate) {
        log.info("\u66f4\u65b0\u4ed3\u5e93\u5feb\u7167WMS\u5e93\u5b58\u548c\u5dee\u5f02\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        int num = 1;
        int size = 1000;
        List snapEoList = this.logicInventorySnapDas.queryPageByStatisticalTime(startDate, endDate, Integer.valueOf(num), Integer.valueOf(size));
        List wmsBalanceReportEos = this.wmsBalanceReportMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WmsBalanceReportEo.class).eq(BaseEo::getDr, (Object)0)).eq(WmsBalanceReportEo::getStatisticsTime, (Object)startDate));
        Map<String, WmsBalanceReportEo> wmsBalanceReportEoMap = wmsBalanceReportEos.stream().collect(Collectors.toMap(e -> this.buildKey(e.getLogicWarehouseCode(), e.getItemCode(), e.getBatch()), e -> e, (e1, e2) -> e1));
        while (CollectionUtils.isNotEmpty((Collection)snapEoList) && snapEoList.size() > 0) {
            snapEoList.forEach(eo -> {
                String wmsKey = this.buildKey(eo.getWarehouseCode(), eo.getLongCode(), eo.getBatch());
                if (ObjectUtils.isNotEmpty((Object)eo.getId()) && wmsBalanceReportEoMap.containsKey(wmsKey)) {
                    WmsBalanceReportEo wmsBalanceReportEo = (WmsBalanceReportEo)wmsBalanceReportEoMap.get(wmsKey);
                    BigDecimal wmsBalance = wmsBalanceReportEo.getQuantity();
                    this.updateWmsBalanceById((LogicInventorySnapEo)eo, wmsBalance);
                }
            });
            snapEoList = this.logicInventorySnapDas.queryPageByStatisticalTime(startDate, endDate, Integer.valueOf(++num), Integer.valueOf(size));
        }
    }

    @Override
    public void updateSnapTotalBalanceAndBoard(String startDate, String endDate) {
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        try {
            this.logicInventorySnapDas.updateDayTotal(new LogicInventorySnapEo(), startDate, endDate);
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateSnapTotalBalanceAndBoardSingle(String startDate, String endDate) {
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\uff08\u5355\u6761\u66f4\u65b0\uff09\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        int num = 1;
        int size = 5000;
        List snapEoList = this.logicInventorySnapDas.queryUpdateDayTotal(new LogicInventorySnapEo(), startDate, endDate, Integer.valueOf(num), Integer.valueOf(size));
        while (CollectionUtils.isNotEmpty((Collection)snapEoList) && snapEoList.size() > 0) {
            snapEoList.forEach(eo -> {
                if (ObjectUtils.isNotEmpty((Object)eo.getId())) {
                    this.logicInventorySnapDas.updateSelective((BaseEo)eo);
                }
            });
            snapEoList = this.logicInventorySnapDas.queryUpdateDayTotal(new LogicInventorySnapEo(), startDate, endDate, Integer.valueOf(++num), Integer.valueOf(size));
        }
        this.updateSnapTotalBalanceAndBoardSingleNotMaterial(startDate, endDate);
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\uff08\u5355\u6761\u66f4\u65b0\uff09\u5904\u7406\u5b8c\u6bd5");
    }

    private void updateSnapTotalBalanceAndBoardSingleNotMaterial(String startDate, String endDate) {
        log.info("\u8ba1\u7b97\u66f4\u65b0\u4ed3\u50a8\u5feb\u7167\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\u7269\u6599\u54c1\uff08\u5355\u6761\u66f4\u65b0\uff09\uff1a{}\uff0c{}", (Object)startDate, (Object)endDate);
        int num = 1;
        int size = 5000;
        List snapEoList = this.logicInventorySnapDas.queryUpdateDayTotalNotMaterial(new LogicInventorySnapEo(), startDate, endDate, Integer.valueOf(num), Integer.valueOf(size));
        while (CollectionUtils.isNotEmpty((Collection)snapEoList) && snapEoList.size() > 0) {
            snapEoList.forEach(eo -> {
                if (ObjectUtils.isNotEmpty((Object)eo.getId())) {
                    this.logicInventorySnapDas.updateSelective((BaseEo)eo);
                }
            });
            snapEoList = this.logicInventorySnapDas.queryUpdateDayTotalNotMaterial(new LogicInventorySnapEo(), startDate, endDate, Integer.valueOf(++num), Integer.valueOf(size));
        }
    }

    private List<LogicInventorySnapEo> buildEo(Date date, List<LogicInventoryEo> list, Map<String, LogicWarehouseRefVo> refVoMap, Map<String, LogicInventorySnapEo> snapEoMap, Map<String, WmsBalanceReportEo> wmsBalanceReportEoMap, Map<String, ItemExtendEo> itemExtendEoMap, Map<String, PcpPhysicalTrayEo> trayEoMap) {
        ArrayList snapEos = Lists.newArrayList();
        for (LogicInventoryEo eo : list) {
            WmsBalanceReportEo wmsBalanceReportEo;
            LogicInventorySnapEo oldSnapEo;
            LogicInventorySnapEo snapEo = new LogicInventorySnapEo();
            BeanUtil.copyProperties((Object)eo, (Object)snapEo, (String[])new String[]{"id", "extension", "createPerson", "createTime", "updatePerson", "updateTime", "dr"});
            snapEo.setLongCode(eo.getSkuCode());
            snapEo.setCargoName(eo.getSkuName());
            snapEo.setStatisticalTime(date);
            snapEo.setTenantId(Long.valueOf(-1L));
            snapEo.setInstanceId(Long.valueOf(-1L));
            snapEo.setCreatePerson("system");
            LogicWarehouseRefVo refVo = refVoMap.get(eo.getWarehouseCode());
            if (refVo != null) {
                snapEo.setWarehouseId(refVo.getWarehouseId());
                snapEo.setOrganizationCode(refVo.getOrganizationCode());
                snapEo.setOrganizationName(refVo.getOrganizationName());
                snapEo.setPhysicsWarehouseCode(refVo.getPhysicsWarehouseCode());
                snapEo.setPhysicsWarehouseName(refVo.getPhysicsWarehouseName());
                snapEo.setWarehouseQuality(refVo.getWarehouseQuality());
                snapEo.setWarehouseType(refVo.getWarehouseType());
            }
            if ((oldSnapEo = snapEoMap.get(this.buildKey(eo.getWarehouseCode(), eo.getSkuCode(), eo.getBatch()))) != null) {
                snapEo.setDateStart(oldSnapEo.getBalance());
            }
            if ((wmsBalanceReportEo = wmsBalanceReportEoMap.get(this.buildKey(eo.getWarehouseCode(), eo.getSkuCode(), eo.getBatch()))) != null) {
                snapEo.setWmsBalance(wmsBalanceReportEo.getQuantity());
            }
            ItemExtendEo itemExtendEo = itemExtendEoMap.get(eo.getSkuCode());
            String itemId = "";
            Long trayNum = null;
            Long bigBox = null;
            if (itemExtendEo != null) {
                snapEo.setBigBox(itemExtendEo.getBigBox() != null ? Integer.valueOf(itemExtendEo.getBigBox().intValue()) : null);
                itemId = itemExtendEo.getId().toString();
                trayNum = itemExtendEo.getZhTrayNum();
                bigBox = itemExtendEo.getBigBox();
            }
            BigDecimal balance = Optional.ofNullable(eo.getBalance()).orElse(BigDecimal.ZERO);
            PcpPhysicalTrayEo pcpPhysicalTrayEo = trayEoMap.get(this.buildKey(snapEo.getPhysicsWarehouseCode(), itemId));
            trayNum = pcpPhysicalTrayEo != null && pcpPhysicalTrayEo.getTrayNum() != null ? pcpPhysicalTrayEo.getTrayNum() : trayNum;
            Integer boardNum = null;
            if (trayNum != null && trayNum != 0L && bigBox != null && bigBox != 0L) {
                boardNum = balance.divide(new BigDecimal(trayNum), 2, RoundingMode.HALF_UP).divide(new BigDecimal(bigBox), 0, RoundingMode.UP).intValue();
            }
            snapEo.setTrayNum(trayNum);
            snapEo.setBoardNum(boardNum);
            snapEo.setSnapBalance(eo.getBalance());
            snapEo.setDiffBalance(BigDecimalUtils.subtract((BigDecimal)snapEo.getSnapBalance(), (BigDecimal)snapEo.getWmsBalance()));
            snapEos.add(snapEo);
        }
        return snapEos;
    }

    private String buildKey(String ... agr) {
        String key = "";
        if (agr != null && agr.length > 0) {
            for (String preKey : agr) {
                key = key + preKey + ":";
            }
        }
        return key.substring(0, key.length() - 1);
    }

    private Long getValue(Long v) {
        return Optional.ofNullable(v).orElse(0L);
    }

    private void operationTotal(List<LogicInventorySnapEo> snapEoList) {
        log.info("\u8ba1\u7b97\u5f53\u65e5\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570");
        try {
            Map<String, List<LogicInventorySnapEo>> map = snapEoList.stream().collect(Collectors.groupingBy(eo -> eo.getStatisticalTime() + eo.getPhysicsWarehouseCode() + eo.getLongCode() + eo.getBatch()));
            snapEoList.forEach(snapEo -> {
                String key = snapEo.getStatisticalTime() + snapEo.getPhysicsWarehouseCode() + snapEo.getLongCode() + snapEo.getBatch();
                List logicInventorySnapEos = (List)map.get(key);
                if (CollectionUtils.isNotEmpty((Collection)logicInventorySnapEos)) {
                    BigDecimal dayTotalBalance = logicInventorySnapEos.stream().map(LogicInventorySnapEo::getBalance).filter(balance -> BigDecimalUtils.gtZero((BigDecimal)balance)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    snapEo.setDayTotalBalance(dayTotalBalance);
                    BigDecimal dayTotalBoard = BigDecimal.ZERO;
                    if (BigDecimalUtils.gtZero((BigDecimal)dayTotalBalance).booleanValue() && null != snapEo.getTrayNum() && snapEo.getTrayNum() > 0L && null != snapEo.getBigBox() && snapEo.getBigBox() > 0) {
                        BigDecimal trayNum = new BigDecimal(snapEo.getTrayNum());
                        BigDecimal bigBox = new BigDecimal(snapEo.getBigBox());
                        dayTotalBoard = BigDecimalUtils.divide((BigDecimal)dayTotalBalance, (BigDecimal)BigDecimalUtils.multiply((BigDecimal)trayNum, (BigDecimal)bigBox));
                    }
                    snapEo.setDayTotalBoard(Integer.valueOf(dayTotalBoard.intValue()));
                }
            });
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u5f53\u65e5\u603b\u5e93\u5b58\u53ca\u603b\u677f\u6570\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

