/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsExtDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseExtRespDto;
import com.dtyunxi.tcbj.api.query.ISalesOrderStatisticsQueryApi;
import com.dtyunxi.tcbj.biz.service.ISalesOrderStatisticsService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SalesOrderStatisticsQueryApiImpl
implements ISalesOrderStatisticsQueryApi {
    @Resource
    private ISalesOrderStatisticsService salesOrderStatisticsService;

    public RestResponse<SalesOrderStatisticsRespDto> queryById(Long id) {
        return new RestResponse((Object)this.salesOrderStatisticsService.queryById(id));
    }

    public RestResponse<PageInfo<SalesOrderStatisticsRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.salesOrderStatisticsService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<SalesOrderStatisticsExtDto> salesOrderPlaceOrder(SalesOrderStatisticsQueryDto queryDto) {
        List<SalesOrderStatisticsDto> list = this.salesOrderStatisticsService.salesOrderPlaceOrder(queryDto);
        SalesOrderStatisticsExtDto dto = new SalesOrderStatisticsExtDto();
        dto.setList(list);
        Long totalNumber = dto.getTotalNumber();
        BigDecimal totalVolume = dto.getTotalVolume();
        HashSet whs = Sets.newHashSet();
        for (SalesOrderStatisticsDto statisticsDto : list) {
            totalNumber = totalNumber + statisticsDto.getTotalNumber();
            totalVolume = totalVolume.add(statisticsDto.getTotalVolume());
            List details = statisticsDto.getDetail();
            details.stream().forEach(i -> {
                WarehouseExtRespDto wh = new WarehouseExtRespDto();
                wh.setWarehouseCode(i.getWarehouseCode());
                wh.setWarehouseName(i.getWarehouseName());
                whs.add(wh);
            });
        }
        dto.setTotalNumber(totalNumber);
        dto.setTotalVolume(totalVolume);
        dto.setWarehouses((List)Lists.newArrayList((Iterable)whs));
        return new RestResponse((Object)dto);
    }
}

