/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.finance.api.dto.request.logistic.SeasonPriceDto;
import com.dtyunxi.finance.api.dto.request.logistic.TemplatePriceDto;
import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderInfoDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.biz.service.LogisticBaseService;
import com.dtyunxi.tcbj.biz.utils.BigDecimalUtil;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.biz.utils.LbsUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="gateway#2")
public class LogisticPriceServiceImpl
extends LogisticBaseService<FinLogisticsReportDto> {
    private static final Logger log = LoggerFactory.getLogger(LogisticPriceServiceImpl.class);
    @Resource
    private LbsUtil lbsUtil;

    @Override
    protected FinLogisticsReportDto handle(FinLogisticsReportDto request) {
        FinLogisticsReportDto reportDto = new FinLogisticsReportDto();
        BeanUtils.copyProperties((Object)request, (Object)reportDto);
        reportDto.setUnloadAmount(null);
        reportDto.setDeliveryAmount(null);
        LogisticRecordQueryRespDto respDto = reportDto.getLogisticsTemplate();
        if (null != respDto && null != respDto.getId()) {
            reportDto.setChargeMode(respDto.getChargeMode().toString());
            reportDto.setCalUnitName(ChargeModeEnum.TRANSPORT.getDefaultUnitName());
            OilLinkQueryRespDto linkQueryRespDto = request.getOilLinkQueryRespDto();
            reportDto.setTransportAmount(BigDecimal.ZERO);
            AppointAreaQueryRespDto areaQueryRespDto = request.getAppointAreaQueryRespDto();
            if (null != linkQueryRespDto && null != linkQueryRespDto.getId() && null != areaQueryRespDto && null != areaQueryRespDto.getId() && linkQueryRespDto.getAmount() != null) {
                BigDecimal oilPriceRange = null;
                if (linkQueryRespDto != null && linkQueryRespDto.getAmount() != null && respDto.getContractOilPrice() != null && respDto.getContractOilPrice().compareTo(BigDecimal.ZERO) > 0) {
                    oilPriceRange = linkQueryRespDto.getAmount().subtract(respDto.getContractOilPrice()).divide(respDto.getContractOilPrice(), 4, RoundingMode.DOWN);
                } else if (linkQueryRespDto != null) {
                    BigDecimal amount = linkQueryRespDto.getAmount();
                    if (amount == null) {
                        this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e2d\u5355\u4ef7\u4e3a\u7a7a");
                        reportDto.setStatus(Integer.valueOf(1));
                        log.info("\u672a\u8ba1\u7b97\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope\u7684\u62a5\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)respDto));
                        return reportDto;
                    }
                } else {
                    this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e3a\u7a7a");
                    reportDto.setStatus(Integer.valueOf(1));
                    return reportDto;
                }
                BigDecimal scope = null;
                if (oilPriceRange != null) {
                    reportDto.setRangeOilPrice(super.getRangeOilPrice(oilPriceRange));
                    scope = super.setOilChangeData(oilPriceRange);
                    reportDto.setAdjustOilPrice(scope);
                }
                if (scope == null && respDto.getContractOilPrice() != null) {
                    this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u6cb9\u4ef7\u6d6e\u52a8\u9636\u68af");
                    reportDto.setStatus(Integer.valueOf(1));
                }
                if (StringUtils.isNotBlank((CharSequence)areaQueryRespDto.getParams())) {
                    log.info("\u7269\u6d41\u6a21\u7248\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
                    if (respDto.getSeasonType().intValue() == SeasonTypeEnum.COMMON.getType().intValue()) {
                        BigDecimal freight = this.gainVolumeUnitPrice(areaQueryRespDto, request.getVolume());
                        reportDto.setTransportPrice(freight);
                        reportDto.setTransportAmount(BigDecimalUtil.mul(freight, request.getVolume()));
                        reportDto.setMinCharge(BigDecimal.ZERO);
                    } else {
                        TemplatePriceDto seasonVolumeDto = (TemplatePriceDto)JSONObject.parseObject((String)areaQueryRespDto.getParams(), TemplatePriceDto.class);
                        String moth = DateTimeUtils.getMonth(request.getOutboundTime());
                        if (respDto.getOffSeason().contains(moth)) {
                            reportDto.setTransportPrice(seasonVolumeDto.getOffFreight());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(seasonVolumeDto.getOffFreight(), request.getVolume()));
                            reportDto.setMinCharge(BigDecimal.ZERO);
                        } else if (respDto.getPeakSeason().contains(moth)) {
                            reportDto.setTransportPrice(seasonVolumeDto.getPeakFreight());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(seasonVolumeDto.getPeakFreight(), request.getVolume()));
                            reportDto.setMinCharge(BigDecimal.ZERO);
                        } else {
                            reportDto.setTransportPrice(BigDecimal.ZERO);
                            reportDto.setTransportAmount(BigDecimal.ZERO);
                            reportDto.setMinCharge(BigDecimal.ZERO);
                        }
                    }
                } else {
                    reportDto.setStatus(Integer.valueOf(1));
                }
                reportDto.setDeliveryAmount(null == respDto.getDeliveryPrice() ? BigDecimal.ZERO : respDto.getDeliveryPrice());
                reportDto.setUnloadAmount(BigDecimalUtil.mul(request.getVolume(), null == respDto.getUnloadPrice() ? BigDecimal.ZERO : respDto.getUnloadPrice()));
                if (scope != null) {
                    reportDto.setOilPrice(BigDecimalUtil.mul(scope, reportDto.getTransportAmount()));
                }
            } else {
                if (linkQueryRespDto != null) {
                    BigDecimal amount = linkQueryRespDto.getAmount();
                    if (amount == null) {
                        this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e2d\u5355\u4ef7\u4e3a\u7a7a");
                        reportDto.setStatus(Integer.valueOf(1));
                        log.info("\u672a\u8ba1\u7b97\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope\u7684\u62a5\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)respDto));
                        return reportDto;
                    }
                } else {
                    this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e3a\u7a7a");
                    reportDto.setStatus(Integer.valueOf(1));
                    return reportDto;
                }
                String address = request.getProvince();
                String city = request.getCity();
                String area = request.getArea();
                if (StringUtils.isNotBlank((CharSequence)city)) {
                    address = address + city;
                }
                if (StringUtils.isNotBlank((CharSequence)area)) {
                    address = address + area;
                }
                this.setAbnormalCauses(reportDto, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u7269\u6d41\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
                reportDto.setStatus(Integer.valueOf(1));
            }
        } else {
            this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u7269\u6d41\u8fd0\u8d39\u6a21\u677f");
            reportDto.setStatus(Integer.valueOf(1));
        }
        if (Objects.equals(reportDto.getStatus(), 0)) {
            BigDecimal totalTransportAmount = BigDecimal.ZERO;
            totalTransportAmount = reportDto.getOilPrice() != null && reportDto.getOilPrice().compareTo(BigDecimal.ZERO) > 0 ? totalTransportAmount.add(reportDto.getOilPrice()) : totalTransportAmount.add(reportDto.getTransportAmount());
            if (reportDto.getDeliveryAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getDeliveryAmount());
            }
            if (reportDto.getUnloadAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getUnloadAmount());
            }
            if (reportDto.getSpecialAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getSpecialAmount());
            }
            reportDto.setTotalTransportAmount(totalTransportAmount);
        }
        return reportDto;
    }

    private BigDecimal gainVolumeUnitPrice(AppointAreaQueryRespDto respDto, BigDecimal volume) {
        if (CollectionUtil.isEmpty((Collection)respDto.getDetails())) {
            return ((SeasonPriceDto)JSONObject.parseObject((String)respDto.getParams(), SeasonPriceDto.class)).getFreight();
        }
        BigDecimal volumeUnitPrice = BigDecimal.ZERO;
        List details = respDto.getDetails();
        for (VolumeLadderInfoDto detail : details) {
            BigDecimal min = detail.getMin();
            BigDecimal max = detail.getMax();
            if (max == null) {
                if (volume.compareTo(min) < 0) continue;
                volumeUnitPrice = detail.getPrice();
                break;
            }
            if (volume.compareTo(min) < 0 || max.compareTo(volume) <= 0) continue;
            volumeUnitPrice = detail.getPrice();
            break;
        }
        return volumeUnitPrice;
    }
}

