/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl.express;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.tcbj.biz.dto.express.SfTkAndStoTemplateDto;
import com.dtyunxi.tcbj.biz.service.impl.express.HandlerAbstractCostReportServiceImpl;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractCostReportService_7")
public class StoTemplateServiceImpl
extends HandlerAbstractCostReportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(StoTemplateServiceImpl.class);
    @Resource
    private SaleOrderDas saleOrderDas;

    @Override
    public ExpressCostDetailEo calculationData(ExpressCostDetailEo eo) {
        ExpressCostDetailEo returnEo = new ExpressCostDetailEo();
        BeanUtils.copyProperties((Object)eo, (Object)returnEo);
        ExpressCostContractEo contractEo = eo.getExpressCostContractEo();
        if (contractEo != null) {
            this.converWeight(returnEo, contractEo);
            this.setWeightRange(returnEo);
            if (StringUtils.isNotBlank((CharSequence)contractEo.getParams())) {
                String params = contractEo.getParams();
                BigDecimal firstWeight = new BigDecimal(params);
                this.calculationPremium(returnEo, contractEo);
                ExpressCostAreaEo expressCostAreaEo = this.getAppointArea(eo);
                if (expressCostAreaEo != null) {
                    if (ObjectUtils.isEmpty((Object)returnEo.getChargedWeight())) {
                        this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e3a\u7a7a");
                        return returnEo;
                    }
                    this.calculateFreight(returnEo, expressCostAreaEo, contractEo, firstWeight);
                    this.setCalculationInfo(returnEo, contractEo, expressCostAreaEo);
                } else {
                    String address = eo.getProvince();
                    String city = eo.getCity();
                    String area = eo.getArea();
                    if (StringUtils.isNotBlank((CharSequence)city)) {
                        address = address + city;
                    }
                    if (StringUtils.isNotBlank((CharSequence)area)) {
                        address = address + area;
                    }
                    this.setAbnormalCauses(returnEo, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
                }
            } else {
                this.setAbnormalCauses(returnEo, "\u5408\u540c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u7a7a");
            }
        } else {
            this.setAbnormalCauses(returnEo, "\u672a\u5339\u914d\u5230\u5feb\u9012\u8fd0\u8d39\u6a21\u677f");
        }
        this.calculationAmount(returnEo);
        this.calculateDiscount(returnEo, contractEo);
        super.calculateOcsSystemWeight(returnEo);
        return returnEo;
    }

    private void calculateDiscount(ExpressCostDetailEo returnEo, ExpressCostContractEo contractEo) {
        if (returnEo.getTotalFreight() == null || Objects.equals(1, returnEo.getAbnormal()) || !returnEo.getNutritionistOrder().booleanValue() || StringUtils.isBlank((CharSequence)contractEo.getPreferentialConditions()) || contractEo.getPreferentialDiscount() == null) {
            return;
        }
        Integer num = Integer.valueOf(contractEo.getPreferentialConditions());
        Integer pollNum = this.asyncQueryPollNum(returnEo.getRelevanceNo());
        if (num >= pollNum) {
            returnEo.setTotalFreight(returnEo.getTotalFreight().multiply(contractEo.getPreferentialDiscount()));
            returnEo.setCalculateDiscountFlag(Boolean.valueOf(true));
        }
    }

    private Integer asyncQueryPollNum(String relevanceNo) {
        SaleOrderEo orderEo = (SaleOrderEo)((ExtQueryChainWrapper)this.saleOrderDas.filter().eq((Object)"sale_order_no", (Object)relevanceNo)).one();
        return ((ExtQueryChainWrapper)this.saleOrderDas.filter().eq((Object)"platform_parent_order_no", (Object)orderEo.getPlatformParentOrderNo())).count();
    }

    private void calculateFreight(ExpressCostDetailEo returnEo, ExpressCostAreaEo expressCostAreaEo, ExpressCostContractEo costContractEo, BigDecimal firstWeight) {
        BigDecimal weight = returnEo.getChargedWeight();
        String params = expressCostAreaEo.getParams();
        SfTkAndStoTemplateDto areaDto = (SfTkAndStoTemplateDto)JSON.parseObject((String)params, SfTkAndStoTemplateDto.class);
        if (weight.compareTo(firstWeight) < 0) {
            BigDecimal firstWeightPrice = areaDto.getFirstWeight();
            returnEo.setFirstPrice(firstWeightPrice);
            returnEo.setFirstPricePer(firstWeightPrice);
        } else {
            BigDecimal firstPrice = areaDto.getFirstWeight();
            returnEo.setFirstPrice(firstPrice);
            returnEo.setFirstPricePer(firstPrice);
            BigDecimal continuationPriceOne = weight.subtract(firstWeight).setScale(0, RoundingMode.UP).multiply(areaDto.getContinuationWeightOne());
            returnEo.setContinuedOne(continuationPriceOne);
            returnEo.setContinuedOnePer(areaDto.getContinuationWeightOne());
        }
    }
}

