/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.tcbj.api.dto.request.ShInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.response.ShInventoryPreemptionRespDto;
import com.dtyunxi.tcbj.biz.service.IShInventoryPreemptionService;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.share.IDgInventoryPreemptionDomain;
import com.yunxi.dg.base.center.report.eo.share.DgInventoryPreemptionEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShInventoryPreemptionServiceImpl
implements IShInventoryPreemptionService {
    @Autowired
    IDgInventoryPreemptionDomain dgInventoryPreemptionDomain;
    @Resource
    private SaleOrderMapper saleOrderMapper;

    @Override
    public PageInfo<ShInventoryPreemptionRespDto> queryPage(ShInventoryPreemptionQueryDto queryDto) {
        PageInfo eoPageInfo;
        PageInfo pageInfo = new PageInfo();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode()) && queryDto.getWarehouseCode().contains(",")) {
            queryDto.setWarehouseCodeList(Stream.of(queryDto.getWarehouseCode().split(",")).collect(Collectors.toList()));
            queryDto.setWarehouseCode(null);
        }
        if (null == (eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgInventoryPreemptionDomain.filter().eq(StringUtils.isNotBlank((CharSequence)queryDto.getSourceNo()), (Object)"source_no", (Object)queryDto.getSourceNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getExternalOrderNo()), (Object)"external_order_no", (Object)queryDto.getExternalOrderNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseClassify()), (Object)"warehouse_classify", (Object)queryDto.getWarehouseClassify())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getCargoCodeList()), (Object)"sku_code", (Collection)queryDto.getCargoCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode()), (Object)"warehouse_code", (Object)queryDto.getWarehouseCode())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getCargoCode()), (Object)"sku_code", (Object)queryDto.getCargoCode())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getValid()), (Object)"valid", (Object)queryDto.getValid())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getSourceTypeList()), (Object)"source_type", (Collection)queryDto.getSourceTypeList())).eq((Object)"dr", (Object)YesNoHelper.NO)).page(queryDto.getPageNum(), queryDto.getPageSize()))) {
            return pageInfo;
        }
        BeanUtils.copyProperties((Object)eoPageInfo, (Object)pageInfo, (String[])new String[]{"list"});
        List eoList = eoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return pageInfo;
        }
        Map<String, String> order = this.saleOrderMapper.selectList((Wrapper)Wrappers.query((Object)new SaleOrderEo()).in((Object)"sale_order_no", (Collection)eoList.stream().map(DgInventoryPreemptionEo::getSourceNo).collect(Collectors.toSet()))).stream().collect(Collectors.toMap(SaleOrderEo::getSaleOrderNo, SaleOrderEo::getOrderStatus, (o, o1) -> o));
        ArrayList dtoList = Lists.newArrayList();
        for (DgInventoryPreemptionEo eo : eoList) {
            ShInventoryPreemptionRespDto dto = new ShInventoryPreemptionRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            dto.setCargoCode(eo.getSkuCode());
            dto.setCargoName(eo.getSkuName());
            dto.setLongCode(eo.getSkuCode());
            Optional.ofNullable(order.get(eo.getSourceNo())).ifPresent(r -> {
                dto.setOrderStatusName(Optional.ofNullable(SaleOrderStatusEnum.forCode((String)r)).map(SaleOrderStatusEnum::getDesc).orElse(""));
                dto.setOrderStatus(r);
            });
            dtoList.add(dto);
        }
        pageInfo.setList((List)dtoList);
        return pageInfo;
    }
}

