/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LockLogQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LockOrderQueryDto;
import com.dtyunxi.tcbj.api.dto.response.LockOrderRespDto;
import com.dtyunxi.tcbj.biz.service.query.ILockOrderQueryService;
import com.dtyunxi.tcbj.biz.utils.DateUtils;
import com.dtyunxi.tcbj.dao.eo.ItemEo;
import com.dtyunxi.tcbj.dao.eo.LockLogEo;
import com.dtyunxi.tcbj.dao.eo.LockOrderEo;
import com.dtyunxi.tcbj.dao.mapper.ItemMapper;
import com.dtyunxi.tcbj.dao.mapper.LockLogMapper;
import com.dtyunxi.tcbj.dao.mapper.LockOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.LogicInventoryMapper;
import com.dtyunxi.tcbj.dao.vo.InventoryWarehouseVo;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="lockOrderQueryService")
public class LockOrderQueryServiceImpl
implements ILockOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(LockOrderQueryServiceImpl.class);
    @Resource
    private LogicInventoryMapper logicInventoryMapper;
    @Resource
    private ItemMapper itemMapper;
    @Resource
    private LockOrderMapper lockOrderMapper;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private LockLogMapper lockLogMapper;

    @Override
    public PageInfo<LockOrderRespDto> queryByPage(LockOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u5e93\u5b58\u9501\u5e93\u7ba1\u7406\u5217\u8868\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = Objects.isNull(queryDto.getPageNum()) ? 1 : queryDto.getPageNum();
        Integer pageSize = Objects.isNull(queryDto.getPageSize()) ? 10 : queryDto.getPageSize();
        InventoryWarehouseVo vo = new InventoryWarehouseVo();
        CubeBeanUtils.copyProperties((Object)vo, (Object)queryDto, (String[])new String[0]);
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.INVENTORY_SETTING_EXPIRATION_WARNING.getGroupCode(), DictEnum.INVENTORY_SETTING_EXPIRATION_WARNING.getCode()));
        logger.info("\u83b7\u53d6\u6709\u6548\u671f\u9884\u8b66:{}", (Object)JSON.toJSONString((Object)dictDto));
        AssertUtil.isTrue((Objects.nonNull(dictDto) && StringUtils.isNotBlank((CharSequence)dictDto.getValue()) ? 1 : 0) != 0, (String)"\u8bf7\u5728\u201c\u7cfb\u7edf\u914d\u7f6e-\u901a\u7528\u914d\u7f6e-\u5e93\u5b58\u8bbe\u7f6e\u201d\uff0c\u8bbe\u7f6e\u6709\u6548\u671f\u9884\u8b66");
        Integer dictValue = Integer.parseInt(dictDto.getValue());
        DateTime endOfDay = DateUtil.endOfDay((Date)new Date());
        Date time = DateUtils.addDate((Date)endOfDay, dictValue);
        vo.setExpireTime(time);
        Map itemMap = null;
        if (Objects.nonNull(queryDto.getItemType())) {
            QueryWrapper itemQueryWrapper = new QueryWrapper();
            itemQueryWrapper.eq((Object)"type", (Object)queryDto.getItemType());
            itemQueryWrapper.eq((Object)"dr", (Object)0);
            List itemEos = this.itemMapper.selectList((Wrapper)itemQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)itemEos)) {
                return new PageInfo();
            }
            itemMap = itemEos.stream().collect(Collectors.toMap(ItemEo::getLongCode, Function.identity(), (k1, k2) -> k1));
            vo.setLongCodes(new ArrayList<String>(itemMap.keySet()));
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List voList = this.logicInventoryMapper.queryQualifiedCargoInventory(vo);
        PageInfo pageInfoVo = new PageInfo(voList);
        List<LockOrderRespDto> list = this.getCsLockOrderRespDtoPageInfo(time, itemMap, voList);
        if (list == null) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoVo, (String[])new String[]{"list"});
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public PageInfo<LockLogEo> queryLogByPage(LockLogQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u9501\u5b9a\u8bb0\u5f55\u62a5\u8868\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = Objects.isNull(queryDto.getPageNum()) ? 1 : queryDto.getPageNum();
        Integer pageSize = Objects.isNull(queryDto.getPageSize()) ? 10 : queryDto.getPageSize();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getDocumentNo())) {
            queryWrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLongCode())) {
            queryWrapper.like((Object)"long_code", (Object)queryDto.getLongCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getCargoName())) {
            queryWrapper.like((Object)"cargo_name", (Object)queryDto.getCargoName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBatch())) {
            queryWrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseName())) {
            queryWrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getOrganizationName())) {
            queryWrapper.like((Object)"organization_name", (Object)queryDto.getOrganizationName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getType())) {
            queryWrapper.eq((Object)"type", (Object)queryDto.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBeginCreateTime())) {
            queryWrapper.ge((Object)"create_time", (Object)queryDto.getBeginCreateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getEndCreateTime())) {
            queryWrapper.le((Object)"create_time", (Object)queryDto.getEndCreateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getLogStatus())) {
            queryWrapper.eq((Object)"log_status", (Object)queryDto.getLogStatus());
        }
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodes()), (Object)"warehouse_code", (Collection)queryDto.getWarehouseCodes());
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)queryDto.getCargoCodes()), (Object)"cargo_code", (Collection)queryDto.getCargoCodes());
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)queryDto.getBatches()), (Object)"batch", (Collection)queryDto.getBatches());
        queryWrapper.orderByDesc((Object)"create_time");
        List eos = this.lockLogMapper.selectList((Wrapper)queryWrapper);
        PageInfo eoPageInfo = new PageInfo(eos);
        return eoPageInfo;
    }

    private List<LockOrderRespDto> getCsLockOrderRespDtoPageInfo(Date time, Map<String, ItemEo> itemMap, List<InventoryWarehouseVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        if (Objects.isNull(itemMap)) {
            List longCodes = voList.stream().map(e -> e.getLongCode()).distinct().collect(Collectors.toList());
            QueryWrapper itemQueryWrapper = new QueryWrapper();
            itemQueryWrapper.in((Object)"long_code", longCodes);
            itemQueryWrapper.eq((Object)"dr", (Object)0);
            List itemEos = this.itemMapper.selectList((Wrapper)itemQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)itemEos)) {
                itemMap = itemEos.stream().collect(Collectors.toMap(ItemEo::getLongCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        ArrayList<LockOrderRespDto> list = new ArrayList<LockOrderRespDto>();
        for (InventoryWarehouseVo inventoryWarehouseVo : voList) {
            LockOrderRespDto respDto = new LockOrderRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)inventoryWarehouseVo, (String[])new String[0]);
            respDto.setIsNearOverdue(Integer.valueOf(respDto.getExpireTime().compareTo(time) > 0 ? 0 : 1));
            if (Objects.nonNull(itemMap) && Objects.nonNull(itemMap.get(inventoryWarehouseVo.getLongCode()))) {
                ItemEo itemEo = (ItemEo)itemMap.get(inventoryWarehouseVo.getLongCode());
                respDto.setCargoCode(itemEo.getCode());
                respDto.setItemType(Long.valueOf(Long.parseLong(itemEo.getType().toString())));
            }
            if (Objects.nonNull(inventoryWarehouseVo.getCreateTime())) {
                int day = DateUtils.diffByDay(inventoryWarehouseVo.getCreateTime());
                respDto.setInventoryDay(Integer.valueOf(day));
            }
            QueryWrapper lockOrderEoQueryWrapper = new QueryWrapper();
            lockOrderEoQueryWrapper.eq((Object)"long_code", (Object)inventoryWarehouseVo.getLongCode());
            lockOrderEoQueryWrapper.eq((Object)"warehouse_code", (Object)inventoryWarehouseVo.getWarehouseCode());
            lockOrderEoQueryWrapper.eq((Object)"batch", (Object)inventoryWarehouseVo.getBatch());
            lockOrderEoQueryWrapper.eq((Object)"dr", (Object)0);
            LockOrderEo lockOrderEo = (LockOrderEo)this.lockOrderMapper.selectOne((Wrapper)lockOrderEoQueryWrapper);
            if (Objects.nonNull(lockOrderEo)) {
                respDto.setCurrentLockQuantity(lockOrderEo.getCurrentLockQuantity());
                respDto.setRemark(lockOrderEo.getRemark());
                respDto.setNumber(lockOrderEo.getNumber());
            }
            list.add(respDto);
        }
        return list;
    }
}

