/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.HomeStatisticsDeliverReqDto;
import com.dtyunxi.tcbj.api.dto.response.HomeStatisticsDeliverOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.HomeStatisticsDeliverRespDto;
import com.dtyunxi.tcbj.biz.service.IHomeStatisticsReportService;
import com.dtyunxi.tcbj.dao.das.HomeStatisticsReportDas;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HomeStatisticsReportServiceImpl
implements IHomeStatisticsReportService {
    private static final Logger logger = LoggerFactory.getLogger(HomeStatisticsReportServiceImpl.class);
    private final Integer DELIVER_STATISTICS_DAY = 30;
    private final String DELIVER = "DELIVER";
    private final String NOT_DELIVER = "NOT_DELIVER";
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private HomeStatisticsReportDas homeStatisticsReportDas;

    @Override
    public List<HomeStatisticsDeliverRespDto> queryDeliverStatistics(HomeStatisticsDeliverReqDto reqDto) {
        logger.info("\u5df2\u53d1\u8d27\u60c5\u51b5\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.queryDeliverStatisticsBase(reqDto, "DELIVER");
    }

    @Override
    public List<HomeStatisticsDeliverRespDto> queryNotDeliverStatistics(HomeStatisticsDeliverReqDto reqDto) {
        logger.info("\u672a\u53d1\u8d27\u60c5\u51b5\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.queryDeliverStatisticsBase(reqDto, "NOT_DELIVER");
    }

    private List<HomeStatisticsDeliverRespDto> queryDeliverStatisticsBase(HomeStatisticsDeliverReqDto reqDto, String deliverStatus) {
        logger.info("queryDeliverStatisticsBase\u6838\u5fc3\u903b\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setStatisticsDay(this.DELIVER_STATISTICS_DAY);
        Map<String, HomeStatisticsDeliverOrderRespDto> saleOrderMap = this.queryDeliverStatisticsForSaleOrder(reqDto, deliverStatus);
        Map<String, HomeStatisticsDeliverOrderRespDto> transferOrderMap = this.queryDeliverStatisticsForTransferOrder(reqDto, deliverStatus);
        Map<String, HomeStatisticsDeliverOrderRespDto> nutritionOrderMap = this.queryDeliverStatisticsForNutritionOrder(reqDto, deliverStatus);
        Map<String, HomeStatisticsDeliverOrderRespDto> otherOutOrderMap = this.queryDeliverStatisticsForOtherOutOrder(reqDto, deliverStatus);
        int day = this.DELIVER_STATISTICS_DAY;
        ArrayList<HomeStatisticsDeliverRespDto> resultList = new ArrayList<HomeStatisticsDeliverRespDto>();
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < day; ++i) {
            String date = this.format.format(cal.getTime());
            cal.add(5, -1);
            List collect = reqDto.getPhysicsWarehouseCodeList().stream().map(code -> {
                HomeStatisticsDeliverOrderRespDto otherOutStatistics;
                HomeStatisticsDeliverOrderRespDto nutritionStatistics;
                HomeStatisticsDeliverOrderRespDto transferStatistics;
                HomeStatisticsDeliverRespDto respDto = new HomeStatisticsDeliverRespDto();
                respDto.setDate(date);
                respDto.setPhysicsWarehouseCode(code);
                String key = respDto.getDate() + respDto.getPhysicsWarehouseCode();
                HomeStatisticsDeliverOrderRespDto saleStatistics = (HomeStatisticsDeliverOrderRespDto)saleOrderMap.get(key);
                if (ObjectUtils.isNotEmpty((Object)saleStatistics)) {
                    respDto.setSaleOrderNum(saleStatistics.getNum());
                    respDto.setSaleOrderVolume(saleStatistics.getVolume().setScale(0, RoundingMode.HALF_UP));
                }
                if (ObjectUtils.isNotEmpty((Object)(transferStatistics = (HomeStatisticsDeliverOrderRespDto)transferOrderMap.get(key)))) {
                    respDto.setTransferOrderNum(transferStatistics.getNum());
                    respDto.setTransferOrderVolume(transferStatistics.getVolume().setScale(0, RoundingMode.HALF_UP));
                }
                if (ObjectUtils.isNotEmpty((Object)(nutritionStatistics = (HomeStatisticsDeliverOrderRespDto)nutritionOrderMap.get(key)))) {
                    respDto.setNutritionOrderNum(nutritionStatistics.getNum());
                    respDto.setNutritionOrderVolume(nutritionStatistics.getVolume().setScale(0, RoundingMode.HALF_UP));
                }
                if (ObjectUtils.isNotEmpty((Object)(otherOutStatistics = (HomeStatisticsDeliverOrderRespDto)otherOutOrderMap.get(key)))) {
                    respDto.setOtherOrderNum(otherOutStatistics.getNum());
                    respDto.setOtherOrderVolume(otherOutStatistics.getVolume().setScale(0, RoundingMode.HALF_UP));
                }
                return respDto;
            }).collect(Collectors.toList());
            resultList.addAll(collect);
        }
        return resultList;
    }

    private Map<String, HomeStatisticsDeliverOrderRespDto> queryDeliverStatisticsForSaleOrder(HomeStatisticsDeliverReqDto reqDto, String deliverStatus) {
        logger.info("\u9500\u552e\u5355\u53d1\u8d27\u3001\u672a\u53d1\u8d27\u60c5\u51b5\u7edf\u8ba1\u67e5\u8be2\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)reqDto), (Object)deliverStatus);
        ArrayList<String> orderStatusList = new ArrayList<String>();
        String secondOrderStatus = null;
        if (deliverStatus.equals("DELIVER")) {
            orderStatusList.add("COMPLETE");
            orderStatusList.add("RECEIVED");
        } else {
            orderStatusList.add("LOCK_UN_DELIVERY");
            orderStatusList.add("WAIT_DELIVERY");
            secondOrderStatus = "WAIT_PICK_LOCK_UN_APPOINT";
        }
        List list = this.homeStatisticsReportDas.queryDeliverStatisticsForSaleOrder(reqDto, orderStatusList, secondOrderStatus);
        return this.listToMap(list);
    }

    public Map<String, HomeStatisticsDeliverOrderRespDto> queryDeliverStatisticsForTransferOrder(HomeStatisticsDeliverReqDto reqDto, String deliverStatus) {
        logger.info("\u8c03\u62e8\u5355\u53d1\u8d27\u3001\u672a\u53d1\u8d27\u60c5\u51b5\u7edf\u8ba1\u67e5\u8be2\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)reqDto), (Object)deliverStatus);
        ArrayList<String> orderStatusList = new ArrayList<String>();
        if (deliverStatus.equals("DELIVER")) {
            orderStatusList.add("delivered");
            orderStatusList.add("wait_receive");
            orderStatusList.add("finish");
            orderStatusList.add("hang_up");
        } else {
            orderStatusList.add("wait_delivery");
        }
        List list = this.homeStatisticsReportDas.queryDeliverStatisticsForTransferOrder(reqDto, orderStatusList);
        return this.listToMap(list);
    }

    public Map<String, HomeStatisticsDeliverOrderRespDto> queryDeliverStatisticsForNutritionOrder(HomeStatisticsDeliverReqDto reqDto, String deliverStatus) {
        logger.info("\u8425\u517b\u5bb6\u5355\u53d1\u8d27\u3001\u672a\u53d1\u8d27\u60c5\u51b5\u7edf\u8ba1\u67e5\u8be2\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)reqDto), (Object)deliverStatus);
        ArrayList<String> orderStatusList = new ArrayList<String>();
        if (deliverStatus.equals("DELIVER")) {
            orderStatusList.add("COMPLETE");
            orderStatusList.add("RECEIVED");
        } else {
            orderStatusList.add("LOCK_UN_DELIVERY");
            orderStatusList.add("WAIT_DELIVERY");
        }
        List list = this.homeStatisticsReportDas.queryDeliverStatisticsForNutritionOrder(reqDto, orderStatusList);
        return this.listToMap(list);
    }

    public Map<String, HomeStatisticsDeliverOrderRespDto> queryDeliverStatisticsForOtherOutOrder(HomeStatisticsDeliverReqDto reqDto, String deliverStatus) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u53d1\u8d27\u3001\u672a\u53d1\u8d27\u60c5\u51b5\u7edf\u8ba1\u67e5\u8be2\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)reqDto), (Object)deliverStatus);
        ArrayList<String> otherOrderStatusList = new ArrayList<String>();
        ArrayList<String> saleOrderStatusList = new ArrayList<String>();
        String secondOrderStatus = null;
        if (deliverStatus.equals("DELIVER")) {
            otherOrderStatusList.add("finish");
            saleOrderStatusList.add("COMPLETE");
            saleOrderStatusList.add("RECEIVED");
        } else {
            otherOrderStatusList.add("wait_out");
            saleOrderStatusList.add("LOCK_UN_DELIVERY");
            saleOrderStatusList.add("WAIT_DELIVERY");
            secondOrderStatus = "WAIT_PICK_LOCK_UN_APPOINT";
        }
        List list = this.homeStatisticsReportDas.queryDeliverStatisticsForOtherOutOrder(reqDto, otherOrderStatusList, saleOrderStatusList, secondOrderStatus);
        return this.listToMap(list);
    }

    private Map<String, HomeStatisticsDeliverOrderRespDto> listToMap(List<HomeStatisticsDeliverOrderRespDto> list) {
        Map<String, Object> respDtoMap = new HashMap<String, HomeStatisticsDeliverOrderRespDto>();
        if (CollectionUtil.isNotEmpty(list)) {
            respDtoMap = list.stream().collect(Collectors.toMap(dto -> dto.getDate() + dto.getPhysicsWarehouseCode(), Function.identity(), (k1, k2) -> k1));
        }
        return respDtoMap;
    }
}

