/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderAmountReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleSpOrderSyncReqDto;
import com.dtyunxi.tcbj.api.dto.response.CommonAddrRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleCompensationOrderSyncDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderAmountDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderResultOfFinanceDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderStringCodeCountRespDto;
import com.dtyunxi.tcbj.biz.service.ISaleOrderService;
import com.dtyunxi.tcbj.biz.utils.AddressResolutionUtil;
import com.dtyunxi.tcbj.dao.das.SaleOrderApportionDetailDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.mapper.SaleCompensationOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.tcbj.dao.vo.SaleOrderRespVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleOrderServiceImpl
implements ISaleOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderServiceImpl.class);
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private SaleOrderMapper saleOrderMapper;
    @Resource
    private SaleCompensationOrderMapper saleCompensationOrderMapper;
    @Resource
    private SaleOrderApportionDetailDas saleOrderApportionDetailDas;

    @Override
    public Long addSaleOrder(SaleOrderReqDto addReqDto) {
        SaleOrderEo saleOrderEo = new SaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleOrderEo);
        this.saleOrderDas.insert((BaseEo)saleOrderEo);
        return saleOrderEo.getId();
    }

    @Override
    public void modifySaleOrder(SaleOrderReqDto modifyReqDto) {
        SaleOrderEo saleOrderEo = new SaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderEo);
        this.saleOrderDas.updateSelective((BaseEo)saleOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.saleOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SaleOrderRespDto queryById(Long id) {
        SaleOrderEo saleOrderEo = (SaleOrderEo)this.saleOrderDas.selectByPrimaryKey(id);
        SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
        return saleOrderRespDto;
    }

    @Override
    public PageInfo<SaleOrderRespDto> queryByPage(SaleOrderReqDto filter) {
        filter.setDetailAddress(AddressResolutionUtil.extractDetailAddress(filter.getDetailAddress()));
        Page saleOrderRespVos = this.saleOrderDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)saleOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List saleOrderRespVoList = saleOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespVoList)) {
            Map<Long, SaleOrderRespVo> saleOrderRespVoMap = saleOrderRespVoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (a1, a2) -> a2));
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)saleOrderRespVoList, SaleOrderRespDto.class);
            for (SaleOrderRespDto dto : respDto) {
                CommonAddrRespDto orderAddress = new CommonAddrRespDto();
                SaleOrderRespVo saleOrderRespVo = saleOrderRespVoMap.get(dto.getId());
                if (saleOrderRespVo != null) {
                    CubeBeanUtils.copyProperties((Object)orderAddress, (Object)saleOrderRespVo, (String[])new String[0]);
                }
                dto.setOrderAddress(orderAddress);
            }
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public SaleOrderCountRespDto queryByCount(SaleOrderReqDto filter) {
        return this.saleOrderDas.queryByCount(filter);
    }

    @Override
    public SaleOrderStringCodeCountRespDto queryStringCodeByCount(SaleOrderReqDto filter) {
        return this.saleOrderDas.queryStringCodeByCount(filter);
    }

    @Override
    public SaleOrderAmountDto queryAmountInfo(SaleOrderAmountReqDto filter) {
        return this.saleOrderDas.queryAmountInfo(filter);
    }

    @Override
    public Boolean verifySaleOrderEntireSign(SaleOrderReqDto reqDto) {
        LOGGER.info("\u6821\u9a8c\u9500\u552e\u5355\u662f\u5426\u5b8c\u5168\u7b7e\u6536\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) && StringUtils.isBlank((CharSequence)reqDto.getOrderNo())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0cID\u4e0e\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        SaleOrderEo queryEo = new SaleOrderEo();
        queryEo.setId(reqDto.getId());
        queryEo.setSaleOrderNo(reqDto.getOrderNo());
        SaleOrderEo saleOrderEo = (SaleOrderEo)this.saleOrderDas.selectOne((BaseEo)queryEo);
        if (ObjectUtils.isEmpty((Object)saleOrderEo)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)saleOrderEo.getMainOrderNo())) {
            return saleOrderEo.getOrderStatus().equals("RECEIVED");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_order_no", (Object)saleOrderEo.getMainOrderNo());
        queryWrapper.notIn((Object)"order_status", new Object[]{"RECEIVED", SaleOrderStatusEnum.SPLIT.getCode(), SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.CANCEL.getCode()});
        List saleOrderEos = this.saleOrderMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)saleOrderEos);
    }

    @Override
    public Boolean verifySaleOrderEntireReceiveDelivery(SaleOrderReqDto reqDto) {
        LOGGER.info("\u6821\u9a8c\u9500\u552e\u5355\u662f\u5426\u5b8c\u5168\u6536\u53d1\u8d27\uff0c\u6839\u636e\u4e3b\u5355\u53f7\u5224\u65ad\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) && StringUtils.isBlank((CharSequence)reqDto.getOrderNo())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0cID\u4e0e\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getReceiveDeliveryType())) {
            reqDto.setReceiveDeliveryType("delivery");
        }
        reqDto.setMainOrderNo(null);
        List saleOrderRespVos = this.saleOrderDas.querySaleReceiveDeliveryList(reqDto);
        LOGGER.info("saleOrderRespVos\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespVos));
        if (CollectionUtils.isEmpty((Collection)saleOrderRespVos)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)((SaleOrderRespVo)saleOrderRespVos.get(0)).getMainOrderNo())) {
            return StringUtils.isNotBlank((CharSequence)((SaleOrderRespVo)saleOrderRespVos.get(0)).getDocumentNo());
        }
        SaleOrderReqDto params = new SaleOrderReqDto();
        params.setMainOrderNo(((SaleOrderRespVo)saleOrderRespVos.get(0)).getMainOrderNo());
        params.setReceiveDeliveryType(reqDto.getReceiveDeliveryType());
        String[] orderTypes = new String[]{SaleOrderStatusEnum.SPLIT.getCode(), SaleOrderStatusEnum.OBSOLETE.getCode()};
        params.setExcludeSaleOrderStatusList(Arrays.asList(orderTypes));
        List saleChildOrderRespVos = this.saleOrderDas.querySaleReceiveDeliveryList(params);
        LOGGER.info("saleChildOrderRespVos\uff1a{}", (Object)JSON.toJSONString((Object)saleChildOrderRespVos));
        if (CollectionUtils.isNotEmpty((Collection)saleChildOrderRespVos)) {
            for (SaleOrderRespVo vo : saleChildOrderRespVos) {
                if (!StringUtils.isBlank((CharSequence)vo.getDocumentNo())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean verifySaleOrderEntireReceiveDeliveryPlatform(String platformParentOrderNo) {
        LOGGER.info("\u6821\u9a8c\u9500\u552e\u5355\u662f\u5426\u5b8c\u5168\u6536\u53d1\u8d27\uff0c\u6839\u636e\u5e73\u53f0\u7236\u5355\u53f7\u5224\u65ad\uff1a{}", (Object)JSON.toJSONString((Object)platformParentOrderNo));
        SaleOrderReqDto params = new SaleOrderReqDto();
        params.setPlatformParentOrderNo(platformParentOrderNo);
        params.setReceiveDeliveryType("delivery");
        String[] orderTypes = new String[]{SaleOrderStatusEnum.SPLIT.getCode(), SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.CANCEL.getCode()};
        params.setExcludeSaleOrderStatusList(Arrays.asList(orderTypes));
        List saleOrderRespVos = this.saleOrderDas.querySaleReceiveDeliveryList(params);
        if (CollectionUtils.isEmpty((Collection)saleOrderRespVos)) {
            LOGGER.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355");
            return false;
        }
        for (SaleOrderRespVo vo : saleOrderRespVos) {
            if (!StringUtils.isBlank((CharSequence)vo.getDocumentNo())) continue;
            LOGGER.info("\u8be5\u9500\u552e\u5355\u5c1a\u672a\u5b8c\u6210\u53d1\u8d27\uff1a{}", (Object)vo.getSaleOrderNo());
            return false;
        }
        return true;
    }

    @Override
    public Boolean verifySaleOrderEntireSignPlatform(String platformParentOrderNo) {
        LOGGER.info("\u6821\u9a8c\u9500\u552e\u5355\u662f\u5426\u5b8c\u5168\u7b7e\u6536\uff0c\u6839\u636e\u5e73\u53f0\u7236\u5355\u53f7\u5224\u65ad\uff1a{}", (Object)platformParentOrderNo);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"platform_parent_order_no", (Object)platformParentOrderNo);
        queryWrapper.notIn((Object)"order_status", new Object[]{"RECEIVED", SaleOrderStatusEnum.SPLIT.getCode(), SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.CANCEL.getCode()});
        List saleOrderEos = this.saleOrderMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)saleOrderEos);
    }

    @Override
    public SaleOrderRespDto getTransferSaleOrder(String transferOrderNo) {
        return this.saleOrderMapper.getTransferSaleOrder(transferOrderNo);
    }

    @Override
    public List<SaleOrderRespDto> querySaleOrderByTag(SaleOrderReqDto filter) {
        return this.saleOrderDas.querySaleOrderByTag(filter);
    }

    @Override
    public List<SaleCompensationOrderSyncDto> querySaleCompensationOrderList(SaleSpOrderSyncReqDto dto) {
        return this.saleCompensationOrderMapper.querySaleCompensationOrderList(dto);
    }

    @Override
    public Boolean verifySaleRefundApportionResult(String orderNo) {
        String key;
        String key2;
        List sourceDetails = this.saleOrderDas.querySaleRefundDetails(orderNo);
        if (CollectionUtil.isEmpty((Collection)sourceDetails)) {
            return false;
        }
        List apportionDetails = this.saleOrderApportionDetailDas.orderDetailApportionQuery(orderNo);
        if (CollectionUtil.isEmpty((Collection)apportionDetails)) {
            return false;
        }
        LOGGER.info("\u5206\u644a\u524d\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)sourceDetails));
        LOGGER.info("\u5206\u644a\u7ed3\u679c\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)apportionDetails));
        HashMap<String, Integer> sourceSkuQuantityMap = new HashMap<String, Integer>();
        HashMap<String, Integer> apportionSkuQuantityMap = new HashMap<String, Integer>();
        for (SaleOrderResultOfFinanceDetailRespDto dto : sourceDetails) {
            key2 = dto.getLongCode() + "-" + dto.getSalePrice().setScale(2, RoundingMode.HALF_UP);
            if (sourceSkuQuantityMap.containsKey(key2)) {
                sourceSkuQuantityMap.put(key2, (Integer)sourceSkuQuantityMap.get(key2) + dto.getQuantity());
                continue;
            }
            sourceSkuQuantityMap.put(key2, dto.getQuantity());
        }
        for (SaleOrderResultOfFinanceDetailRespDto dto : apportionDetails) {
            key2 = dto.getLongCode() + "-" + dto.getSalePrice().setScale(2, RoundingMode.HALF_UP);
            if (apportionSkuQuantityMap.containsKey(key2)) {
                apportionSkuQuantityMap.put(key2, (Integer)apportionSkuQuantityMap.get(key2) + dto.getQuantity());
                continue;
            }
            apportionSkuQuantityMap.put(key2, dto.getQuantity());
        }
        if (sourceSkuQuantityMap.size() != apportionSkuQuantityMap.size()) {
            LOGGER.info("\u6821\u9a8c\u8ba2\u5355\u5206\u644a\u540e\u5546\u54c1sku\u6570\u4e0d\u540c\uff1a{},{}", (Object)sourceSkuQuantityMap.size(), (Object)apportionSkuQuantityMap.size());
            return false;
        }
        for (String key3 : sourceSkuQuantityMap.keySet()) {
            if (((Integer)sourceSkuQuantityMap.get(key3)).equals(apportionSkuQuantityMap.get(key3))) continue;
            LOGGER.info("\u6821\u9a8c\u8ba2\u5355\u5206\u644a\u540e\u5546\u54c1\u6570\u91cf\u4e0d\u5339\u914d\uff1a{},{},{}", new Object[]{key3, sourceSkuQuantityMap.get(key3), apportionSkuQuantityMap.get(key3)});
            return false;
        }
        HashMap<String, BigDecimal> sourceSkuAmountMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> apportionSkuAmountMap = new HashMap<String, BigDecimal>();
        for (SaleOrderResultOfFinanceDetailRespDto dto : sourceDetails) {
            key = dto.getLongCode() + "-" + dto.getSalePrice().setScale(2, RoundingMode.HALF_UP);
            if (sourceSkuAmountMap.containsKey(key)) {
                sourceSkuAmountMap.put(key, ((BigDecimal)sourceSkuAmountMap.get(key)).add(dto.getActuallyAmount()));
                continue;
            }
            sourceSkuAmountMap.put(key, dto.getActuallyAmount());
        }
        for (SaleOrderResultOfFinanceDetailRespDto dto : apportionDetails) {
            key = dto.getLongCode() + "-" + dto.getSalePrice().setScale(2, RoundingMode.HALF_UP);
            if (apportionSkuAmountMap.containsKey(key)) {
                apportionSkuAmountMap.put(key, ((BigDecimal)apportionSkuAmountMap.get(key)).add(dto.getActuallyAmount()));
                continue;
            }
            apportionSkuAmountMap.put(key, dto.getActuallyAmount());
        }
        if (sourceSkuAmountMap.size() != apportionSkuAmountMap.size()) {
            LOGGER.info("\u6821\u9a8c\u8ba2\u5355\u5206\u644a\u540e\u5546\u54c1sku\u6570\u4e0d\u540c\uff1a{},{}", (Object)sourceSkuAmountMap.size(), (Object)apportionSkuAmountMap.size());
            return false;
        }
        for (String key4 : sourceSkuAmountMap.keySet()) {
            if (((BigDecimal)sourceSkuAmountMap.get(key4)).equals(apportionSkuAmountMap.get(key4))) continue;
            LOGGER.info("\u6821\u9a8c\u8ba2\u5355\u5206\u644a\u540e\u5546\u54c1\u91d1\u989d\u4e0d\u5339\u914d\uff1a{},{},{}", new Object[]{key4, sourceSkuAmountMap.get(key4), apportionSkuAmountMap.get(key4)});
            return false;
        }
        return true;
    }

    @Override
    public List<SaleOrderRespDto> specialChannelOrderStringCodeData() {
        return this.saleOrderDas.specialChannelOrderStringCodeData();
    }
}

