/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class CreateSortingExpenseReportJob
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateSortingExpenseReportJob.class);
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Value(value="${scheduler.client.app_code:ISALE_MARKETING}")
    private String appCode;
    @Value(value="${report.scheduler.expression}")
    private String expression;

    public void run(String ... args) throws Exception {
        boolean flag = true;
        try {
            AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
            appBizQueryReqDto.setBizCode("sortingExpenseReport");
            String appBizQuery = JSONObject.toJSON((Object)appBizQueryReqDto).toString();
            PageInfo appBizQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.appBizQueryApi.queryByPage(appBizQuery, Integer.valueOf(1), Integer.valueOf(1)));
            if (CollectionUtils.isNotEmpty((Collection)appBizQueryRespDtoPageInfo.getList())) {
                AppBizQueryRespDto appBizQueryRespDto = (AppBizQueryRespDto)appBizQueryRespDtoPageInfo.getList().get(0);
                TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
                taskQueryReqDto.setAppBizId(appBizQueryRespDto.getId());
                String query = JSONObject.toJSON((Object)taskQueryReqDto).toString();
                PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(query, Integer.valueOf(1), Integer.valueOf(1)));
                if (CollectionUtils.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
                    flag = false;
                }
            }
            LOGGER.info("sortingExpenseReport===>{}", (Object)flag);
            if (flag) {
                TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
                dto.setAppCode(this.appCode);
                dto.setBizCode("sortingExpenseReport");
                dto.setBizName("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6");
                dto.setShardType("SINGLE");
                dto.setTaskName("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6");
                dto.setTaskDesc("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6");
                dto.setTenantId(Long.valueOf(-1L));
                dto.setInstanceId(Long.valueOf(-1L));
                dto.setScheduleExpression(this.expression);
                RestResponse add = this.taskApi.addWithBiz(dto);
                this.taskApi.enableById((Long)add.getData(), "{}");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u5206\u62e3\u8d39\u7528\u62a5\u8868\u7edf\u8ba1\u8c03\u5ea6\u5931\u8d25" + e.getMessage());
        }
    }
}

