/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.ExpressBillQueryDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostBillCountDto;
import com.dtyunxi.tcbj.biz.service.IExpressBillService;
import com.dtyunxi.tcbj.dao.das.ExpressCostBillDas;
import com.dtyunxi.tcbj.dao.eo.ExpressCostBillEo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExpressBillServiceImpl
implements IExpressBillService {
    private static final Logger log = LoggerFactory.getLogger(ExpressBillServiceImpl.class);
    @Resource
    private ExpressCostBillDas expressCostBillDas;

    @Override
    public PageInfo<ExpressBillRespDto> queryByPage(ExpressBillQueryDto queryDto) {
        log.info("\u67e5\u8be2\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        if (CollectionUtil.isNotEmpty((Collection)queryDto.getTransportTypeList())) {
            List list = queryDto.getTransportTypeList().stream().map(type -> {
                String csShipmentLogisticsTypeEnum = CsShipmentLogisticsTypeEnum.getDescByType((Integer)Integer.valueOf(type));
                return StringUtils.isNotBlank((CharSequence)csShipmentLogisticsTypeEnum) ? csShipmentLogisticsTypeEnum : type;
            }).collect(Collectors.toList());
            queryDto.setTransportTypeList(list);
        }
        log.info("\u8f6c\u6362\u540e\u7684\u67e5\u8be2\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        return new PageInfo(this.expressCostBillDas.queryByPage(queryDto));
    }

    @Override
    public void updateExpressCostBill(ExpressBillQueryDto reqDto) {
        log.info("\u751f\u6210\u5feb\u9012\u8d26\u5355\u7684\u8bf7\u6c42\u6570\u636e\uff08\u4f1a\u5220\u9664\u4e45\u6570\u636e\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List oldIds = this.expressCostBillDas.queryIds(reqDto);
        if (CollectionUtil.isNotEmpty((Collection)oldIds)) {
            this.expressCostBillDas.logicDeleteByIds(oldIds);
        }
        try {
            this.syncExpressCostBillData(reqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void syncExpressCostBillData(ExpressBillQueryDto reqDto) {
        log.info("\u540c\u6b65\u5feb\u9012\u8d26\u5355\u7684\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List eos = this.expressCostBillDas.queryExpressCostDetailListNew(reqDto);
        if (CollectionUtil.isEmpty((Collection)eos)) {
            return;
        }
        log.info("\u540c\u6b65\u5feb\u9012\u8d26\u5355\u6570\u636e\u6761\u6570:{}", (Object)eos.size());
        eos.stream().forEach(eo -> {
            eo.setBookkeepingDate(reqDto.getBookkeepingMonth() + "-01");
            this.expressCostBillDas.insert((BaseEo)eo);
        });
    }

    @Override
    public ExpressCostBillCountDto getExpressCostBillCount(ExpressBillQueryDto queryDto) {
        log.info("\u67e5\u8be2\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        if (CollectionUtil.isNotEmpty((Collection)queryDto.getTransportTypeList())) {
            List list = queryDto.getTransportTypeList().stream().map(type -> {
                String csShipmentLogisticsTypeEnum = CsShipmentLogisticsTypeEnum.getDescByType((Integer)Integer.valueOf(type));
                return StringUtils.isNotBlank((CharSequence)csShipmentLogisticsTypeEnum) ? csShipmentLogisticsTypeEnum : type;
            }).collect(Collectors.toList());
            queryDto.setTransportTypeList(list);
        }
        ExpressCostBillCountDto result = new ExpressCostBillCountDto();
        result.setTotalFreightSum(BigDecimal.ZERO);
        result.setTotalMonthInvoiceSum(BigDecimal.ZERO);
        log.info("\u8f6c\u6362\u540e\u7684\u67e5\u8be2\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        List countDtoList = this.expressCostBillDas.getExpressCostBillCount(queryDto);
        if (CollectionUtil.isNotEmpty((Collection)countDtoList)) {
            result.setTotalMonthInvoiceSum(countDtoList.stream().map(ExpressCostBillCountDto::getTotalMonthInvoiceSum).reduce(BigDecimal.ZERO, BigDecimal::add));
            countDtoList.stream().forEach(dto -> {
                BigDecimal bigDecimal = dto.getTotalFreightSum().setScale(2, 4);
                result.setTotalFreightSum(result.getTotalFreightSum().add(bigDecimal));
            });
        }
        return result;
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u5feb\u9012\u8d26\u5355\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostBillEo updateEo = new ExpressCostBillEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List eos = this.expressCostBillDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = eos.stream().filter(eo -> eo.getPlacedFlag() == null || eo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.expressCostBillDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }
}

