/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.InspectionReleaseConstant;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseLogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryListReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicalInventoryListPageParams;
import com.dtyunxi.tcbj.api.dto.request.PhysicalInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.SkuInventoryBatchReqDto;
import com.dtyunxi.tcbj.api.dto.request.SkuInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionPreemptNotReleaseSumRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionPreemptRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseLogicInventoryCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseLogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryListRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicalInventoryCountPageVO;
import com.dtyunxi.tcbj.api.dto.response.PhysicalInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicalInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.SkuInventoryBatchRespDto;
import com.dtyunxi.tcbj.api.dto.response.SkuInventoryRespDto;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.biz.service.IInspectionReleaseOrderService;
import com.dtyunxi.tcbj.biz.service.ILogicInventoryService;
import com.dtyunxi.tcbj.dao.das.InspectionReleaseOrderDas;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicInventoryQueryApiImpl
implements ILogicInventoryQueryApi {
    @Autowired
    ILogicInventoryService logicInventoryService;
    @Autowired
    IInspectionReleaseOrderService inspectionReleaseOrderService;
    @Autowired
    InspectionReleaseOrderDas inspectionReleaseOrderDas;

    public RestResponse<LogicInventoryRespDto> queryById(Long id) {
        return new RestResponse((Object)this.logicInventoryService.queryById(id));
    }

    public RestResponse<LogicInventoryCountDto> queryByCount(LogicInventoryReqDto filter) {
        return new RestResponse((Object)this.logicInventoryService.queryByCount(filter));
    }

    public RestResponse<List<LogicInventoryRespDto>> queryInventoryByCargo(List<CargoInventoryReqDto> cargoInventoryReqDtos) {
        return new RestResponse(this.logicInventoryService.queryInventoryByCargo(cargoInventoryReqDtos));
    }

    public RestResponse<PageInfo<LogicInventoryRespDto>> queryTotalByPage(LogicInventoryReqDto filter) {
        return new RestResponse(this.logicInventoryService.queryTotalByPage(filter));
    }

    public RestResponse<LogicInventoryCountDto> queryTotalByCount(LogicInventoryReqDto filter) {
        return new RestResponse((Object)this.logicInventoryService.queryTotalByCount(filter));
    }

    public RestResponse<PageInfo<PhysicalInventoryRespDto>> queryPhysicalByPage(PhysicalInventoryReqDto filter) {
        return new RestResponse(this.logicInventoryService.queryPhysicalByPage(filter));
    }

    public RestResponse<PhysicalInventoryCountDto> queryPhysicalByCount(PhysicalInventoryReqDto filter) {
        return new RestResponse((Object)this.logicInventoryService.queryPhysicalByCount(filter));
    }

    public RestResponse<BigDecimal> queryByIntransit(String itemLongCode, String physicsWarehouseCode) {
        return new RestResponse((Object)this.logicInventoryService.queryByIntransit(itemLongCode, physicsWarehouseCode));
    }

    public RestResponse<List<LogicInventoryListRespDto>> queryLogicInventoryList(LogicInventoryListReqDto filter) {
        return new RestResponse(this.logicInventoryService.queryLogicInventoryList(filter));
    }

    public RestResponse<List<SkuInventoryRespDto>> queryInventoryByParamList(List<SkuInventoryReqDto> skuInventoryReqDtos) {
        return new RestResponse(this.logicInventoryService.queryInventoryByParamList(skuInventoryReqDtos));
    }

    public RestResponse<List<SkuInventoryBatchRespDto>> queryLogicInventoryListByBatch(SkuInventoryBatchReqDto skuInventoryBatchReqDto) {
        return new RestResponse(this.logicInventoryService.queryLogicInventoryListByBatch(skuInventoryBatchReqDto));
    }

    public RestResponse<PageInfo<InspectionReleaseLogicInventoryRespDto>> queryInspectionReleaseInventory(InspectionReleaseLogicInventoryReqDto reqDto) {
        ArrayList inspectionTabList = Lists.newArrayList((Object[])new String[]{"pre_release", "pre_release_error", "has_release", "pre_release_over_7days_not_report", "pre_release_plan_in_diff", "has_release_plan_release_diff"});
        if (!StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"wait_release")) {
            if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"pre_release")) {
                reqDto.setStatusList((List)Lists.newArrayList((Object[])new Integer[]{0, -99}));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"pre_release_error")) {
                reqDto.setStatusList((List)Lists.newArrayList((Object[])new Integer[]{-99}));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"has_release")) {
                reqDto.setStatus(Integer.valueOf(1));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"unqualified")) {
                if (StringUtils.isBlank((CharSequence)reqDto.getReportResult())) {
                    reqDto.setReportResult("\u4e0d\u5408\u683c");
                } else if (!StringUtils.equals((CharSequence)reqDto.getReportResult(), (CharSequence)"\u4e0d\u5408\u683c")) {
                    reqDto.setReportResult("NONE");
                }
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"over_2days_not_submit")) {
                reqDto.setOver2DaysNotSubmit(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"over_7days_not_report")) {
                if (null != reqDto.getOver7DaysNotReport() && !reqDto.getOver7DaysNotReport().booleanValue()) {
                    return new RestResponse();
                }
                reqDto.setOver7DaysNotReport(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"over_3days_not_release")) {
                reqDto.setOver3DaysNotRelease(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"balance_gt_plan")) {
                reqDto.setBalanceGtPlan(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"balance_lt_plan")) {
                reqDto.setBalanceLtPlan(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"pre_release_over_7days_not_report")) {
                if (null != reqDto.getOver7DaysNotReport() && !reqDto.getOver7DaysNotReport().booleanValue()) {
                    return new RestResponse();
                }
                reqDto.setStatus(Integer.valueOf(0));
                reqDto.setOver7DaysNotReport(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"wait_release_plan_in_diff")) {
                reqDto.setPlanReleaseNumDiffIn(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"pre_release_plan_in_diff")) {
                reqDto.setStatus(Integer.valueOf(0));
                reqDto.setPlanReleaseNumDiffIn(Boolean.valueOf(true));
            } else if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"has_release_plan_release_diff")) {
                reqDto.setStatus(Integer.valueOf(1));
                reqDto.setPlanReleaseNumDiffEndRelease(Boolean.valueOf(true));
            }
        }
        Object pageInfo = inspectionTabList.contains(reqDto.getTab()) ? (Objects.equals(reqDto.getOver3DaysNotRelease(), true) || Objects.equals(reqDto.getOver2DaysNotSubmit(), true) ? new PageInfo() : this.inspectionReleaseOrderService.queryInspectionReleasePage(reqDto)) : (null != reqDto.getReleaseBeginTime() || null != reqDto.getReleaseEndTIme() ? new PageInfo<InspectionReleaseLogicInventoryRespDto>() : this.logicInventoryService.queryInspectionReleaseInventory(reqDto));
        List list = pageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List longCodeList = list.stream().map(InspectionReleaseLogicInventoryRespDto::getCargoCode).distinct().collect(Collectors.toList());
            List batchList = list.stream().map(InspectionReleaseLogicInventoryRespDto::getBatch).distinct().collect(Collectors.toList());
            List inspectionPreemptNotReleaseSumRespDtoList = this.inspectionReleaseOrderDas.queryPreemptNotReleaseBatch(longCodeList, batchList);
            Map notReleaseSumRespDtoMap = inspectionPreemptNotReleaseSumRespDtoList.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity()));
            List inspectionPreemptRespDtoList = this.inspectionReleaseOrderDas.queryPreemptListBatch(longCodeList, batchList);
            Map preemptRespDtoMap = inspectionPreemptRespDtoList.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity()));
            for (InspectionReleaseLogicInventoryRespDto dto : list) {
                InspectionPreemptNotReleaseSumRespDto notReleaseSumRespDto;
                String mapKey = dto.getCargoCode() + "_" + dto.getBatch();
                InspectionPreemptRespDto inspectionPreemptRespDto = (InspectionPreemptRespDto)preemptRespDtoMap.get(mapKey);
                if (null != inspectionPreemptRespDto) {
                    dto.setPreemptSumNum(inspectionPreemptRespDto.getPreemptNum());
                }
                if (null != (notReleaseSumRespDto = (InspectionPreemptNotReleaseSumRespDto)notReleaseSumRespDtoMap.get(mapKey))) {
                    dto.setNotReleaseSum(BigDecimalUtils.subtract((BigDecimal)notReleaseSumRespDto.getPreemptSum(), (BigDecimal)notReleaseSumRespDto.getNotReleaseSum()));
                }
                if (StringUtils.equals((CharSequence)reqDto.getTab(), (CharSequence)"wait_release")) {
                    dto.setStatus(Integer.valueOf(-99));
                    dto.setStatusName("\u5f85\u653e\u884c");
                } else {
                    dto.setStatusName((String)InspectionReleaseConstant.ORDER_STATUS.valueMap.get(dto.getStatus()));
                }
                dto.setTaskStatusName((String)InspectionReleaseConstant.TASK_STATUS.valueMap.get(dto.getTaskStatus()));
            }
        }
        return new RestResponse(pageInfo);
    }

    public RestResponse<InspectionReleaseLogicInventoryCountRespDto> queryInspectionReleaseInventoryCount(InspectionReleaseLogicInventoryReqDto reqDto) {
        InspectionReleaseLogicInventoryCountRespDto respDto = new InspectionReleaseLogicInventoryCountRespDto();
        InspectionReleaseLogicInventoryReqDto queryWaitRelease = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryWaitRelease);
        queryWaitRelease.setTab("wait_release");
        respDto.setWaitReleaseCount(this.logicInventoryService.queryInspectionReleaseInventoryCount(queryWaitRelease));
        InspectionReleaseLogicInventoryReqDto queryPreRelease = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryPreRelease);
        queryPreRelease.setStatusList((List)Lists.newArrayList((Object[])new Integer[]{0, -99}));
        respDto.setPreReleaseCount(this.inspectionReleaseOrderService.queryInspectionReleaseCount(queryPreRelease));
        InspectionReleaseLogicInventoryReqDto queryPreReleaseError = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryPreReleaseError);
        queryPreReleaseError.setStatusList((List)Lists.newArrayList((Object[])new Integer[]{-99}));
        respDto.setPreReleaseErrorCount(this.inspectionReleaseOrderService.queryInspectionReleaseCount(queryPreReleaseError));
        if (StringUtils.isBlank((CharSequence)reqDto.getReportResult()) || StringUtils.equals((CharSequence)reqDto.getReportResult(), (CharSequence)"\u4e0d\u5408\u683c")) {
            InspectionReleaseLogicInventoryReqDto queryUnqualified = new InspectionReleaseLogicInventoryReqDto();
            BeanUtils.copyProperties((Object)reqDto, (Object)queryUnqualified);
            queryUnqualified.setReportResult("\u4e0d\u5408\u683c");
            respDto.setUnqualifiedCount(this.logicInventoryService.queryInspectionReleaseInventoryCount(queryUnqualified));
        } else {
            respDto.setUnqualifiedCount(Long.valueOf(0L));
        }
        InspectionReleaseLogicInventoryReqDto queryHasRelease = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryHasRelease);
        queryHasRelease.setStatus(Integer.valueOf(1));
        respDto.setHasReleaseCount(this.inspectionReleaseOrderService.queryInspectionReleaseCount(queryHasRelease));
        InspectionReleaseLogicInventoryReqDto queryOver2DaysNotSubmit = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryOver2DaysNotSubmit);
        queryOver2DaysNotSubmit.setOver2DaysNotSubmit(Boolean.valueOf(true));
        respDto.setOver2DaysNotSubmitCount(this.logicInventoryService.queryInspectionReleaseInventoryCount(queryOver2DaysNotSubmit));
        InspectionReleaseLogicInventoryReqDto queryOver7DaysNotReport = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryOver7DaysNotReport);
        queryOver7DaysNotReport.setOver7DaysNotReport(Boolean.valueOf(true));
        respDto.setOver7DaysNotReportCount(this.logicInventoryService.queryInspectionReleaseInventoryCount(queryOver7DaysNotReport));
        InspectionReleaseLogicInventoryReqDto queryOver3DaysNotRelease = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryOver3DaysNotRelease);
        queryOver3DaysNotRelease.setOver3DaysNotRelease(Boolean.valueOf(true));
        respDto.setOver3DaysNotReleaseCount(this.logicInventoryService.queryInspectionReleaseInventoryCount(queryOver3DaysNotRelease));
        if (null != reqDto.getOver7DaysNotReport() && !reqDto.getOver7DaysNotReport().booleanValue()) {
            respDto.setPreReleaseOver7daysNotReportCount(Long.valueOf(0L));
        } else {
            InspectionReleaseLogicInventoryReqDto queryPreReleaseOver7daysNotReport = new InspectionReleaseLogicInventoryReqDto();
            BeanUtils.copyProperties((Object)reqDto, (Object)queryPreReleaseOver7daysNotReport);
            queryPreReleaseOver7daysNotReport.setOver7DaysNotReport(Boolean.valueOf(true));
            queryPreReleaseOver7daysNotReport.setStatus(Integer.valueOf(0));
            respDto.setPreReleaseOver7daysNotReportCount(this.inspectionReleaseOrderService.queryInspectionReleaseCount(queryPreReleaseOver7daysNotReport));
        }
        InspectionReleaseLogicInventoryReqDto queryWaitReleasePlanInDiff = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryWaitReleasePlanInDiff);
        queryWaitReleasePlanInDiff.setPlanReleaseNumDiffIn(Boolean.valueOf(true));
        respDto.setWaitReleasePlanInDiffCount(this.logicInventoryService.queryInspectionReleaseInventoryCount(queryWaitReleasePlanInDiff));
        InspectionReleaseLogicInventoryReqDto queryPreReleasePlanInDiff = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryPreReleasePlanInDiff);
        queryPreReleasePlanInDiff.setPlanReleaseNumDiffIn(Boolean.valueOf(true));
        queryPreReleasePlanInDiff.setStatus(Integer.valueOf(0));
        respDto.setPreReleasePlanInDiffCount(this.inspectionReleaseOrderService.queryInspectionReleaseCount(queryPreReleasePlanInDiff));
        InspectionReleaseLogicInventoryReqDto queryHasReleasePlanReleaseDiff = new InspectionReleaseLogicInventoryReqDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)queryHasReleasePlanReleaseDiff);
        queryHasReleasePlanReleaseDiff.setPlanReleaseNumDiffEndRelease(Boolean.valueOf(true));
        queryHasReleasePlanReleaseDiff.setStatus(Integer.valueOf(1));
        respDto.setHasReleasePlanReleaseDiffCount(this.inspectionReleaseOrderService.queryInspectionReleaseCount(queryHasReleasePlanReleaseDiff));
        return new RestResponse((Object)respDto);
    }

    public RestResponse<List<LogicInventoryRespDto>> queryList(LogicInventoryListReqDto reqDto) {
        return new RestResponse(this.logicInventoryService.queryList(reqDto));
    }

    public RestResponse<LogicalInventoryCountPageVO> queryLogicInventoryByCount(LogicalInventoryListPageParams filter) {
        return new RestResponse((Object)this.logicInventoryService.queryLogicInventoryByCount(filter));
    }

    public RestResponse<PageInfo<LogicInventoryRespDto>> queryByPage(LogicInventoryReqDto filter) {
        return new RestResponse(this.logicInventoryService.queryByPage(filter));
    }
}

