/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.svr.rest;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFeeCommonApi;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.biz.service.IFeeCommonService;
import com.dtyunxi.tcbj.biz.service.PmsRegenerateTasksService;
import com.dtyunxi.tcbj.biz.utils.PmsTasksUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/fee/common"})
public class FeeCommonRest
implements IFeeCommonApi {
    private static final Logger log = LoggerFactory.getLogger(FeeCommonRest.class);
    @Resource
    private IFeeCommonService feeCommonService;
    @Resource
    private PmsRegenerateTasksService tasksService;

    public RestResponse<String> generateInsurance(FeeGenerateReqDto reqDto) {
        String tasksId = StrUtil.blankToDefault((CharSequence)reqDto.getTaskId(), (String)PmsTasksUtils.getTasksId());
        log.info("generateInsurance \u672c\u6b21\u4efb\u52a1id\uff1a{}", (Object)tasksId);
        try {
            this.feeCommonService.generateInsurance(reqDto);
            this.tasksService.sendSuccessMsg(tasksId);
        }
        catch (Exception e) {
            log.error("generateInsurance \u5f02\u5e38 {}", (Object)tasksId);
            log.error("generateInsurance \u5f02\u5e38", (Throwable)e);
            this.tasksService.sendFailMsg(tasksId, e.getMessage());
            return new RestResponse("100000", e.getMessage());
        }
        return new RestResponse((Object)"");
    }
}

