/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.intercept;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitContext;
import com.dtyunxi.huieryun.datalimit.utils.SqlUtil;
import com.dtyunxi.huieryun.util.EoUtil;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.persistence.Table;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataLimitIntercept
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitIntercept.class);
    private static final String AUTHORITY_SELECTOR = "data_limit_authority_selector";
    private static final char PREFIX_FLAG = '(';
    private static final char SUFFIX_FLAG = ')';

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        String sqlType = mappedStatement.getSqlCommandType().toString();
        if (sqlType.equals(SqlCommandType.SELECT.toString())) {
            Class<?> eoClass = this.getaClass(mappedStatement);
            Table tableAnnotation = eoClass.getAnnotation(Table.class);
            String tableName = tableAnnotation.name();
            List subQueryList = DataLimitContext.getLimitRule((String)tableName);
            Long userId = ServiceContext.getContext().getRequestUserId();
            if (userId != null && !CollectionUtils.isEmpty((Collection)subQueryList)) {
                this.sqlReplace(statementHandler, tableName, subQueryList, userId);
            } else if (CollectionUtils.isEmpty((Collection)subQueryList)) {
                logger.debug("{} \u6ca1\u6709\u627e\u5230\u89c4\u5219\uff0c\u53ef\u80fd\u662f\u7528\u6237\u4e0b\u6ca1\u6709\u914d\u7f6e\u89c4\u5219\u6216\u8005\u5f53\u524d\u6b63\u5728\u6267\u884cDas\u4e0b\u7684exists\u65b9\u6cd5,userId:{}", (Object)tableName, (Object)userId);
            }
        }
        return invocation.proceed();
    }

    private void sqlReplace(StatementHandler statementHandler, String tableName, List<String> subQueryList, Long userId) {
        BoundSql boundSql = statementHandler.getBoundSql();
        String originalSql = boundSql.getSql();
        logger.debug("mybatis\u6570\u636e\u6743\u9650\u62e6\u622a\u5668\u62e6\u622a\u5230 {}\u8868 \u67e5\u8be2:{}", (Object)tableName, (Object)originalSql);
        boolean isPageHelperCountQuery = SqlUtil.isPageHelperCountQuery(originalSql);
        if (isPageHelperCountQuery) {
            logger.debug("\u6709\u5916\u5c42count");
            originalSql = SqlUtil.getRealSql(originalSql);
        }
        try {
            String mainTableAlias = SqlUtil.getTableAlias(tableName, originalSql);
            if (mainTableAlias != null) {
                mainTableAlias = Optional.of(mainTableAlias).filter(r -> r.length() > 0).orElse("mt_alias_origin");
                originalSql = SqlUtil.addTableAlias(tableName, mainTableAlias, originalSql);
                for (String subQuery : subQueryList) {
                    if (StringUtils.isEmpty((Object)subQuery)) continue;
                    subQuery = subQuery.replace("MAIN_TABLE_ALIAS", mainTableAlias).replace("CURRENT_USER_ID", String.valueOf(userId));
                    originalSql = SqlUtil.appendDataLimit(originalSql, subQuery);
                }
            } else {
                String[] split = originalSql.split(tableName);
                if (split.length > 1) {
                    originalSql = this.getInnerSql(tableName, subQueryList, userId, originalSql, split[0]);
                } else {
                    String alias = "\u67e5\u8be2\u8bed\u53e5\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5728\u67e5\u8be2\u4e2d\u6ca1\u6709\u5305\u542b\u53d7\u63a7\u8868\uff1a" + tableName;
                    logger.error(alias);
                    throw new IllegalStateException(alias);
                }
            }
            if (isPageHelperCountQuery) {
                originalSql = SqlUtil.getSimpleCountSql(originalSql, "0");
            }
            SqlUtil.appendSql(boundSql, originalSql);
            logger.debug("mybatis\u6570\u636e\u6743\u9650\u62e6\u622a\u5668\uff1a{}\u8868 \u6539\u5199\u540e\u7684\u67e5\u8be2:{}", (Object)tableName, (Object)originalSql);
        }
        catch (Exception var18) {
            logger.error(var18.getMessage(), (Throwable)var18);
        }
    }

    private String getInnerSql(String tableName, List<String> subQueryList, Long userId, String originalSql, String prefix1) {
        int startInx = prefix1.length();
        int suffixInx = startInx + tableName.length();
        int breakInx = 0;
        startInx = this.getStartInx(originalSql, startInx, breakInx);
        suffixInx = this.getSuffixInx(originalSql, suffixInx, breakInx);
        String subOriSql = originalSql.substring(startInx + 1, suffixInx);
        String tableAlias = Optional.ofNullable(SqlUtil.getTableAlias(tableName, subOriSql)).orElse("mt_alias_origin");
        String newSql = SqlUtil.addTableAlias(tableName, tableAlias, subOriSql);
        for (String subQuery : subQueryList) {
            if (StringUtils.isEmpty((Object)subQuery)) continue;
            subQuery = subQuery.replace("MAIN_TABLE_ALIAS", tableAlias).replace("CURRENT_USER_ID", String.valueOf(userId));
            newSql = SqlUtil.appendDataLimit(newSql, subQuery);
        }
        return originalSql.substring(0, startInx + 1) + newSql + originalSql.substring(suffixInx);
    }

    private int getSuffixInx(String originalSql, int suffixInx, int breakInx) {
        while (suffixInx <= originalSql.length()) {
            char c = originalSql.charAt(suffixInx);
            if (c == '(') {
                ++breakInx;
            } else if (c == ')') {
                if (breakInx == 0) break;
                --breakInx;
            }
            ++suffixInx;
        }
        return suffixInx;
    }

    private int getStartInx(String originalSql, int startInx, int breakInx) {
        while (startInx >= 0) {
            char c = originalSql.charAt(startInx);
            if (c == ')') {
                ++breakInx;
            } else if (c == '(') {
                if (breakInx == 0) break;
                --breakInx;
            }
            --startInx;
        }
        return startInx;
    }

    private Class<?> getaClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        return Optional.ofNullable(ServiceContext.getContext().getAttachment(AUTHORITY_SELECTOR)).filter(r -> !StringUtils.isEmpty((Object)r)).map(r -> {
            try {
                return Class.forName(r);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                try {
                    return this.getEoClass(mappedStatement);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }
        }).orElse(this.getEoClass(mappedStatement));
    }

    private Class<?> getEoClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        return EoUtil.getEoClass(classType);
    }

    public Object plugin(Object target) {
        return target instanceof StatementHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties properties) {
    }
}

