/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.tcbj.center.settlement.api.constant.NotifyTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.MessageInformDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PayOrderMqProducerService {
    private Logger logger = LoggerFactory.getLogger(PayOrderMqProducerService.class);
    @Resource
    private ICommonsMqService commonsMqService;

    public void dispatchPayOrderInform(TradeSettlementFlowRespDto tradeFlow, String payResult) {
        this.logger.info("\u8bf7\u6c42\u53d1\u9001\u652f\u4ed8\u7ed3\u679cMQ\uff1a{}=={}", (Object)JSON.toJSONString((Object)tradeFlow), (Object)payResult);
        MessageVo messageVo = new MessageVo();
        MessageInformDto messageInformDto = new MessageInformDto();
        messageInformDto.setTradeNo(tradeFlow.getTradeNo());
        messageInformDto.setOrderNo(tradeFlow.getOptTradeNo());
        messageInformDto.setResultCode(payResult);
        messageInformDto.setPayTime(tradeFlow.getTradePayFinishTime());
        messageInformDto.setPayAmount(tradeFlow.getLaunchTradeAmount());
        messageInformDto.setPayTypeCode(this.getWayType(tradeFlow.getTradePayType(), tradeFlow.getNotifyTradeType()));
        messageInformDto.setUserId(tradeFlow.getLaunchUserId());
        messageVo.setData((Object)JSONObject.toJSONString((Object)messageInformDto));
        this.logger.info(">>>>>>>>>>>>>>>>>>\u652f\u4ed8MQ\u751f\u4ea7\u8005\u670d\u52a1\uff0c\u53d1\u9001\u652f\u4ed8\u7ed3\u679cMQ\uff1a{}", (Object)JSONObject.toJSONString((Object)messageInformDto));
        this.commonsMqService.sendSingleMessage("SETTLEMENT_ORDER_PAY_INFORM", (Object)messageVo);
    }

    private String getWayType(String tradePayType, String notifyTradeType) {
        this.logger.info("\u83b7\u53d6\u4ea4\u6613\u7c7b\u578b\uff1a{}=={}", (Object)tradePayType, (Object)notifyTradeType);
        PaymentWayEnum paymentWayEnum = PaymentWayEnum.fromCode((String)tradePayType);
        if (tradePayType.equals(PaymentWayEnum.WFT_ALIPLY_SM.getPayTypeCode())) {
            return PaymentWayTypeEnum.WFT_ZFB.getCode();
        }
        if (tradePayType.equals(PaymentWayEnum.WFT_WX_GZH.getPayTypeCode())) {
            return PaymentWayTypeEnum.WFT_WX_APP.getCode();
        }
        if (tradePayType.equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
            return PaymentWayTypeEnum.WFT_YE.getCode();
        }
        if (tradePayType.equals(PaymentWayEnum.WFT_UNIFY_SM.getPayTypeCode())) {
            NotifyTradeTypeEnum notifyTradeTypeEnum = NotifyTradeTypeEnum.fromCode((String)notifyTradeType);
            PaymentWayTypeEnum paymentWayTypeEnum = PaymentWayTypeEnum.fromType((String)notifyTradeTypeEnum.getType());
            return paymentWayTypeEnum.getCode();
        }
        return null;
    }
}

