/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransDetailUnverifiedQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.SwiftpassFinanceFileDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailUnverifiedQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileDownloadResultQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.SwiftpassFinanceFileDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SwiftpassFinanceFileRespDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticAccountTransTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticFileTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.SwiftpassTradeStatusEnum;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.api.query.ISwiftpassFinanceFileDetailQueryApi;
import com.dtyunxi.tcbj.api.query.ISwiftpassFinanceFileQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyDealStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyFlagEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifySuccessStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTradePayTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.CupTradeFlowRecordReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.VerifyTradeResultReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.CupTradeFlowRecordRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyTradeResultRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.biz.config.CupFtpConfig;
import com.dtyunxi.tcbj.center.settlement.biz.service.ICupTradeFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyTaskService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyTradeResultService;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyDealBillDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTaskDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTradeResultDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTaskEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTradeResultEo;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.TradeSettlementFlowMapper;
import com.dtyunxi.tcbj.center.settlement.dao.vo.VerifyTradeResultVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VerifyTradeResultServiceImpl
implements IVerifyTradeResultService {
    private Logger logger = LoggerFactory.getLogger(IVerifyTradeResultService.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    private VerifyTradeResultDas verifyTradeResultDas;
    @Resource
    private VerifyTaskDas taskDas;
    @Resource
    private VerifyDealBillDas dealBillDas;
    @Resource
    private ISwiftpassFinanceFileQueryApi fileQueryApi;
    @Resource
    private ISwiftpassFinanceFileDetailQueryApi fileDetailQueryApi;
    @Resource
    private TradeSettlementFlowMapper tradeSettlementFlowMapper;
    @Resource
    private ICiticQueryApi citicQueryApi;
    @Resource
    private IVerifyTaskService taskService;
    @Resource
    private ICupTradeFlowService cupTradeFlowService;
    @Resource
    private CupFtpConfig cupFtpConfig;

    @Override
    public Long addVerifyTradeResult(VerifyTradeResultReqDto addReqDto) {
        VerifyTradeResultEo verifyTradeResultEo = new VerifyTradeResultEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)verifyTradeResultEo);
        this.verifyTradeResultDas.insert((BaseEo)verifyTradeResultEo);
        return verifyTradeResultEo.getId();
    }

    @Override
    public void modifyVerifyTradeResult(VerifyTradeResultReqDto modifyReqDto) {
        VerifyTradeResultEo verifyTradeResultEo = new VerifyTradeResultEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)verifyTradeResultEo);
        this.verifyTradeResultDas.updateSelective((BaseEo)verifyTradeResultEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeVerifyTradeResult(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.verifyTradeResultDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public VerifyTradeResultRespDto queryById(Long id) {
        VerifyTradeResultEo verifyTradeResultEo = (VerifyTradeResultEo)this.verifyTradeResultDas.selectByPrimaryKey(id);
        VerifyTradeResultRespDto verifyTradeResultRespDto = new VerifyTradeResultRespDto();
        DtoHelper.eo2Dto((BaseEo)verifyTradeResultEo, (BaseVo)verifyTradeResultRespDto);
        return verifyTradeResultRespDto;
    }

    @Override
    public PageInfo<VerifyTradeResultRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SimpleDateFormat format;
        VerifyTradeResultReqDto verifyTradeResultReqDto = (VerifyTradeResultReqDto)JSON.parseObject((String)filter, VerifyTradeResultReqDto.class);
        VerifyTradeResultEo verifyTradeResultEo = new VerifyTradeResultEo();
        DtoHelper.dto2Eo((BaseVo)verifyTradeResultReqDto, (BaseEo)verifyTradeResultEo);
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getTaskStatus())) {
            if (verifyTradeResultReqDto.getTaskStatus().equals(VerifyTaskStatusEnum.SUCCESS.getCode())) {
                verifyTradeResultEo.setVerifyStatus(VerifySuccessStatusEnum.SUCCESS.getCode());
            } else if (verifyTradeResultReqDto.getTaskStatus().equals(VerifyTaskStatusEnum.FAIL_WAIT_DEAL.getCode())) {
                verifyTradeResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                verifyTradeResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
            } else if (verifyTradeResultReqDto.getTaskStatus().equals(VerifyTaskStatusEnum.FAIL_HAS_DEAL.getCode())) {
                verifyTradeResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                verifyTradeResultEo.setDealStatus(VerifyDealStatusEnum.YES_DEAL.getCode());
            }
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)verifyTradeResultReqDto.getVerifyDateBegin())) {
            sqlFilterList.add(SqlFilter.ge((String)"verify_date", (Object)verifyTradeResultReqDto.getVerifyDateBegin().replace("-", "").substring(0, 8)));
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyTradeResultReqDto.getVerifyDateEnd())) {
            sqlFilterList.add(SqlFilter.le((String)"verify_date", (Object)verifyTradeResultReqDto.getVerifyDateEnd().replace("-", "").substring(0, 8)));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getBankApplyTimeBegin())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sqlFilterList.add(SqlFilter.ge((String)"bank_apply_time", (Object)format.format(verifyTradeResultReqDto.getBankApplyTimeBegin())));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getBankApplyTimeEnd())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sqlFilterList.add(SqlFilter.le((String)"bank_apply_time", (Object)format.format(verifyTradeResultReqDto.getBankApplyTimeEnd())));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getZhongtaiApplyTimeBegin())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sqlFilterList.add(SqlFilter.ge((String)"zhongtai_apply_time", (Object)format.format(verifyTradeResultReqDto.getZhongtaiApplyTimeBegin())));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getZhongtaiApplyTimeEnd())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sqlFilterList.add(SqlFilter.le((String)"zhongtai_apply_time", (Object)format.format(verifyTradeResultReqDto.getZhongtaiApplyTimeEnd())));
        }
        verifyTradeResultEo.setSqlFilters(sqlFilterList);
        PageInfo eoPageInfo = this.verifyTradeResultDas.selectPage((BaseEo)verifyTradeResultEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, VerifyTradeResultRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<VerifyTradeResultRespDto> queryWaitVerifyByPage(String filter, Integer pageNum, Integer pageSize) {
        SimpleDateFormat format;
        VerifyTradeResultReqDto verifyTradeResultReqDto = (VerifyTradeResultReqDto)JSON.parseObject((String)filter, VerifyTradeResultReqDto.class);
        VerifyTradeResultVo verifyTradeResultVo = new VerifyTradeResultVo();
        BeanUtils.copyProperties((Object)verifyTradeResultReqDto, (Object)verifyTradeResultVo);
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultVo.getVerifyType())) {
            if (verifyTradeResultVo.getVerifyType().equals(VerifyTaskTypeEnum.WFT_PAY.getCode())) {
                verifyTradeResultVo.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
            } else if (verifyTradeResultVo.getVerifyType().equals(VerifyTaskTypeEnum.WFT_TUI_KUAN.getCode())) {
                verifyTradeResultVo.setTradeType(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
            } else if (verifyTradeResultVo.getVerifyType().equals(VerifyTaskTypeEnum.DJB_PAY.getCode())) {
                verifyTradeResultVo.setTradeType(SettlementFlowTradeTypeEnum.ROUTING.getCode());
            } else if (verifyTradeResultVo.getVerifyType().equals(VerifyTaskTypeEnum.DJB_TI_XIAN.getCode())) {
                verifyTradeResultVo.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyTradeResultVo.getVerifyDateBegin())) {
            verifyTradeResultVo.setVerifyDateBegin(verifyTradeResultVo.getVerifyDateBegin() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyTradeResultVo.getVerifyDateEnd())) {
            verifyTradeResultVo.setVerifyDateEnd(verifyTradeResultVo.getVerifyDateEnd() + " 23:59:59");
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getZhongtaiApplyTimeBegin())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            verifyTradeResultVo.setCreateTimeBegin(format.format(verifyTradeResultReqDto.getZhongtaiApplyTimeBegin()));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getZhongtaiApplyTimeEnd())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            verifyTradeResultVo.setCreateTimeEnd(format.format(verifyTradeResultReqDto.getZhongtaiApplyTimeEnd()));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getBankApplyTimeBegin())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            verifyTradeResultVo.setTradePayFinishTimeBegin(format.format(verifyTradeResultReqDto.getBankApplyTimeBegin()));
        }
        if (ObjectUtils.isNotEmpty((Object)verifyTradeResultReqDto.getBankApplyTimeEnd())) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            verifyTradeResultVo.setTradePayFinishTimeEnd(format.format(verifyTradeResultReqDto.getBankApplyTimeEnd()));
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.tradeSettlementFlowMapper.queryWaitVerifyByPage(verifyTradeResultVo, pageNum, pageSize);
        PageInfo voPageInfo = new PageInfo(list);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)voPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)voPageInfo.getList(), VerifyTradeResultRespDto.class);
        if (dtoList.size() > 0) {
            ListIterator iterator = dtoList.listIterator();
            while (iterator.hasNext()) {
                VerifyTradeResultRespDto dto;
                SettlementFlowTradeStatusEnum statusEnum = SettlementFlowTradeStatusEnum.fromCode((String)(dto = (VerifyTradeResultRespDto)iterator.next()).getZhongtaiVerifyStatus());
                dto.setZhongtaiVerifyStatus(statusEnum == null ? "" : statusEnum.getName());
                dto.setTradePayType(VerifyTradePayTypeEnum.getName((String)dto.getTradePayType()));
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void verifyWftPay(String verifyDate) throws Exception {
        this.verifyTrade(VerifyTaskTypeEnum.WFT_PAY.getCode(), SwiftpassTradeStatusEnum.PAY.label, SettlementFlowTradeTypeEnum.PAY.getCode(), verifyDate);
    }

    @Override
    public void verifyWftTuiKuanFlow(String verifyDate) throws Exception {
        this.verifyTrade(VerifyTaskTypeEnum.WFT_TUI_KUAN.getCode(), SwiftpassTradeStatusEnum.REFUND.label, SettlementFlowTradeTypeEnum.PAY_REFUND.getCode(), verifyDate);
    }

    @Override
    public void verifyDjpPayFlow(String verifyDate) throws Exception {
        this.verifyTrade(VerifyTaskTypeEnum.DJB_PAY.getCode(), CiticAccountTransTypeEnum.ACCOUNT_TRANS.key, SettlementFlowTradeTypeEnum.ROUTING.getCode(), verifyDate);
    }

    @Override
    public void verifyDjpTiXianFlow(String verifyDate) throws Exception {
        this.verifyTrade(VerifyTaskTypeEnum.DJB_TI_XIAN.getCode(), CiticAccountTransTypeEnum.WITHDRAW.key, SettlementFlowTradeTypeEnum.WITHDRAW.getCode(), verifyDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyTrade(Integer verifyType, String tradeStatus, String tradeType, String verifyDate) throws Exception {
        VerifyTaskEo searchTaskEo = new VerifyTaskEo();
        searchTaskEo.setVerifyDate(verifyDate);
        searchTaskEo.setVerifyType(verifyType);
        VerifyTaskEo taskEo = (VerifyTaskEo)this.taskDas.selectOne((BaseEo)searchTaskEo);
        if (taskEo == null) {
            taskEo = new VerifyTaskEo();
            taskEo.setVerifyDate(verifyDate);
            taskEo.setVerifyType(verifyType);
            taskEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
            taskEo.setRemark("\u5bf9\u8d26\u4e2d");
            taskEo.setCiticVerifyNum(Integer.valueOf(0));
            taskEo.setZhongtaiVerifyNum(Integer.valueOf(0));
            taskEo.setSuccessNum(Integer.valueOf(0));
            taskEo.setFailNum(Integer.valueOf(0));
            taskEo.setDiffBalanceNum(Integer.valueOf(0));
            taskEo.setDiffStatusNum(Integer.valueOf(0));
            taskEo.setSuccessNum(Integer.valueOf(0));
            taskEo.setLongNum(Integer.valueOf(0));
            taskEo.setShortNum(Integer.valueOf(0));
            taskEo.setTaskNum(Integer.valueOf(0));
            this.taskDas.insert((BaseEo)taskEo);
        }
        if (taskEo.getTaskStatus().equals(VerifyTaskStatusEnum.WAIT_DOING.getCode())) {
            VerifyTaskEo updateEo = new VerifyTaskEo();
            updateEo.setId(taskEo.getId());
            updateEo.setTaskNum(Integer.valueOf(taskEo.getTaskNum() + 1));
            try {
                if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode()) || tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                    this.verifyTrade_CupPayAndRefund(taskEo, updateEo, tradeStatus, tradeType);
                } else if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode()) || tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
                    this.verifyTrade_DjbPayAndTixian(taskEo, updateEo, tradeStatus, tradeType, verifyDate);
                }
            }
            catch (Exception e) {
                updateEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
                updateEo.setRemark(e.getMessage().length() > 900 ? e.getMessage().substring(1, 900) : e.getMessage());
            }
            finally {
                updateEo.setCiticVerifyNum(taskEo.getCiticVerifyNum());
                updateEo.setZhongtaiVerifyNum(taskEo.getZhongtaiVerifyNum());
                updateEo.setSuccessNum(taskEo.getSuccessNum());
                updateEo.setFailNum(taskEo.getFailNum());
                updateEo.setDiffBalanceNum(taskEo.getDiffBalanceNum());
                updateEo.setSuccessNum(taskEo.getSuccessNum());
                updateEo.setLongNum(taskEo.getLongNum());
                updateEo.setShortNum(taskEo.getShortNum());
                if (taskEo.getFailNum() > 0) {
                    updateEo.setTaskStatus(VerifyTaskStatusEnum.FAIL_WAIT_DEAL.getCode());
                }
                this.taskDas.updateSelective((BaseEo)updateEo);
            }
        }
    }

    public void verifyTrade_WftPayAndRefund(VerifyTaskEo taskEo, VerifyTaskEo updateEo, String tradeStatus, String tradeType, String verifyDate) {
        RestResponse fileResp = this.fileQueryApi.queryByBillDate(taskEo.getVerifyDate());
        SwiftpassFinanceFileRespDto fileRespDto = (SwiftpassFinanceFileRespDto)RestResponseHelper.extractData((RestResponse)fileResp);
        Integer seriesNo = new Integer(0);
        if (fileRespDto == null || ObjectUtils.isEmpty((Object)fileRespDto.getId())) {
            updateEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
            updateEo.setRemark("\u3010\u5bf9\u8d26\u5931\u8d25\u3011\u652f\u4ed8\u4e2d\u5fc3\u5a01\u5bcc\u901a\u5bf9\u8d26\u6587\u4ef6\u83b7\u53d6\u5931\u8d25");
        } else {
            boolean hasData = true;
            SwiftpassFinanceFileDetailReqDto detailReqDto = new SwiftpassFinanceFileDetailReqDto();
            detailReqDto.setFileId(fileRespDto.getId());
            detailReqDto.setVerifyStatus(VerifyFlagEnum.NO.getCode());
            detailReqDto.setTradeStatus(tradeStatus);
            String filter = JSONObject.toJSONString((Object)detailReqDto);
            while (hasData) {
                RestResponse pageInfoRestResponse = this.fileDetailQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1000));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
                if (pageInfo.getSize() == 0) {
                    hasData = false;
                    continue;
                }
                for (SwiftpassFinanceFileDetailRespDto detailItemDto : pageInfo.getList()) {
                    this.taskService.wftFlowVerifyByBankToZhongtai(detailItemDto, taskEo, tradeType);
                }
            }
            String timeBegin = taskEo.getVerifyDate().substring(0, 4) + "-" + taskEo.getVerifyDate().substring(4, 6) + "-" + taskEo.getVerifyDate().substring(6, 8) + " 00:00:00";
            String timeEnd = taskEo.getVerifyDate().substring(0, 4) + "-" + taskEo.getVerifyDate().substring(4, 6) + "-" + taskEo.getVerifyDate().substring(6, 8) + " 23:59:59";
            List zhontaiFlowList = this.tradeSettlementFlowMapper.queryNoVerifyTradeFlow(timeBegin, timeEnd, VerifyFlagEnum.NO.getCode(), tradeType);
            this.taskService.flowVerifyByZhongtaiToBank(zhontaiFlowList, taskEo, tradeType);
            updateEo.setTaskStatus(VerifyTaskStatusEnum.SUCCESS.getCode());
            updateEo.setRemark("\u5bf9\u8d26\u6210\u529f");
        }
    }

    public void verifyTrade_CupPayAndRefund(VerifyTaskEo taskEo, VerifyTaskEo updateEo, String tradeStatus, String tradeType) {
        this.logger.info("\u94f6\u8054\u652f\u4ed8\uff0c\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26\uff1a{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{JSON.toJSONString((Object)taskEo), JSON.toJSONString((Object)updateEo), tradeStatus, tradeType});
        AssertUtils.notBlank((String)taskEo.getVerifyDate(), (String)"\u65e0\u5bf9\u8d26\u65e5\u671f");
        CupTradeFlowRecordReqDto reqDto = new CupTradeFlowRecordReqDto();
        reqDto.setFileName(this.cupFtpConfig.fileName(taskEo.getVerifyDate()));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setTradeType(tradeType);
        PageInfo<CupTradeFlowRecordRespDto> pageInfo = this.cupTradeFlowService.queryRecordPage(reqDto);
        while (CollectionUtil.isNotEmpty((Collection)pageInfo.getList()) && pageInfo.getList().size() > 0) {
            pageInfo.getList().forEach(dto -> {
                SwiftpassFinanceFileDetailRespDto respDto = new SwiftpassFinanceFileDetailRespDto();
                respDto.setId(dto.getId());
                respDto.setOutTradeNo(dto.getFlowNo());
                respDto.setOutRefundNo(dto.getRefundOrderNo());
                respDto.setTotalFee(new BigDecimal(dto.getPayAmount()));
                respDto.setRefundFee(dto.getPayAmount());
                respDto.setTransactionId(dto.getMerchantOrderNo());
                respDto.setRefundId(dto.getMerchantOrderNo());
                respDto.setPoundage(new BigDecimal(dto.getFeeAmount()));
                respDto.setTradeTime(this.parseDateAndTime(dto.getTradeDate(), dto.getTradeTime()));
                respDto.setService(dto.getTradeType());
                respDto.setSettlementFee(new BigDecimal(dto.getClearAmount()));
                this.taskService.wftFlowVerifyByBankToZhongtai(respDto, taskEo, tradeType);
            });
            reqDto.setPageNum(Integer.valueOf(reqDto.getPageNum() + 1));
            pageInfo = this.cupTradeFlowService.queryRecordPage(reqDto);
        }
        String timeBegin = taskEo.getVerifyDate().substring(0, 4) + "-" + taskEo.getVerifyDate().substring(4, 6) + "-" + taskEo.getVerifyDate().substring(6, 8) + " 00:00:00";
        String timeEnd = taskEo.getVerifyDate().substring(0, 4) + "-" + taskEo.getVerifyDate().substring(4, 6) + "-" + taskEo.getVerifyDate().substring(6, 8) + " 23:59:59";
        List zhontaiFlowList = this.tradeSettlementFlowMapper.queryNoVerifyTradeFlow(timeBegin, timeEnd, VerifyFlagEnum.NO.getCode(), tradeType);
        this.taskService.flowVerifyByZhongtaiToBank(zhontaiFlowList, taskEo, tradeType);
        updateEo.setTaskStatus(VerifyTaskStatusEnum.SUCCESS.getCode());
        updateEo.setRemark("\u5bf9\u8d26\u6210\u529f");
    }

    private Date parseDateAndTime(String date, String time) {
        try {
            return this.dateFormat.parse(date + " " + time);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void verifyTrade_DjbPayAndTixian(VerifyTaskEo taskEo, VerifyTaskEo updateEo, String tradeStatus, String tradeType, String verifyDate) throws Exception {
        Integer seriesNo = new Integer(0);
        RestResponse fileResp = this.citicQueryApi.fileDownloadResultQuery(CiticFileTypeEnum.TRANS_DETAIL.key, taskEo.getVerifyDate());
        CiticFileDownloadResultQueryResDto citicFileDto = (CiticFileDownloadResultQueryResDto)RestResponseHelper.extractData((RestResponse)fileResp);
        if (ObjectUtils.isNotEmpty((Object)citicFileDto) && citicFileDto.getDownloadSuccess().booleanValue()) {
            boolean hasData = true;
            CiticAccountTransDetailUnverifiedQueryReqDto citicReqDto = new CiticAccountTransDetailUnverifiedQueryReqDto();
            citicReqDto.setTransDate(taskEo.getVerifyDate());
            citicReqDto.setTransType(tradeStatus);
            citicReqDto.setVerifyFlag(VerifyFlagEnum.NO.getCode());
            citicReqDto.setSize(Integer.valueOf(10000));
            while (hasData) {
                RestResponse citicTransResp = this.citicQueryApi.accountTransDetailUnverifiedQuery(citicReqDto);
                List citicTransList = (List)RestResponseHelper.extractData((RestResponse)citicTransResp);
                if (citicTransList.size() == 0) {
                    hasData = false;
                    continue;
                }
                for (CiticAccountTransDetailUnverifiedQueryResDto detailItemDto : citicTransList) {
                    this.taskService.djbFlowVerifyByBankToZhongtai(detailItemDto, taskEo, tradeType);
                }
            }
            List zhontaiFlowList = null;
            String timeBegin = taskEo.getVerifyDate().substring(0, 4) + "-" + taskEo.getVerifyDate().substring(4, 6) + "-" + taskEo.getVerifyDate().substring(6, 8) + " 00:00:00";
            String timeEnd = taskEo.getVerifyDate().substring(0, 4) + "-" + taskEo.getVerifyDate().substring(4, 6) + "-" + taskEo.getVerifyDate().substring(6, 8) + " 23:59:59";
            zhontaiFlowList = tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode()) ? this.tradeSettlementFlowMapper.queryNoVerifyDjbPayTradeFlow(timeBegin, timeEnd, VerifyFlagEnum.NO.getCode()) : this.tradeSettlementFlowMapper.queryNoVerifyDjbWithDrawTradeFlow(timeBegin, timeEnd, VerifyFlagEnum.NO.getCode(), tradeType);
            this.taskService.flowVerifyByZhongtaiToBank(zhontaiFlowList, taskEo, tradeType);
            updateEo.setTaskStatus(VerifyTaskStatusEnum.SUCCESS.getCode());
            updateEo.setRemark("\u5bf9\u8d26\u6210\u529f");
        } else {
            updateEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
            updateEo.setRemark("\u3010\u5bf9\u8d26\u5931\u8d25\u3011\u652f\u4ed8\u4e2d\u5fc3\u767b\u8bb0\u7c3f\u8d44\u91d1\u53d8\u52a8\u660e\u7ec6\u6587\u4ef6\u83b7\u53d6\u5931\u8d25");
        }
    }
}

