/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountPasswordReqDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountPasswordService;
import com.dtyunxi.tcbj.center.settlement.dao.das.SafeMobileDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementOrganizationPasswordDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SafeMobileEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementOrganizationPasswordEo;
import com.dtyunxi.yundt.cube.center.identity.api.v3.IVerifyCodeApi;
import com.dtyunxi.yundt.cube.center.payment.util.SignUtil;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SettlementAccountPasswordServiceImpl
implements ISettlementAccountPasswordService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LEGAL_CARD_TYPE = "1";
    private static final Integer MOBILE_VERIFY_TYPE = 2;
    private static final String SALT_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @Resource
    private SettlementOrganizationPasswordDas settlementOrganizationPasswordDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IVerifyCodeApi verifyCodeApi;
    @Resource
    private SafeMobileDas safeMobileDas;

    @Override
    public void addSettlementAccountPassword(SettlementAccountPasswordReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getOrgId(), (String)"\u7528\u6237\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.checkReq(addReqDto);
        RestResponse orgInfoRespDtoRestResp = this.organizationQueryApi.queryOrgAndOrgInfo(addReqDto.getOrgId());
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)orgInfoRespDtoRestResp);
        AssertUtils.notNull((Object)orgInfoRespDto, (String)String.format("\u7ec4\u7ec7\u4fe1\u606f\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", addReqDto.getOrgId()));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationInfoDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationInfoDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", addReqDto.getOrgId()));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", addReqDto.getOrgId()));
        this.checkIdCardAndMobile(addReqDto, orgInfoRespDto.getOrganizationInfoDto());
        addReqDto.setOrgInfoId(orgInfoRespDto.getOrganizationInfoDto().getId());
        addReqDto.setOrgCode(orgInfoRespDto.getOrganizationDto().getCode());
        SettlementOrganizationPasswordEo accountPasswordEo = this.getAccountPassword(addReqDto);
        int number = new Random().nextInt(10) + 1;
        String salt = this.getRandomString(number);
        String newPassword = addReqDto.getUserPassword();
        try {
            newPassword = SignUtil.MD5((String)(newPassword + salt));
        }
        catch (Exception e) {
            throw SettlementExceptionCode.MD5_ENCRY_FAIL.getException();
        }
        if (accountPasswordEo == null) {
            this.logger.info("\u3010\u652f\u4ed8\u5bc6\u7801\u3011\u7528\u6237(\u6863\u6848id={}\uff0c\u7ec4\u7ec7\u7f16\u7801={})\u65b0\u589e\u652f\u4ed8\u5bc6\u7801", (Object)addReqDto.getOrgInfoId(), (Object)addReqDto.getOrgCode());
            accountPasswordEo = new SettlementOrganizationPasswordEo();
            accountPasswordEo.setOrgId(addReqDto.getOrgId());
            accountPasswordEo.setOrgInfoId(addReqDto.getOrgInfoId());
            accountPasswordEo.setOrgCode(addReqDto.getOrgCode());
            accountPasswordEo.setUserPassword(newPassword);
            accountPasswordEo.setSalt(salt);
            this.settlementOrganizationPasswordDas.insert((BaseEo)accountPasswordEo);
        } else {
            SettlementOrganizationPasswordEo updateEo = new SettlementOrganizationPasswordEo();
            updateEo.setId(accountPasswordEo.getId());
            updateEo.setUserPassword(newPassword);
            updateEo.setSalt(salt);
            this.settlementOrganizationPasswordDas.updateSelective((BaseEo)updateEo);
        }
    }

    private void checkIdCardAndMobile(SettlementAccountPasswordReqDto addReqDto, OrganizationInfoDto organizationInfoDto) {
        AssertUtils.notBlank((String)addReqDto.getCardCode(), (String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notBlank((String)addReqDto.getUniqueId(), (String)"uniqueId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!StringUtils.equals((CharSequence)organizationInfoDto.getLegalCardNum(), (CharSequence)addReqDto.getCardCode())) {
            this.logger.info("\u3010\u652f\u4ed8\u5bc6\u7801\u3011\u8bc1\u4ef6\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u4e3a\uff1a{},\u7ec4\u7ec7\u4fe1\u606f\u4e2d\u7684\u8bc1\u4ef6\u4fe1\u606f\u4e3a\uff1a{}", (Object)addReqDto.getCardCode(), (Object)organizationInfoDto.getLegalCardNum());
            throw SettlementExceptionCode.CARDCODE_ERROR.getException();
        }
        RestResponse restResponse = this.verifyCodeApi.checkVerifyCode(addReqDto.getMobileCode(), addReqDto.getUniqueId(), MOBILE_VERIFY_TYPE);
        Boolean verifyResult = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (!verifyResult.booleanValue()) {
            this.logger.info("\u3010\u652f\u4ed8\u5bc6\u7801\u3011\u63d0\u4ea4\u7684\u4fe1\u606f\u6709\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw SettlementExceptionCode.MOBIL_NOT_EXIT.getException();
        }
    }

    private String getRandomString(int length) {
        StringBuffer sb = new StringBuffer();
        int len = SALT_STRING.length();
        for (int i = 0; i < length; ++i) {
            sb.append(SALT_STRING.charAt(this.getRandom(len - 1)));
        }
        return sb.toString();
    }

    private int getRandom(int count) {
        return (int)Math.round(Math.random() * (double)count);
    }

    private SettlementOrganizationPasswordEo getAccountPassword(SettlementAccountPasswordReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getOrgId(), (String)"\u7528\u6237\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SettlementOrganizationPasswordEo queryPasswordEo = new SettlementOrganizationPasswordEo();
        queryPasswordEo.setOrgInfoId(addReqDto.getId());
        queryPasswordEo.setOrgId(addReqDto.getOrgId());
        return (SettlementOrganizationPasswordEo)this.settlementOrganizationPasswordDas.selectOne((BaseEo)queryPasswordEo);
    }

    private void checkReq(SettlementAccountPasswordReqDto addReqDto) {
        if (!StringUtils.equals((CharSequence)addReqDto.getUserPassword(), (CharSequence)addReqDto.getReUserPassword())) {
            throw SettlementExceptionCode.PASSWORD_NOT_INCONFORMITY.getException();
        }
    }

    @Override
    public void modifySettlementAccountPassword(SettlementAccountPasswordReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getOrgId(), (String)"\u7528\u6237\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RestResponse orgInfoRespDtoRestResp = this.organizationQueryApi.queryOrgAndOrgInfo(modifyReqDto.getOrgId());
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)orgInfoRespDtoRestResp);
        AssertUtils.notNull((Object)orgInfoRespDto, (String)String.format("\u7ec4\u7ec7\u4fe1\u606f\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", modifyReqDto.getOrgId()));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationInfoDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationInfoDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", modifyReqDto.getOrgId()));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", modifyReqDto.getOrgId()));
        modifyReqDto.setOrgInfoId(orgInfoRespDto.getOrganizationInfoDto().getId());
        modifyReqDto.setOrgCode(orgInfoRespDto.getOrganizationDto().getCode());
        this.checkReq(modifyReqDto);
        String oldPassword = modifyReqDto.getOldPassword();
        SettlementOrganizationPasswordEo accountPassword = this.getAccountPassword(modifyReqDto);
        AssertUtils.notNull((Object)accountPassword, (String)String.format("\u5ba2\u6237(\u6863\u6848id=%s,\u7ec4\u7ec7id=%s)\u4fe1\u606f\u6709\u5f02\u5e38\uff0c\u539f\u59cb\u5bc6\u7801\u4e0d\u5b58\u5728\uff01", modifyReqDto.getOrgInfoId(), modifyReqDto.getOrgId()));
        String salt = accountPassword.getSalt();
        String userPassword = accountPassword.getUserPassword();
        try {
            oldPassword = SignUtil.MD5((String)(oldPassword + salt));
        }
        catch (Exception e) {
            throw SettlementExceptionCode.MD5_ENCRY_FAIL.getException();
        }
        if (!StringUtils.equals((CharSequence)oldPassword, (CharSequence)userPassword)) {
            throw SettlementExceptionCode.OLD_PASSWORD_ERROR.getException();
        }
        int number = new Random().nextInt(10) + 1;
        String newSalt = this.getRandomString(number);
        String newPassword = modifyReqDto.getUserPassword();
        try {
            newPassword = SignUtil.MD5((String)(newPassword + newSalt));
        }
        catch (Exception e) {
            throw SettlementExceptionCode.MD5_ENCRY_FAIL.getException();
        }
        SettlementOrganizationPasswordEo updatePasswordEo = new SettlementOrganizationPasswordEo();
        updatePasswordEo.setId(accountPassword.getId());
        updatePasswordEo.setUserPassword(newPassword);
        updatePasswordEo.setSalt(newSalt);
        this.settlementOrganizationPasswordDas.updateSelective((BaseEo)updatePasswordEo);
    }

    @Override
    public Map<String, Object> queryPasswordExit(SettlementAccountPasswordReqDto reqDto) {
        SettlementOrganizationPasswordEo organizationPasswordEo = this.getAccountPassword(reqDto);
        Boolean isExit = organizationPasswordEo != null ? Boolean.TRUE : Boolean.FALSE;
        OrgAndOrgInfoRespDto orgInfo = this.getOrgInfo(reqDto.getOrgId());
        SafeMobileEo queryEo = new SafeMobileEo();
        queryEo.setOrgInfoId(orgInfo.getOrganizationInfoDto().getId());
        queryEo.setOrgId(reqDto.getOrgId());
        SafeMobileEo safeMobileEo = (SafeMobileEo)this.safeMobileDas.selectOne((BaseEo)queryEo);
        String phone = safeMobileEo != null ? safeMobileEo.getPhone() : null;
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("passworExit", isExit);
        resultMap.put("phone", phone);
        return resultMap;
    }

    private OrgAndOrgInfoRespDto getOrgInfo(Long orgId) {
        RestResponse orgInfoRespDtoRestResp = this.organizationQueryApi.queryOrgAndOrgInfo(orgId);
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)orgInfoRespDtoRestResp);
        AssertUtils.notNull((Object)orgInfoRespDto, (String)String.format("\u7ec4\u7ec7\u4fe1\u606f\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", orgId));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationInfoDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationInfoDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", orgId));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", orgId));
        return orgInfoRespDto;
    }

    @Override
    public Boolean checkPasswork(SettlementAccountPasswordReqDto reqDto) {
        String password;
        AssertUtils.notNull((Object)reqDto.getOrgId(), (String)"\u7528\u6237\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqDto.getUserPassword(), (String)"\u652f\u4ed8\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RestResponse orgInfoRespDtoRestResp = this.organizationQueryApi.queryOrgAndOrgInfo(reqDto.getOrgId());
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)orgInfoRespDtoRestResp);
        AssertUtils.notNull((Object)orgInfoRespDto, (String)String.format("\u7ec4\u7ec7\u4fe1\u606f\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", reqDto.getOrgId()));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationInfoDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationInfoDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", reqDto.getOrgId()));
        AssertUtils.notNull((Object)orgInfoRespDto.getOrganizationDto(), (String)String.format("\u7ec4\u7ec7\u4fe1\u606f(OrganizationDto)\u8868\u4e0d\u5b58\u5728\uff0corgId=%s", reqDto.getOrgId()));
        reqDto.setOrgInfoId(orgInfoRespDto.getOrganizationInfoDto().getId());
        reqDto.setOrgCode(orgInfoRespDto.getOrganizationDto().getCode());
        SettlementOrganizationPasswordEo accountPasswordEo = this.getAccountPassword(reqDto);
        if (accountPasswordEo == null) {
            throw SettlementExceptionCode.PASSWOR_NOT_EXIT.getException();
        }
        String salt = accountPasswordEo.getSalt();
        String userPassword = accountPasswordEo.getUserPassword();
        try {
            password = SignUtil.MD5((String)(reqDto.getUserPassword() + salt));
        }
        catch (Exception e) {
            throw SettlementExceptionCode.MD5_ENCRY_FAIL.getException();
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)userPassword)) {
            throw SettlementExceptionCode.PASSWORD_ERROR.getException();
        }
        return Boolean.TRUE;
    }
}

