/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransDetailUnverifiedQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransVerifyReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailUnverifiedQueryResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticAccountTransTypeEnum;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyBillTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyDealStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyFlagEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyResultEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.VerifyDealBillReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyDealBillRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyDealBillService;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyDealBillDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTaskDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTradeResultDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyDealBillEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTaskEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTradeResultEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VerifyDealBillServiceImpl
implements IVerifyDealBillService {
    private Logger logger = LoggerFactory.getLogger(VerifyDealBillServiceImpl.class);
    @Resource
    private VerifyDealBillDas verifyDealBillDas;
    @Resource
    private VerifyTradeResultDas verifyTradeResultDas;
    @Resource
    private ICiticQueryApi citicQueryApi;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private VerifyTaskDas verifyTaskDas;
    @Resource
    private ICiticApi citicApi;

    @Override
    public Long addVerifyDealBill(VerifyDealBillReqDto addReqDto) {
        VerifyDealBillEo verifyDealBillEo = new VerifyDealBillEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)verifyDealBillEo);
        this.verifyDealBillDas.insert((BaseEo)verifyDealBillEo);
        return verifyDealBillEo.getId();
    }

    @Override
    public void modifyVerifyDealBill(VerifyDealBillReqDto modifyReqDto) {
        VerifyDealBillEo verifyDealBillEo = new VerifyDealBillEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)verifyDealBillEo);
        this.verifyDealBillDas.updateSelective((BaseEo)verifyDealBillEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeVerifyDealBill(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.verifyDealBillDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public VerifyDealBillRespDto queryById(Long id) {
        VerifyDealBillEo verifyDealBillEo = (VerifyDealBillEo)this.verifyDealBillDas.selectByPrimaryKey(id);
        VerifyDealBillRespDto verifyDealBillRespDto = new VerifyDealBillRespDto();
        DtoHelper.eo2Dto((BaseEo)verifyDealBillEo, (BaseVo)verifyDealBillRespDto);
        return verifyDealBillRespDto;
    }

    @Override
    public PageInfo<VerifyDealBillRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        VerifyDealBillReqDto verifyDealBillReqDto = (VerifyDealBillReqDto)JSON.parseObject((String)filter, VerifyDealBillReqDto.class);
        VerifyDealBillEo verifyDealBillEo = new VerifyDealBillEo();
        DtoHelper.dto2Eo((BaseVo)verifyDealBillReqDto, (BaseEo)verifyDealBillEo);
        PageInfo eoPageInfo = this.verifyDealBillDas.selectPage((BaseEo)verifyDealBillEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, VerifyDealBillRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void dealDuanKuanBill() {
        VerifyDealBillEo seo = new VerifyDealBillEo();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(VerifyDealBillEo::getDealStatus, (Object)VerifyDealStatusEnum.WAIT_DEAL.getCode());
        ArrayList<Integer> billTypeList = new ArrayList<Integer>();
        billTypeList.add(VerifyBillTypeEnum.DJB_WITHDRAW_DUANKUAN_DEAL.getCode());
        queryWrapper.in(VerifyDealBillEo::getBillType, billTypeList);
        List billEos = this.verifyDealBillDas.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)billEos)) {
            for (VerifyDealBillEo billEo : billEos) {
                try {
                    String re;
                    VerifyTradeResultEo tradeResultEo = (VerifyTradeResultEo)this.verifyTradeResultDas.selectByPrimaryKey(billEo.getResultId());
                    if (!billEo.getBillType().equals(VerifyBillTypeEnum.DJB_WITHDRAW_DUANKUAN_DEAL.getCode())) continue;
                    CiticAccountTransDetailUnverifiedQueryReqDto citicReqDto = new CiticAccountTransDetailUnverifiedQueryReqDto();
                    citicReqDto.setBussId(tradeResultEo.getParentTradeNo());
                    citicReqDto.setVerifyFlag(VerifyFlagEnum.NO.getCode());
                    citicReqDto.setSize(Integer.valueOf(10));
                    citicReqDto.setTransType(CiticAccountTransTypeEnum.WITHDRAW.key);
                    RestResponse citicTransResp = this.citicQueryApi.accountTransDetailUnverifiedQuery(citicReqDto);
                    List citicTransList = (List)RestResponseHelper.extractData((RestResponse)citicTransResp);
                    if (!CollectionUtils.isNotEmpty((Collection)citicTransList)) continue;
                    CiticAccountTransDetailUnverifiedQueryResDto citicTransDetailResDto = (CiticAccountTransDetailUnverifiedQueryResDto)citicTransList.get(0);
                    TradeSettlementFlowEo seaFlowEo = new TradeSettlementFlowEo();
                    seaFlowEo.setOptTradeNo(tradeResultEo.getParentTradeNo());
                    TradeSettlementFlowEo flowEo = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)seaFlowEo);
                    BigDecimal bankAmt = new BigDecimal(citicTransDetailResDto.getTransAmt());
                    VerifyTradeResultEo updateVerifyResultEo = new VerifyTradeResultEo();
                    updateVerifyResultEo.setId(tradeResultEo.getId());
                    VerifyDealBillEo upBillEo = new VerifyDealBillEo();
                    upBillEo.setId(billEo.getId());
                    VerifyTaskEo taskEo = (VerifyTaskEo)this.verifyTaskDas.selectByPrimaryKey(billEo.getTaskId());
                    VerifyTaskEo upTaskEo = new VerifyTaskEo();
                    upTaskEo.setId(billEo.getTaskId());
                    if (flowEo.getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                        if (flowEo.getTradeAmount().compareTo(bankAmt) == 0) {
                            updateVerifyResultEo.setDealStatus(VerifyDealStatusEnum.YES_DEAL.getCode());
                            upBillEo.setDealStatus(VerifyDealStatusEnum.YES_DEAL.getCode());
                            re = (StringUtils.isNotBlank((CharSequence)billEo.getRemark()) ? billEo.getRemark() + "\n" : "") + "\u3010" + LocalDateTime.now().toString() + "\u3011\u5b9a\u65f6\u66f4\u65b0\u5904\u7406,\u7531\u77ed\u6b3e->\u6210\u529f;";
                            upBillEo.setRemark(re);
                            upTaskEo.setFailDealNum(Integer.valueOf(taskEo.getFailDealNum() + 1));
                            upTaskEo.setFailNum(Integer.valueOf(taskEo.getFailNum() - 1));
                        } else {
                            updateVerifyResultEo.setVerifyResult(VerifyResultEnum.DJB_WITHDRAW_BALANCE_DIFF.getName());
                            upBillEo.setBillType(VerifyBillTypeEnum.DJB_WITHDRAW_BALANCE_DIFF_DEAL.getCode());
                            upBillEo.setErrorBigType(VerifyResultEnum.DJB_WITHDRAW_BALANCE_DIFF.getErrorBigType());
                            upBillEo.setErrorSmallType(VerifyResultEnum.DJB_WITHDRAW_BALANCE_DIFF.getErrorSmallType());
                            re = (StringUtils.isNotBlank((CharSequence)billEo.getRemark()) ? billEo.getRemark() + "\n" : "") + "\u3010" + LocalDateTime.now().toString() + "\u3011\u5b9a\u65f6\u66f4\u65b0\u5904\u7406\uff0c\u7531\u77ed\u6b3e->\u91d1\u989d\u4e0d\u4e00\u81f4;";
                            upBillEo.setRemark(re);
                            upTaskEo.setDiffBalanceNum(Integer.valueOf(taskEo.getDiffBalanceNum() + 1));
                        }
                    } else {
                        updateVerifyResultEo.setVerifyResult(VerifyResultEnum.DJB_WITHDRAW_STATUS_ZHONGTAI_FAIL.getName());
                        upBillEo.setBillType(VerifyBillTypeEnum.DJB_WITHDRAW_STATUS_ZHONGTAI_FAIL_DEAL.getCode());
                        upBillEo.setErrorBigType(VerifyResultEnum.DJB_WITHDRAW_STATUS_ZHONGTAI_FAIL.getErrorBigType());
                        upBillEo.setErrorSmallType(VerifyResultEnum.DJB_WITHDRAW_STATUS_ZHONGTAI_FAIL.getErrorSmallType());
                        re = (StringUtils.isNotBlank((CharSequence)billEo.getRemark()) ? billEo.getRemark() + "\n" : "") + "\u3010" + LocalDateTime.now().toString() + "\u3011\u5b9a\u65f6\u66f4\u65b0\u5904\u7406\uff0c\u7531\u77ed\u6b3e->\u91d1\u989d\u4e0d\u4e00\u81f4;";
                        upBillEo.setRemark(re);
                        upTaskEo.setDiffStatusNum(taskEo.getDiffStatusNum());
                    }
                    upTaskEo.setShortNum(Integer.valueOf(taskEo.getShortNum() - 1));
                    updateVerifyResultEo.setOptAccountName(citicTransDetailResDto.getUserName());
                    updateVerifyResultEo.setOptAccountNo(citicTransDetailResDto.getUserId());
                    updateVerifyResultEo.setSettlementAccountName(citicTransDetailResDto.getOanm());
                    updateVerifyResultEo.setSettlementAccountNo(citicTransDetailResDto.getGoac());
                    updateVerifyResultEo.setTradePayTradeChannelId(citicTransDetailResDto.getUserSsn());
                    updateVerifyResultEo.setTradePaidAmount(bankAmt);
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                    Date bankApplyTime = format.parse(citicTransDetailResDto.getTransDt() + citicTransDetailResDto.getTransTm());
                    updateVerifyResultEo.setBankApplyTime(bankApplyTime);
                    upBillEo.setBankFlowNo(citicTransDetailResDto.getUserSsn());
                    this.verifyDealBillDas.updateSelective((BaseEo)upBillEo);
                    this.verifyTradeResultDas.updateSelective((BaseEo)updateVerifyResultEo);
                    this.verifyTaskDas.updateSelective((BaseEo)upTaskEo);
                    CiticAccountTransVerifyReqDto dto = new CiticAccountTransVerifyReqDto();
                    dto.setId(((CiticAccountTransDetailUnverifiedQueryResDto)citicTransList.get(0)).getId());
                    dto.setVerifyFlag(VerifyFlagEnum.YES.getCode());
                    this.citicApi.accountTransVerify(dto);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

