/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.FlowVo;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.service.IWithdrawBalanceService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WithdrawBalanceServiceImpl
implements IWithdrawBalanceService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private SettlementAccountFlowDas accountFlowDas;
    @Resource
    private SettlementAccountDas accountDas;
    @Resource
    private SettlementAccountOptService accountOptService;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createFlow(FlowVo reqDto) {
        reqDto.setLinkedParentTradeNo(TradeUtil.generateTradeParentFlowNo());
        reqDto.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
        TradeSettlementFlowEo tradeSettlementFlow = this.createTradeSettlementFlow(reqDto);
        AccountOptReqDto accountOptReqDto = new AccountOptReqDto();
        accountOptReqDto.setAccountNo(reqDto.getAccountNo());
        accountOptReqDto.setFrozen(reqDto.getBalance());
        accountOptReqDto.setLinkedTradeNo(tradeSettlementFlow.getTradeNo());
        accountOptReqDto.setLinkedParentTradeNo(tradeSettlementFlow.getParentTradeNo());
        accountOptReqDto.setAccountFlowType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
        accountOptReqDto.setChangeBalance(reqDto.getBalance());
        accountOptReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
        accountOptReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
        accountOptReqDto.setChangTime(new Date());
        accountOptReqDto.setType(Integer.valueOf(1));
        accountOptReqDto.setWithdramCardId(reqDto.getWithdramCardId());
        accountOptReqDto.setWithdramCardJson(reqDto.getWithdramCardJson());
        SettlementAccountFlowRespDto settlementAccountFlowRespDto = this.accountOptService.optAccountFrozen(accountOptReqDto);
        reqDto.setAccountFlowNo(settlementAccountFlowRespDto.getAccountFlowNo());
        reqDto.setAccountFlowId(settlementAccountFlowRespDto.getId());
        TradeSettlementFlowEo updateFlowEo = new TradeSettlementFlowEo();
        updateFlowEo.setId(tradeSettlementFlow.getId());
        updateFlowEo.setOptAccountFlowNo(settlementAccountFlowRespDto.getAccountFlowNo());
        this.tradeSettlementFlowDas.updateSelective((BaseEo)updateFlowEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deductAccountBalance(FlowVo flowVo) {
        AssertUtils.notBlank((String)flowVo.getAccountNo(), (String)"accountNo \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)flowVo.getAccountFlowId(), (String)"accountFlowId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)flowVo.getBalance(), (String)"\u63d0\u73b0\u7684\u91d1\u989d(balance) \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AccountOptReqDto reqDto = new AccountOptReqDto();
        reqDto.setBalance(flowVo.getBalance());
        reqDto.setFrozen(flowVo.getBalance());
        reqDto.setAccountNo(flowVo.getAccountNo());
        reqDto.setType(Integer.valueOf(-1));
        reqDto.setAccountFlowStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        reqDto.setAccountFlowNoId(flowVo.getAccountFlowId());
        this.accountOptService.optAccountUpdate(reqDto);
        flowVo.setAccountFlowStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        this.changeFlowStatus(flowVo);
    }

    private void changeFlowStatus(FlowVo flowVo) {
        int updateTradeFlow;
        AssertUtils.notNull((Object)flowVo.getSettlementFlowId(), (String)"settlementFlowId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notBlank((String)flowVo.getAccountFlowNo(), (String)"accountFlowNo \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TradeSettlementFlowEo updateTradeFlowEo = new TradeSettlementFlowEo();
        updateTradeFlowEo.setId(flowVo.getSettlementFlowId());
        updateTradeFlowEo.setTradeStatus(flowVo.getAccountFlowStatus());
        updateTradeFlowEo.setTradeEntireStatus(SettlementTradeEntireStatusEnum.ACTION.getCode());
        if (StringUtils.isNotBlank((CharSequence)flowVo.getTradeEntireStatus())) {
            updateTradeFlowEo.setTradeEntireStatus(flowVo.getTradeEntireStatus());
        }
        updateTradeFlowEo.setSettlementAccountNo(flowVo.getAccountFlowNo());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{flowVo.getReqSsn()})) {
            updateTradeFlowEo.setTradePayTradeId(flowVo.getReqSsn());
        }
        if ((updateTradeFlow = this.tradeSettlementFlowDas.updateSelective((BaseEo)updateTradeFlowEo)) < 1) {
            throw SettlementExceptionCode.CHANGE_FLOW_STATUS_FAIL.getException();
        }
        SettlementAccountFlowEo updateAccountFlowEo = new SettlementAccountFlowEo();
        updateAccountFlowEo.setAccountFlowStatus(flowVo.getAccountFlowStatus());
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.eq((String)"account_flow_no", (Object)flowVo.getAccountFlowNo()));
        updateAccountFlowEo.setSqlFilters((List)filterList);
        int updateAccountFlow = this.accountFlowDas.updateSelectiveSqlFilter((BaseEo)updateAccountFlowEo);
        if (updateAccountFlow < 1) {
            throw SettlementExceptionCode.CHANGE_FLOW_STATUS_FAIL.getException();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reexchangeBalance(FlowVo reqDto) {
        AssertUtils.notBlank((String)reqDto.getSerialNo(), (String)"\u63d0\u73b0\u7ed3\u679c\u7684serialNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqDto.getBalance(), (String)"\u9000\u6c47\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TradeSettlementFlowEo tradeSettlementFlowQueryEo = new TradeSettlementFlowEo();
        tradeSettlementFlowQueryEo.setSerialNo(reqDto.getSerialNo());
        tradeSettlementFlowQueryEo.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
        TradeSettlementFlowEo tradeSettlementFlowEo = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)tradeSettlementFlowQueryEo);
        AssertUtils.notNull((Object)tradeSettlementFlowEo, (String)String.format("\u63d0\u73b0serialNo\uff08%s\uff09\u4e0d\u5b58\u5728", reqDto.getSerialNo()));
        if (!SettlementAccountFlowStatusEnum.SUCCESS.getCode().equals(tradeSettlementFlowEo.getTradeStatus())) {
            this.logger.error("\u3010\u9000\u6c47\u3011\u9000\u6c47\u5f02\u5e38\uff0c\u63d0\u73b0\u6d41\u6c34\u5e76\u672a\u5c5e\u4e8e\u5b8c\u6210\u72b6\u6001\u3002\u63d0\u73b0\u6d41\u6c34\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)tradeSettlementFlowEo));
            throw SettlementExceptionCode.REEXCHANGE_BALANCE_FAIL.getException();
        }
        TradeSettlementFlowEo returnWithFlowQueryEo = new TradeSettlementFlowEo();
        returnWithFlowQueryEo.setOptTradeNo(tradeSettlementFlowEo.getOptTradeNo());
        returnWithFlowQueryEo.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW_RETURN.getCode());
        TradeSettlementFlowEo recordFlowEo = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)returnWithFlowQueryEo);
        if (recordFlowEo != null) {
            this.logger.info("\u3010\u9000\u6c47\u3011\u5f53\u524d\u6d41\u6c34\u5df2\u751f\u6210\u9000\u6c47\u64cd\u4f5c\uff0c\u4e0d\u80fd\u91cd\u590d\u9000\u6c47\uff1a\u5f53\u524d\u7684\u4ea4\u6613\u6d41\u6c34\u53f7optTradeNo={}", (Object)tradeSettlementFlowEo.getOptTradeNo());
            throw SettlementExceptionCode.REEXCHANGE_BALANCE_FAIL.getException();
        }
        FlowVo flowVo = new FlowVo();
        flowVo.setOptTradeNo(tradeSettlementFlowEo.getOptTradeNo());
        flowVo.setAccountNo(tradeSettlementFlowEo.getOptAccountNo());
        BigDecimal tradePayParnterPoundage = Optional.ofNullable(tradeSettlementFlowEo.getTradePayParnterPoundage()).orElse(BigDecimal.ZERO);
        BigDecimal returnBanlance = tradeSettlementFlowEo.getLaunchTradeAmount().subtract(tradePayParnterPoundage);
        flowVo.setBalance(returnBanlance);
        TradeSettlementFlowRespDto flowRespDto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)tradeSettlementFlowEo, (BaseVo)flowRespDto);
        flowVo.setOriginalTradeFlow(flowRespDto);
        this.reexchangeBalancesFlow(flowVo);
    }

    private void reexchangeBalancesFlow(FlowVo flowVo) {
        AssertUtils.notBlank((String)flowVo.getAccountNo(), (String)"accountNo \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        flowVo.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW_RETURN.getCode());
        TradeSettlementFlowEo tradeSettlementFlow = this.createTradeSettlementFlow(flowVo);
        AccountOptReqDto accountOptReqDto = new AccountOptReqDto();
        accountOptReqDto.setAccountNo(flowVo.getAccountNo());
        accountOptReqDto.setBalance(flowVo.getBalance());
        accountOptReqDto.setLinkedTradeNo(tradeSettlementFlow.getTradeNo());
        accountOptReqDto.setAccountFlowType(SettlementFlowTradeTypeEnum.WITHDRAW_RETURN.getCode());
        accountOptReqDto.setChangeBalance(flowVo.getBalance());
        accountOptReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
        accountOptReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
        accountOptReqDto.setChangTime(new Date());
        accountOptReqDto.setType(Integer.valueOf(1));
        String accountFlowNo = this.accountOptService.optAccountFinish(accountOptReqDto);
        flowVo.setAccountFlowNo(accountFlowNo);
        flowVo.setAccountFlowStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        flowVo.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        this.changeFlowStatus(flowVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updatePoundageOfFlow(FlowVo flowVo) {
        this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u83b7\u53d6\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u4e2d\u7684\u624b\u7eed\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)flowVo));
        AssertUtils.notBlank((String)flowVo.getReqSsn(), (String)"\u652f\u4ed8\u7cfb\u7edf\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TradeSettlementFlowEo queryEo = new TradeSettlementFlowEo();
        queryEo.setTradePayTradeId(flowVo.getReqSsn());
        queryEo.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
        TradeSettlementFlowEo tradeSettlementFlowEo = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)queryEo);
        AssertUtils.notNull((Object)tradeSettlementFlowEo, (String)String.format("\u4ea4\u6613\u6267\u884c-\u652f\u4ed8\u4ea4\u6613\u6d41\u6c34\u53f7(%s)\u4e0d\u5b58\u5728", flowVo.getReqSsn()));
        TradeSettlementFlowEo updateFlowEo = new TradeSettlementFlowEo();
        updateFlowEo.setId(tradeSettlementFlowEo.getId());
        updateFlowEo.setSerialNo(flowVo.getSerialNo());
        updateFlowEo.setTradePayParnterPoundage(flowVo.getBalance());
        updateFlowEo.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        updateFlowEo.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        int result = this.tradeSettlementFlowDas.updateSelective((BaseEo)updateFlowEo);
        if (result < 1) {
            throw SettlementExceptionCode.CHANGE_FLOW_STATUS_FAIL.getException();
        }
        SettlementAccountFlowEo updateAccountEo = new SettlementAccountFlowEo();
        updateAccountEo.setAccountFlowStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        ArrayList accountSqlFiter = Lists.newArrayList();
        accountSqlFiter.add(SqlFilter.eq((String)"linked_trade_no", (Object)tradeSettlementFlowEo.getTradeNo()));
        accountSqlFiter.add(SqlFilter.eq((String)"account_flow_type", (Object)SettlementFlowTradeTypeEnum.WITHDRAW.getCode()));
        updateAccountEo.setSqlFilters((List)accountSqlFiter);
        int updateAccountFlowResult = this.accountFlowDas.updateSelectiveSqlFilter((BaseEo)updateAccountEo);
        if (updateAccountFlowResult < 1) {
            this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u4fee\u6539\u8d26\u6237\u6d41\u6c34\u72b6\u6001\u5931\u8d25\uff01linked_trade_no={}", (Object)tradeSettlementFlowEo.getTradeNo());
            throw SettlementExceptionCode.CHANGE_FLOW_STATUS_FAIL.getException();
        }
        this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u4fee\u6539\u4ea4\u6613\u6d41\u6c34(optTradeNo={})\u4e2d\u7684\u624b\u7eed\u8d39\u6210\u529f", (Object)tradeSettlementFlowEo.getOptTradeNo());
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rollbackFrozen(FlowVo flowVo) {
        this.logger.info("\u3010\u63d0\u73b0\u3011\u56de\u6eda\u51bb\u7ed3\u91d1\u989d\u7684\u4e0a\u4e0b\u6587flowVo\uff1a{}", (Object)JSON.toJSONString((Object)flowVo));
        AssertUtils.notBlank((String)flowVo.getAccountNo(), (String)"accountNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SettlementAccountEo queryAccountEo = new SettlementAccountEo();
        queryAccountEo.setAccountNo(flowVo.getAccountNo());
        SettlementAccountEo settlementAccountEo = (SettlementAccountEo)this.accountDas.selectOne((BaseEo)queryAccountEo);
        AssertUtils.notNull((Object)settlementAccountEo, (String)String.format("\u8d26\u53f7(%s)\u7684\u8d26\u6237\u4e0d\u5b58\u5728\uff01", flowVo.getAccountNo()));
        AccountOptReqDto accountOptReqDto = new AccountOptReqDto();
        accountOptReqDto.setAccountNo(flowVo.getAccountNo());
        accountOptReqDto.setFrozen(flowVo.getBalance());
        accountOptReqDto.setType(Integer.valueOf(-1));
        int updateFrozenResult = this.accountOptService.rollbackAmount(accountOptReqDto);
        if (updateFrozenResult < 1) {
            this.logger.error("\u3010\u63d0\u73b0\u3011\u3010\u5931\u8d25\u3011\u63d0\u73b0\u89e3\u51bb\u51bb\u7ed3\u91d1\u989d\u5931\u8d25\uff01\u539f\u8d26\u6237\u4fe1\u606f\uff1a{}, \u9700\u8981\u89e3\u51bb\u7684\u91d1\u989d\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)settlementAccountEo), (Object)flowVo.getBalance());
            throw SettlementExceptionCode.WITHDRAW_CHANGE_FROZEN_FAIL.getException();
        }
        TradeSettlementFlowEo updateFlowEo = new TradeSettlementFlowEo();
        AssertUtils.notNull((Object)flowVo.getSettlementFlowId(), (String)"settlementFlowId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        updateFlowEo.setId(flowVo.getSettlementFlowId());
        updateFlowEo.setTradeStatus(SettlementFlowTradeStatusEnum.FAIL.getCode());
        updateFlowEo.setTradePayTradeId(flowVo.getReqSsn());
        int updateTradeSettlementFlowResult = this.tradeSettlementFlowDas.updateSelective((BaseEo)updateFlowEo);
        if (updateTradeSettlementFlowResult < 1) {
            this.logger.error("\u3010\u63d0\u73b0\u3011\u3010\u5931\u8d25\u3011\u63d0\u73b0\u4fee\u6539\u63d0\u73b0\u4ea4\u6613\u6d41\u6c34\u7684\u72b6\u6001\u5931\u8d25\uff01\u539f\u6d41\u6c34id\u4e3a\uff1a{}", (Object)flowVo.getSettlementFlowId());
            throw SettlementExceptionCode.WITHDRAW_CHANGE_FROZEN_FAIL.getException();
        }
        SettlementAccountFlowEo updateAccountFlowEo = new SettlementAccountFlowEo();
        updateAccountFlowEo.setAccountFlowStatus(SettlementFlowTradeStatusEnum.FAIL.getCode());
        ArrayList accountFilterList = Lists.newArrayList();
        accountFilterList.add(SqlFilter.eq((String)"account_flow_no", (Object)flowVo.getAccountFlowNo()));
        accountFilterList.add(SqlFilter.eq((String)"account_no", (Object)flowVo.getAccountNo()));
        updateAccountFlowEo.setSqlFilters((List)accountFilterList);
        int updateAccountFlowResult = this.accountFlowDas.updateSelectiveSqlFilter((BaseEo)updateAccountFlowEo);
        if (updateAccountFlowResult < 1) {
            this.logger.error("\u3010\u63d0\u73b0\u3011\u3010\u5931\u8d25\u3011\u63d0\u73b0\u4fee\u6539\u63d0\u73b0\u8d26\u6237\u6d41\u6c34\u7684\u72b6\u6001\u5931\u8d25\uff01\u539f\u6d41\u6c34account_flow_no\u4e3a\uff1a{}", (Object)flowVo.getAccountFlowNo());
            throw SettlementExceptionCode.WITHDRAW_CHANGE_FROZEN_FAIL.getException();
        }
        this.logger.info("\u3010\u63d0\u73b0\u3011\u56de\u6eda\u51bb\u7ed3\u91d1\u989d\u5b8c\u6210");
    }

    private TradeSettlementFlowEo createTradeSettlementFlow(FlowVo reqDto) {
        int insert;
        AssertUtils.notBlank((String)reqDto.getOptTradeNo(), (String)"optTradeNo \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notBlank((String)reqDto.getAccountNo(), (String)"accountNo \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SettlementAccountEo queryAccountEo = new SettlementAccountEo();
        queryAccountEo.setAccountNo(reqDto.getAccountNo());
        SettlementAccountEo settlementAccountEo = (SettlementAccountEo)this.accountDas.selectOne((BaseEo)queryAccountEo);
        AssertUtils.notNull((Object)settlementAccountEo, (String)"\u8d26\u53f7\u4fe1\u606f\u5f02\u5e38\uff01");
        TradeSettlementFlowEo tradeSettlementFlowEo = new TradeSettlementFlowEo();
        tradeSettlementFlowEo.setOptTradeNo(reqDto.getOptTradeNo());
        tradeSettlementFlowEo.setLaunchTradeAmount(reqDto.getBalance());
        tradeSettlementFlowEo.setLaunchUserId(String.valueOf(this.context.userId()));
        tradeSettlementFlowEo.setLaunchUserName(this.context.userName());
        tradeSettlementFlowEo.setLaunchUserType(null);
        tradeSettlementFlowEo.setOptAccountFlowNo(reqDto.getAccountFlowNo());
        tradeSettlementFlowEo.setOptAccountNo(settlementAccountEo.getAccountNo());
        tradeSettlementFlowEo.setOptAccountName(settlementAccountEo.getAccountName());
        tradeSettlementFlowEo.setOptAccountType(settlementAccountEo.getAccountType());
        tradeSettlementFlowEo.setTradeType(reqDto.getTradeType());
        tradeSettlementFlowEo.setTradeNo(TradeUtil.generateTradeFlowNo(tradeSettlementFlowEo.getTradeType()));
        tradeSettlementFlowEo.setTradeStatus(SettlementFlowTradeStatusEnum.CREATED.getCode());
        tradeSettlementFlowEo.setParentTradeNo(reqDto.getLinkedParentTradeNo());
        tradeSettlementFlowEo.setTradeAmount(reqDto.getBalance());
        tradeSettlementFlowEo.setTradePayStoreCode(PaymentWayEnum.WFT_ALIPLY_YE.getStoreCode());
        tradeSettlementFlowEo.setTradePayAppCode(PaymentWayEnum.WFT_ALIPLY_YE.getAppCode());
        tradeSettlementFlowEo.setTradePayPartnerId(PaymentWayEnum.WFT_ALIPLY_YE.getPayPartnerCode());
        tradeSettlementFlowEo.setTradePayType(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode());
        tradeSettlementFlowEo.setTradeEntireStatus(SettlementTradeEntireStatusEnum.NOTSTART.getCode());
        tradeSettlementFlowEo.setSettlementAccountNo(settlementAccountEo.getAccountNo());
        tradeSettlementFlowEo.setSettlementAccountName(settlementAccountEo.getAccountName());
        tradeSettlementFlowEo.setSettlementAccountType(settlementAccountEo.getAccountType());
        if (reqDto.getOriginalTradeFlow() != null) {
            TradeSettlementFlowRespDto originalTradeFlow = reqDto.getOriginalTradeFlow();
            tradeSettlementFlowEo.setFormerOptOrderNo(originalTradeFlow.getOptTradeNo());
            tradeSettlementFlowEo.setFormerTradeNo(originalTradeFlow.getTradeNo());
            tradeSettlementFlowEo.setFormerParentTradeNo(originalTradeFlow.getParentTradeNo());
            tradeSettlementFlowEo.setFormerPayBalancetradeId(originalTradeFlow.getTradePayTradeId());
            tradeSettlementFlowEo.setTradePayParnterPoundage(originalTradeFlow.getTradePayParnterPoundage());
        }
        if ((insert = this.tradeSettlementFlowDas.insert((BaseEo)tradeSettlementFlowEo)) < 1) {
            throw SettlementExceptionCode.CREATE_FLOW_ERROR.getException();
        }
        reqDto.setSettlementFlowId(tradeSettlementFlowEo.getId());
        return tradeSettlementFlowEo;
    }
}

