/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.dto.request.CiticWithResultBatchQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticWithReturnCompleteBatchReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticReturnResultQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticWithResultQueryResDto;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.FlowVo;
import com.dtyunxi.tcbj.center.settlement.biz.service.IWithdrawBalanceService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IWithdrawResultService;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WithdrawResultServiceImpl
implements IWithdrawResultService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final Integer MULTI_THRESHOLD = 500;
    public static final Integer WITHDRAW_CHANGE_THRESHOLD = 500;
    private static final Integer QUERY_UNDO_TRADE_FLOW_COUNT = 2000;
    private static final Integer QUERY_WITHRETURN_COUNT = 50;
    @Resource
    private ICiticQueryApi citicQueryApi;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private IWithdrawBalanceService withdrawBalanceService;
    @Resource
    private ICiticApi citicApi;

    @Override
    public void changeWithdrawResult() {
        this.handlerExceptionFlow();
        this.changeTradeFlowStatusAndPoundage();
    }

    private void handlerExceptionFlow() {
        CompletableFuture.runAsync(() -> {
            this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5b9a\u65f6\u5668\u5f02\u6b65\u7ebf\u7a0b\u67e5\u8be2\u5f02\u5e38\u6d41\u6c34");
            TradeSettlementFlowEo queryEo = new TradeSettlementFlowEo();
            ArrayList filterList = Lists.newArrayList();
            filterList.add(SqlFilter.eq((String)"trade_status", (Object)SettlementFlowTradeStatusEnum.CREATED.getCode()));
            filterList.add(SqlFilter.eq((String)"trade_type", (Object)SettlementFlowTradeTypeEnum.WITHDRAW.getCode()));
            filterList.add(SqlFilter.isNull((String)"trade_pay_parnter_poundage"));
            queryEo.setSqlFilters((List)filterList);
            List flowEoList = this.tradeSettlementFlowDas.select((BaseEo)queryEo, Integer.valueOf(0), Integer.valueOf(50));
            if (CollectionUtils.isEmpty((Collection)flowEoList)) {
                this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5b9a\u65f6\u67e5\u8be2\u5f02\u5e38\u63d0\u73b0\u6d41\u6c34\u4e3a\u7a7a\uff01");
                return;
            }
            List optTradeNoList = flowEoList.stream().map(TradeSettlementFlowEo::getOptTradeNo).collect(Collectors.toList());
            this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5f02\u5e38\u7684\u4ea4\u6613\u6d41\u6c34\u8bb0\u5f55\u4e3a\uff1a{}", (Object)JSON.toJSONString(optTradeNoList));
            this.queryFlowResultAndChangeFlow(flowEoList);
        });
    }

    private void changeTradeFlowStatusAndPoundage() {
        this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5b9a\u65f6\u5668\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c");
        TradeSettlementFlowEo queryEo = new TradeSettlementFlowEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.eq((String)"trade_status", (Object)SettlementFlowTradeStatusEnum.ACCEPT.getCode()));
        filterList.add(SqlFilter.eq((String)"trade_type", (Object)SettlementFlowTradeTypeEnum.WITHDRAW.getCode()));
        filterList.add(SqlFilter.isNull((String)"trade_pay_parnter_poundage"));
        filterList.add(SqlFilter.isNotNull((String)"trade_pay_trade_id"));
        queryEo.setSqlFilters((List)filterList);
        List flowEoList = this.tradeSettlementFlowDas.select((BaseEo)queryEo, Integer.valueOf(0), QUERY_UNDO_TRADE_FLOW_COUNT);
        if (CollectionUtils.isEmpty((Collection)flowEoList)) {
            this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5b9a\u65f6\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return;
        }
        this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5f85\u5904\u7406\u63d0\u73b0\u7ed3\u679c\u6570\u636e\u6761\u76ee\u6570\uff1a{}", (Object)flowEoList.size());
        this.queryFlowResultAndChangeFlow(flowEoList);
    }

    private void queryFlowResultAndChangeFlow(List<TradeSettlementFlowEo> flowEoList) {
        List<String> tradePayTradeIdList = Optional.ofNullable(flowEoList).orElseGet(Collections::emptyList).stream().map(TradeSettlementFlowEo::getTradePayTradeId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tradePayTradeIdList)) {
            List withResultQueryResDtos;
            if (tradePayTradeIdList.size() > WITHDRAW_CHANGE_THRESHOLD) {
                withResultQueryResDtos = this.queryCiticWithResultByMulti(tradePayTradeIdList);
            } else {
                CiticWithResultBatchQueryReqDto reqDto = new CiticWithResultBatchQueryReqDto();
                reqDto.setBussIds(tradePayTradeIdList);
                RestResponse restResponse = this.citicQueryApi.withResultBatchQuery(reqDto);
                withResultQueryResDtos = (List)RestResponseHelper.extractData((RestResponse)restResponse);
            }
            if (CollectionUtils.isEmpty(withResultQueryResDtos)) {
                this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5b9a\u65f6\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3(\u5373\u4e2d\u4fe1)\u63d0\u73b0\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return;
            }
            if (withResultQueryResDtos.size() > MULTI_THRESHOLD) {
                this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5f00\u542f\u591a\u7ebf\u7a0b\u6267\u884c\u63d0\u73b0\u7ed3\u679c\u4fee\u6539");
                this.multiTaskRun(withResultQueryResDtos);
            } else {
                this.logger.info("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u5f00\u542f\u4e3b\u7ebf\u7a0b\u6267\u884c\u63d0\u73b0\u7ed3\u679c\u4fee\u6539");
                this.taskRun(withResultQueryResDtos);
            }
        }
    }

    private List<CiticWithResultQueryResDto> queryCiticWithResultByMulti(List<String> tradePayTradeIdList) {
        List partitionTradePayTradeIdList = Lists.partition(tradePayTradeIdList, (int)100);
        List<CompletableFuture> completableFutureList = partitionTradePayTradeIdList.stream().map(tradeNoList -> CompletableFuture.supplyAsync(() -> {
            CiticWithResultBatchQueryReqDto reqDto = new CiticWithResultBatchQueryReqDto();
            reqDto.setBussIds(tradeNoList);
            RestResponse listRestResponse = this.citicQueryApi.withResultBatchQuery(reqDto);
            List withResultQueryResDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            return withResultQueryResDtos;
        })).collect(Collectors.toList());
        CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[completableFutureList.size()])).join();
        ArrayList resultList = Lists.newArrayList();
        for (CompletableFuture future : completableFutureList) {
            List resultQueryResDtos = (List)future.join();
            resultList.addAll(resultQueryResDtos);
        }
        return resultList;
    }

    @Override
    public void reexchangeBalance() {
        this.logger.info("\u3010\u67e5\u8be2\u9000\u6c47\u7ed3\u679c\u3011\u5b9a\u65f6\u5668\u67e5\u8be2\u8ba2\u5355\u9000\u6c47\u7ed3\u679c");
        RestResponse listRestResponse = this.citicQueryApi.withReturnTodoListQuery(QUERY_WITHRETURN_COUNT);
        List returnResultQueryResDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isEmpty((Collection)returnResultQueryResDtos)) {
            this.logger.info("\u3010\u67e5\u8be2\u9000\u6c47\u7ed3\u679c\u3011\u6682\u65e0\u9700\u8981\u5904\u7406\u7684\u9000\u6c47\u6d41\u6c34");
            return;
        }
        ArrayList serialNoList = Lists.newArrayList();
        for (CiticReturnResultQueryResDto resultResDto : returnResultQueryResDtos) {
            try {
                FlowVo flowVo = new FlowVo();
                flowVo.setSerialNo(resultResDto.getBussId());
                this.withdrawBalanceService.reexchangeBalance(flowVo);
                serialNoList.add(resultResDto.getBussId());
            }
            catch (Exception e) {
                this.logger.error("\u3010\u67e5\u8be2\u9000\u6c47\u7ed3\u679c\u3011\u9000\u6c47\u6d41\u6c34\u5904\u7406\u5f02\u5e38\uff0c\u9000\u6c47\u6d41\u6c34\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)resultResDto));
                this.logger.error("\u3010\u67e5\u8be2\u9000\u6c47\u7ed3\u679c\u3011\u9000\u6c47\u6d41\u6c34\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)serialNoList)) {
            this.logger.info("\u3010\u67e5\u8be2\u9000\u6c47\u7ed3\u679c\u3011\u6279\u91cf\u4fee\u6539\u652f\u4ed8\u4e2d\u5fc3\u7684\u9000\u6c47\u5b8c\u6210\u72b6\u6001\uff0cserialNoList\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)serialNoList));
            CiticWithReturnCompleteBatchReqDto reqDto = new CiticWithReturnCompleteBatchReqDto();
            reqDto.setBussIds((List)serialNoList);
            this.citicApi.withReturnCompleteBatch(reqDto);
        }
    }

    private void taskRun(List<CiticWithResultQueryResDto> resDtoList) {
        this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u6279\u91cf\u4fee\u6539\u63d0\u73b0\u7ed3\u679c({})\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)resDtoList.size(), (Object)JSON.toJSONString(resDtoList));
        this.changeWithResult(resDtoList);
    }

    private void multiTaskRun(List<CiticWithResultQueryResDto> resDtoList) {
        this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u591a\u7ebf\u7a0b\u6279\u91cf\u4fee\u6539\u63d0\u73b0\u7ed3\u679c({})\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)resDtoList.size(), (Object)JSON.toJSONString(resDtoList));
        List partitionList = Lists.partition(resDtoList, (int)10);
        partitionList.forEach(itemList -> CompletableFuture.runAsync(() -> this.changeWithResult((List<CiticWithResultQueryResDto>)itemList)));
        this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u591a\u7ebf\u7a0b\u6279\u91cf\u4fee\u6539\u63d0\u73b0\u7ed3\u679c\u72b6\u6001\u5b8c\u6210");
    }

    private void changeWithResult(List<CiticWithResultQueryResDto> itemList) {
        for (CiticWithResultQueryResDto resultQueryResDto : itemList) {
            FlowVo flowVo = new FlowVo();
            flowVo.setBalance(resultQueryResDto.getWithFee());
            flowVo.setReqSsn(resultQueryResDto.getBussId());
            flowVo.setSerialNo(resultQueryResDto.getSerialNo());
            try {
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.withdrawBalanceService.updatePoundageOfFlow(flowVo);
        }
    }
}

