/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CiticUserBalanceQueryResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccOrgTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyFlagEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifySuccessStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.VerifyBalanceDetailReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyBalanceDetailRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyBalanceDetailService;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyBalanceDetailDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTaskDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyBalanceDetailEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTaskEo;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.SettlementAccountMapper;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.TradeSettlementFlowMapper;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.VerifyDealBillMapper;
import com.dtyunxi.tcbj.center.settlement.dao.vo.SettlementRelationAccountVo;
import com.dtyunxi.tcbj.center.settlement.dao.vo.VerifyBalanceDetailVo;
import com.dtyunxi.tcbj.center.settlement.dao.vo.VerifyFlowVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VerifyBalanceDetailServiceImpl
implements IVerifyBalanceDetailService {
    private static Logger logger = LoggerFactory.getLogger(VerifyBalanceDetailServiceImpl.class);
    @Resource
    private VerifyBalanceDetailDas verifyBalanceDetailDas;
    @Resource
    private VerifyTaskDas taskDas;
    @Resource
    private SettlementAccountMapper settlementAccountMapper;
    @Resource
    private ICiticQueryApi citicQueryApi;
    @Resource
    private TradeSettlementFlowMapper tradeSettlementFlowMapper;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private VerifyDealBillMapper verifyDealBillMapper;

    @Override
    public Long addVerifyBalanceDetail(VerifyBalanceDetailReqDto addReqDto) {
        VerifyBalanceDetailEo verifyBalanceDetailEo = new VerifyBalanceDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)verifyBalanceDetailEo);
        this.verifyBalanceDetailDas.insert((BaseEo)verifyBalanceDetailEo);
        return verifyBalanceDetailEo.getId();
    }

    @Override
    public void modifyVerifyBalanceDetail(VerifyBalanceDetailReqDto modifyReqDto) {
        VerifyBalanceDetailEo verifyBalanceDetailEo = new VerifyBalanceDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)verifyBalanceDetailEo);
        this.verifyBalanceDetailDas.updateSelective((BaseEo)verifyBalanceDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeVerifyBalanceDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.verifyBalanceDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public VerifyBalanceDetailRespDto queryById(Long id) {
        VerifyBalanceDetailEo verifyBalanceDetailEo = (VerifyBalanceDetailEo)this.verifyBalanceDetailDas.selectByPrimaryKey(id);
        VerifyBalanceDetailRespDto verifyBalanceDetailRespDto = new VerifyBalanceDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)verifyBalanceDetailEo, (BaseVo)verifyBalanceDetailRespDto);
        return verifyBalanceDetailRespDto;
    }

    @Override
    public PageInfo<VerifyBalanceDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        VerifyBalanceDetailReqDto verifyBalanceDetailReqDto = (VerifyBalanceDetailReqDto)JSON.parseObject((String)filter, VerifyBalanceDetailReqDto.class);
        VerifyBalanceDetailEo verifyBalanceDetailEo = new VerifyBalanceDetailEo();
        DtoHelper.dto2Eo((BaseVo)verifyBalanceDetailReqDto, (BaseEo)verifyBalanceDetailEo);
        if (ObjectUtils.isNotEmpty((Object)verifyBalanceDetailReqDto.getTaskStatus())) {
            if (verifyBalanceDetailReqDto.getTaskStatus().equals(VerifyTaskStatusEnum.SUCCESS.getCode())) {
                verifyBalanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.SUCCESS.getCode());
            } else if (verifyBalanceDetailReqDto.getTaskStatus().equals(VerifyTaskStatusEnum.FAIL_WAIT_DEAL.getCode())) {
                verifyBalanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                verifyBalanceDetailEo.setDealStatus(Boolean.valueOf(false));
            } else if (verifyBalanceDetailReqDto.getTaskStatus().equals(VerifyTaskStatusEnum.FAIL_HAS_DEAL.getCode())) {
                verifyBalanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                verifyBalanceDetailEo.setDealStatus(Boolean.valueOf(true));
            }
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)verifyBalanceDetailReqDto.getVerifyDateBegin())) {
            sqlFilterList.add(SqlFilter.ge((String)"verify_date", (Object)verifyBalanceDetailReqDto.getVerifyDateBegin().replace("-", "").substring(0, 8)));
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyBalanceDetailReqDto.getVerifyDateEnd())) {
            sqlFilterList.add(SqlFilter.le((String)"verify_date", (Object)verifyBalanceDetailReqDto.getVerifyDateEnd().replace("-", "").substring(0, 8)));
        }
        verifyBalanceDetailEo.setSqlFilters(sqlFilterList);
        PageInfo eoPageInfo = this.verifyBalanceDetailDas.selectPage((BaseEo)verifyBalanceDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, VerifyBalanceDetailRespDto.class);
        if (dtoList.size() > 0) {
            ListIterator iterator = dtoList.listIterator();
            while (iterator.hasNext()) {
                VerifyBalanceDetailRespDto dto = (VerifyBalanceDetailRespDto)iterator.next();
                dto.setVerifyDate(dto.getVerifyDate().substring(0, 4) + "-" + dto.getVerifyDate().substring(4, 6) + "-" + dto.getVerifyDate().substring(6, 8));
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void verifyBalanceDetail(String verifyDate) {
        VerifyTaskEo searchTaskEo = new VerifyTaskEo();
        searchTaskEo.setVerifyDate(verifyDate);
        searchTaskEo.setVerifyType(VerifyTaskTypeEnum.DJB_BALANCE.getCode());
        VerifyTaskEo taskEo = (VerifyTaskEo)this.taskDas.selectOne((BaseEo)searchTaskEo);
        if (taskEo == null) {
            taskEo = new VerifyTaskEo();
            taskEo.setVerifyDate(verifyDate);
            taskEo.setVerifyType(VerifyTaskTypeEnum.DJB_BALANCE.getCode());
            taskEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
            taskEo.setRemark("\u5bf9\u8d26\u4e2d");
            taskEo.setCiticVerifyNum(Integer.valueOf(0));
            taskEo.setZhongtaiVerifyNum(Integer.valueOf(0));
            taskEo.setSuccessNum(Integer.valueOf(0));
            taskEo.setFailNum(Integer.valueOf(0));
            taskEo.setDiffBalanceNum(Integer.valueOf(0));
            taskEo.setSuccessNum(Integer.valueOf(0));
            taskEo.setLongNum(Integer.valueOf(0));
            taskEo.setShortNum(Integer.valueOf(0));
            taskEo.setTaskNum(Integer.valueOf(0));
            int n = this.taskDas.insert((BaseEo)taskEo);
        }
        VerifyTaskEo updateEo = new VerifyTaskEo();
        updateEo.setId(taskEo.getId());
        updateEo.setTaskNum(Integer.valueOf(taskEo.getTaskNum() + 1));
        try {
            List accountEoList = null;
            if (taskEo.getTaskStatus().equals(VerifyTaskStatusEnum.WAIT_DOING.getCode())) {
                accountEoList = this.settlementAccountMapper.getAccountInfoByVerifyDate(verifyDate);
                updateEo.setZhongtaiVerifyNum(Integer.valueOf(accountEoList.size()));
                updateEo.setCiticVerifyNum(Integer.valueOf(accountEoList.size()));
            } else {
                accountEoList = this.settlementAccountMapper.getAbnormalAccountInfo(verifyDate);
            }
            TradeSettlementFlowEo sflowEo = new TradeSettlementFlowEo();
            sflowEo.setVerifyFlag(VerifyFlagEnum.NO.getCode());
            sflowEo.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
            sflowEo.setTradePayType(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode());
            sflowEo.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
            List tradeSettlementFlowEoList = this.tradeSettlementFlowMapper.queryNoVerifyDjbPayFLowAndRoutingFlow(sflowEo);
            TradeSettlementFlowEo flowEo2 = new TradeSettlementFlowEo();
            flowEo2.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
            flowEo2.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
            List tixianAcceptFlowList = this.tradeSettlementFlowMapper.queryAcceptWithdrawFLow(flowEo2);
            for (SettlementRelationAccountVo accountEo : accountEoList) {
                this.verifyBalanceDetail_ForOne(taskEo, accountEo, tradeSettlementFlowEoList, tixianAcceptFlowList);
            }
            updateEo.setTaskStatus(VerifyTaskStatusEnum.SUCCESS.getCode());
            updateEo.setRemark("");
        }
        catch (Exception e) {
            updateEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
            updateEo.setRemark(e.getMessage().length() > 900 ? e.getMessage().substring(1, 900) : e.getMessage());
            throw e;
        }
        finally {
            updateEo.setSuccessNum(taskEo.getSuccessNum());
            updateEo.setFailNum(taskEo.getFailNum());
            updateEo.setDiffBalanceNum(taskEo.getDiffBalanceNum());
            updateEo.setSuccessNum(taskEo.getSuccessNum());
            updateEo.setLongNum(taskEo.getLongNum());
            updateEo.setShortNum(taskEo.getShortNum());
            this.taskDas.updateSelective((BaseEo)updateEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void verifyBalanceDetail_ForOne(VerifyTaskEo taskEo, SettlementRelationAccountVo accountEo, List<VerifyFlowVo> tradeSettlementFlowEoList, List<VerifyFlowVo> tixianAcceptFlowList) {
        CiticUserBalanceQueryResDto cubqDto = null;
        try {
            RestResponse cuqResp = this.citicQueryApi.queryUserBalance(accountEo.getBindAccountNo());
            cubqDto = (CiticUserBalanceQueryResDto)cuqResp.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u8bfb\u53d6\u4e2d\u4fe1\u94b1\u5305\u4f59\u989d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        BigDecimal zhongtaiBalance = accountEo.getBalance();
        if (SettleAccOrgTypeEnum.CUSTOMER.getCode().equals(accountEo.getOrganizationType())) {
            if (accountEo.getVerifyId() == null) {
                for (VerifyFlowVo flowVo : tradeSettlementFlowEoList) {
                    if (!accountEo.getAccountNo().equals(flowVo.getOptAccountNo())) continue;
                    zhongtaiBalance = zhongtaiBalance.add(flowVo.getLaunchTradeAmount());
                    TradeSettlementFlowEo uptradeFlowEo = new TradeSettlementFlowEo();
                    uptradeFlowEo.setId(flowVo.getId());
                    uptradeFlowEo.setVerifyFlag(VerifyFlagEnum.YES.getCode());
                    this.tradeSettlementFlowDas.updateSelective((BaseEo)uptradeFlowEo);
                }
            } else {
                TradeSettlementFlowEo tEo = new TradeSettlementFlowEo();
                tEo.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
                tEo.setTradePayType(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode());
                tEo.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
                tEo.setOptAccountNo(accountEo.getAccountNo());
                List voList = this.tradeSettlementFlowMapper.queryNoVerifyDjbPayFLowAndRoutingFlow(tEo);
                for (VerifyFlowVo flowVo : voList) {
                    if (!accountEo.getAccountNo().equals(flowVo.getOptAccountNo())) continue;
                    zhongtaiBalance = zhongtaiBalance.add(flowVo.getLaunchTradeAmount());
                }
            }
        }
        for (VerifyFlowVo flowVo : tixianAcceptFlowList) {
            if (!accountEo.getAccountNo().equals(flowVo.getOptAccountNo())) continue;
            zhongtaiBalance = zhongtaiBalance.add(flowVo.getLaunchTradeAmount());
        }
        VerifyBalanceDetailEo balanceDetailEo = new VerifyBalanceDetailEo();
        if (cubqDto != null && CiticRspCodeEnum.SUCCESS.key.equals(cubqDto.getRspCode())) {
            BigDecimal subDiff = zhongtaiBalance.subtract(cubqDto.getAmount());
            balanceDetailEo.setDiffBalance(subDiff);
            balanceDetailEo.setZhongtaiBalance(zhongtaiBalance);
            balanceDetailEo.setCiticsBalance(cubqDto.getAmount());
            if (subDiff.compareTo(BigDecimal.valueOf(-1L)) > -1 && subDiff.compareTo(BigDecimal.valueOf(1L)) < 1) {
                taskEo.setSuccessNum(Integer.valueOf(taskEo.getSuccessNum() + 1));
                balanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.SUCCESS.getCode());
            } else {
                balanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                Integer errNum = this.verifyDealBillMapper.queryNodealBillCount(accountEo.getAccountNo());
                balanceDetailEo.setUnusualNum(errNum);
                balanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
            }
        } else {
            balanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
            balanceDetailEo.setZhongtaiBalance(accountEo.getBalance());
            balanceDetailEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
            balanceDetailEo.setDealRemark("\u83b7\u53d6\u4e2d\u4fe1\u94f6\u884c\u4fa7\u6570\u636e\u5931\u8d25\uff0c\u94b1\u5305\u5bf9\u8d26\u5f02\u5e38");
        }
        this.addBalanceDetail(balanceDetailEo, taskEo, accountEo);
    }

    private void addBalanceDetail(VerifyBalanceDetailEo balanceDetailEo, VerifyTaskEo taskEo, SettlementRelationAccountVo accountEo) {
        balanceDetailEo.setTaskId(taskEo.getId());
        balanceDetailEo.setVerifyDate(taskEo.getVerifyDate());
        balanceDetailEo.setAccountNo(accountEo.getAccountNo());
        balanceDetailEo.setBindAccountNo(accountEo.getBindAccountNo());
        balanceDetailEo.setCustomerName(accountEo.getAccountName());
        balanceDetailEo.setZhongtaiBalance(accountEo.getBalance());
        balanceDetailEo.setDealStatus(Boolean.valueOf(false));
        if (accountEo.getVerifyId() == null) {
            if (balanceDetailEo.getVerifyStatus().equals(VerifySuccessStatusEnum.FAIL.getCode())) {
                taskEo.setDiffBalanceNum(Integer.valueOf(taskEo.getDiffBalanceNum() + 1));
                taskEo.setFailNum(Integer.valueOf(taskEo.getFailNum() + 1));
            }
            this.verifyBalanceDetailDas.insert((BaseEo)balanceDetailEo);
        } else {
            balanceDetailEo.setId(accountEo.getVerifyId());
            if (balanceDetailEo.getVerifyStatus().equals(VerifySuccessStatusEnum.SUCCESS.getCode())) {
                balanceDetailEo.setDealStatus(Boolean.valueOf(true));
                taskEo.setDiffBalanceNum(Integer.valueOf(taskEo.getDiffBalanceNum() - 1));
                taskEo.setFailNum(Integer.valueOf(taskEo.getFailNum() - 1));
                taskEo.setSuccessNum(Integer.valueOf(taskEo.getSuccessNum() + 1));
            }
            this.verifyBalanceDetailDas.updateSelective((BaseEo)balanceDetailEo);
        }
    }

    @Override
    public PageInfo<VerifyBalanceDetailRespDto> queryWaitVerifyByPage(String filter, Integer pageNum, Integer pageSize) {
        VerifyBalanceDetailReqDto VerifyBalanceDetailReqDto2 = (VerifyBalanceDetailReqDto)JSON.parseObject((String)filter, VerifyBalanceDetailReqDto.class);
        VerifyBalanceDetailVo verifyBalanceDetailVo = new VerifyBalanceDetailVo();
        CubeBeanUtils.copyProperties((Object)VerifyBalanceDetailReqDto2, (Object)verifyBalanceDetailVo, (String[])new String[0]);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        verifyBalanceDetailVo.setVerifyDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        List list = this.settlementAccountMapper.queryWaitVerifyByPage(verifyBalanceDetailVo, pageNum, pageSize);
        PageInfo voPageInfo = new PageInfo(list);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)voPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)voPageInfo.getList(), VerifyBalanceDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

