/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.config;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="cup.ftp.config")
public class CupFtpConfig {
    private String url;
    private String username;
    private String password;
    private String filePath = "/";
    private String tenantCode;
    private String businessCode;
    private String fileSuffix = ".xls";
    private final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

    public String fileName(Date date) {
        String dateStr = this.format.format(date);
        return this.fileName(dateStr);
    }

    public String fileName(String dateStr) {
        return String.format("%s%s_%s_%s%s", this.filePath, this.tenantCode, dateStr, this.businessCode, this.fileSuffix);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getBusinessCode() {
        return this.businessCode;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public SimpleDateFormat getFormat() {
        return this.format;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CupFtpConfig)) {
            return false;
        }
        CupFtpConfig other = (CupFtpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$businessCode = this.getBusinessCode();
        String other$businessCode = other.getBusinessCode();
        if (this$businessCode == null ? other$businessCode != null : !this$businessCode.equals(other$businessCode)) {
            return false;
        }
        String this$fileSuffix = this.getFileSuffix();
        String other$fileSuffix = other.getFileSuffix();
        if (this$fileSuffix == null ? other$fileSuffix != null : !this$fileSuffix.equals(other$fileSuffix)) {
            return false;
        }
        SimpleDateFormat this$format = this.getFormat();
        SimpleDateFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)this$format).equals(other$format));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CupFtpConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $businessCode = this.getBusinessCode();
        result = result * 59 + ($businessCode == null ? 43 : $businessCode.hashCode());
        String $fileSuffix = this.getFileSuffix();
        result = result * 59 + ($fileSuffix == null ? 43 : $fileSuffix.hashCode());
        SimpleDateFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        return result;
    }

    public String toString() {
        return "CupFtpConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", filePath=" + this.getFilePath() + ", tenantCode=" + this.getTenantCode() + ", businessCode=" + this.getBusinessCode() + ", fileSuffix=" + this.getFileSuffix() + ", format=" + this.getFormat() + ")";
    }
}

