/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.ISplitOrderApi;
import com.dtyunxi.tcbj.api.dto.request.SplitOrderClearReqDto;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SettlementTradeClearingEvent")
@Scope(value="prototype")
public class SettlementTradeClearingEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SettlementTradeClearingEvent.class);
    @Resource
    private IShareBenefitService shareBenefitService;
    @Resource
    private ISplitOrderApi splitOrderApi;
    @Resource
    private DingdingSender dingdingSender;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
    }

    public boolean execute(TaskMsg taskMsg) {
        logger.info("\u7ed3\u7b97\u5c31\u7eea\u521b\u5efa\u6e05\u5206\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)taskMsg.getContent()));
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, -1);
            Date date = calendar.getTime();
            if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                date = dateFormat.parse(taskMsg.getContent());
            }
            if (this.shareBenefitService.checkFinishUploadDetailToReady(date)) {
                SplitOrderClearReqDto reqDto = new SplitOrderClearReqDto();
                reqDto.setSplitDt(DateUtil.getTransDate(date));
                this.shareBenefitService.tradeClearing(reqDto);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.scheduled.SettlementTradeClearingEvent\uff0c\u7ed3\u7b97\u5c31\u7eea\u521b\u5efa\u6e05\u5206\u4efb\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
    }

    public void after(TaskMsg taskMsg) {
    }
}

