/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskTypeEnum;
import com.dtyunxi.tcbj.center.settlement.biz.config.SettlementVerifyConfig;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyBalanceDetailService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyDealBillService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyTaskService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyTradeResultService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class VerifyAccountScheduled {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String RESULT_WFTPAY_LOCK = "RESULT_WFTPAY_LOCK";
    private final String JSD_DEAL_DUANKAUN = "JSD_DEAL_DUANKAUN";
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private IVerifyTradeResultService verifyTradeResultService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IVerifyBalanceDetailService verifyBalanceDetailService;
    @Resource
    private SettlementVerifyConfig settlementVerifyConfig;
    @Resource
    private IVerifyTaskService taskService;
    @Resource
    IVerifyDealBillService dealBillService;

    @Scheduled(cron="${jobs.crons.verifyWftPay}")
    public void verifyWftPay() throws Exception {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u5a01\u5bcc\u901a\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26-verifyWftPay");
        boolean lockFlag = this.cacheService.setIfAbsent(VerifyTaskTypeEnum.WFT_PAY.getKey(), (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u5bf9\u8d26\u3011\u5a01\u5bcc\u901a\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u5668\u542f\u52a8");
                this.verifyTradeResultService.verifyWftPay(this.getVerifyDate());
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getWftPayList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".verifyWftPay\u3010\u5a01\u5bcc\u901a-\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u5a01\u5bcc\u901a\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26-verifyWftPay\u9519\u8bef\u4fe1\u606f\u3011\uff1a" + e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(VerifyTaskTypeEnum.WFT_PAY.getKey());
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u5a01\u5bcc\u901a\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26-verifyWftPay");
    }

    @Scheduled(cron="${jobs.crons.verifyWftTuiKuanFlow}")
    public void verifyWftTuiKuanFlow() throws Exception {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u5a01\u5bcc\u901a\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26-verifyWftTuiKuanFlow");
        boolean lockFlag = this.cacheService.setIfAbsent(VerifyTaskTypeEnum.WFT_TUI_KUAN.getKey(), (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u5a01\u5bcc\u901a\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26\u3011\u5a01\u5bcc\u901a\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u5668\u542f\u52a8");
                this.verifyTradeResultService.verifyWftTuiKuanFlow(this.getVerifyDate());
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getTuikuanList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".verifyWftTuiKuanFlow\u3010\u5a01\u5bcc\u901a-\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u5a01\u5bcc\u901a\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26-verifyWftTuiKuanFlow\u9519\u8bef\u4fe1\u606f\u3011\uff1a", (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(VerifyTaskTypeEnum.WFT_TUI_KUAN.getKey());
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u5a01\u5bcc\u901a\u9000\u6b3e\u6d41\u6c34\u5bf9\u8d26-verifyWftTuiKuanFlow");
    }

    @Scheduled(cron="${jobs.crons.verifyDjpPayFlow}")
    public void verifyDjpPayFlow() throws Exception {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u767b\u8bb0\u7c3f\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26-verifyDjpPayFlow");
        boolean lockFlag = this.cacheService.setIfAbsent(VerifyTaskTypeEnum.DJB_PAY.getKey(), (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u5bf9\u8d26\u3011\u767b\u8bb0\u7c3f\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u5668\u542f\u52a8");
                this.verifyTradeResultService.verifyDjpPayFlow(this.getVerifyDate());
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getDjbPayList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".verifyDjpPayFlow\u3010\u767b\u8bb0\u7c3f-\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u767b\u8bb0\u7c3f\u652f\u4ed8\u6d41\u6c34\u5bf9\u8d26-verifyDjpPayFlow\u9519\u8bef\u4fe1\u606f\u3011\uff1a", (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(VerifyTaskTypeEnum.DJB_PAY.getKey());
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u767b\u8bb0\u7c3f\u6d41\u6c34\u5bf9\u8d26-verifyDjpPayFlow");
    }

    @Scheduled(cron="${jobs.crons.verifyDjpTiXianFlow}")
    public void verifyDjpTiXianFlow() throws Exception {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u767b\u8bb0\u7c3f\u63d0\u73b0\u6d41\u6c34\u5bf9\u8d26-verifyDjpTiXianFlow");
        boolean lockFlag = this.cacheService.setIfAbsent(VerifyTaskTypeEnum.DJB_TI_XIAN.getKey(), (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u5bf9\u8d26\u3011\u767b\u8bb0\u7c3f\u63d0\u73b0\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u5668\u542f\u52a8");
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                Calendar cad = Calendar.getInstance();
                cad.add(5, -2);
                this.verifyTradeResultService.verifyDjpTiXianFlow(format.format(cad.getTime()));
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getTixianList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".verifyDjpTiXianFlow\u3010\u767b\u8bb0\u7c3f-\u63d0\u73b0\u6d41\u6c34\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u767b\u8bb0\u7c3f\u63d0\u73b0\u6d41\u6c34\u5bf9\u8d26-verifyDjpTiXianFlow\u9519\u8bef\u4fe1\u606f\u3011\uff1a", (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(VerifyTaskTypeEnum.DJB_TI_XIAN.getKey());
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u767b\u8bb0\u7c3f\u63d0\u73b0\u6d41\u6c34\u5bf9\u8d26-verifyDjpTiXianFlow");
    }

    @Scheduled(cron="${jobs.crons.verifyBalanceDetail}")
    public void verifyBalanceDetail() {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u767b\u8bb0\u7c3f\u94b1\u5305\u4f59\u989d\u5bf9\u8d26-verifyBalanceDetail");
        boolean lockFlag = this.cacheService.setIfAbsent(VerifyTaskTypeEnum.DJB_BALANCE.getKey(), (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u767b\u8bb0\u7c3f\u94b1\u5305\u4f59\u989d\u5bf9\u8d26\u3011\u767b\u8bb0\u7c3f\u94b1\u5305\u4f59\u989d\u5bf9\u8d26\u5b9a\u65f6\u5668\u542f\u52a8");
                this.verifyBalanceDetailService.verifyBalanceDetail(this.getVerifyDate());
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getQianbaoList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".verifyBalanceDetail\u3010\u767b\u8bb0\u7c3f-\u94b1\u5305\u4f59\u989d\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u767b\u8bb0\u7c3f\u94b1\u5305\u4f59\u989d\u5bf9\u8d26-verifyBalanceDetail\u9519\u8bef\u4fe1\u606f\u3011\uff1a", (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(VerifyTaskTypeEnum.DJB_BALANCE.getKey());
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u767b\u8bb0\u7c3f\u94b1\u5305\u4f59\u989d\u5bf9\u8d26-verifyBalanceDetail");
    }

    @Scheduled(cron="0 10 0 * * ?")
    public void verifyRecord() throws Exception {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u5bf9\u8d26\u4efb\u52a1\u8bb0\u5f55\u751f\u6210-verifyRecord");
        boolean lockFlag = this.cacheService.setIfAbsent("RESULT_WFTPAY_LOCK", (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u5bf9\u8d26\u3011\u5bf9\u8d26\u4efb\u52a1\u8bb0\u5f55\u751f\u6210\u5b9a\u65f6\u5668\u542f\u52a8");
                this.taskService.verifyRecord();
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getWftPayList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".verifyRecord\u3010\u5bf9\u8d26\u8bb0\u5f55\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u5bf9\u8d26\u4efb\u52a1\u8bb0\u5f55\u751f\u6210-verifyRecord\u9519\u8bef\u4fe1\u606f\u3011\uff1a" + e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache("RESULT_WFTPAY_LOCK");
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u5bf9\u8d26\u4efb\u52a1\u8bb0\u5f55\u751f\u6210-verifyRecord");
    }

    @Scheduled(cron="${jobs.crons.dealDuanKuanBill}")
    public void dealDuanKuanBill() {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u7ed3\u7b97\u5355\u5904\u7406\u77ed\u6b3e-dealDuanKuanBill");
        boolean lockFlag = this.cacheService.setIfAbsent("JSD_DEAL_DUANKAUN", (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u3010\u7ed3\u7b97\u5355\u5904\u7406\u77ed\u6b3e\u3011\u7ed3\u7b97\u5355\u5904\u7406\u77ed\u6b3e\u5b9a\u65f6\u5668\u542f\u52a8");
                this.dealBillService.dealDuanKuanBill();
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getQianbaoList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".dealDuanKuanBill\u3010\u7ed3\u7b97\u5355-\u5904\u7406\u77ed\u6b3e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u7ed3\u7b97\u5355\u5904\u7406\u77ed\u6b3e-dealDuanKuanBill\u9519\u8bef\u4fe1\u606f\u3011\uff1a", (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache("JSD_DEAL_DUANKAUN");
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u7ed3\u7b97\u5355\u5904\u7406\u77ed\u6b3e-dealDuanKuanBill");
    }

    private String getVerifyDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar cad = Calendar.getInstance();
        cad.add(5, -1);
        return format.format(cad.getTime());
    }

    @Deprecated
    private List<String> getVerifyDateList(Integer taskType) {
        ArrayList<String> verifyDateList = new ArrayList<String>();
        DateTimeFormatter dFromer = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate today = LocalDate.now();
        if (VerifyTaskTypeEnum.DJB_TI_XIAN.getCode().equals(taskType)) {
            today = today.plusDays(-1L);
        }
        for (int i = 0; i < 3; ++i) {
            today = today.plusDays(-1L);
            verifyDateList.add(today.format(dFromer));
        }
        return verifyDateList;
    }
}

