/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SettlementRoutingDisposeEvent")
@Scope(value="prototype")
public class SettlementRoutingDisposeEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SettlementRoutingDisposeEvent.class);
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private IShareBenefitService shareBenefitService;
    @Resource
    private DingdingSender dingdingSender;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.doExecute();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private void doExecute() {
        logger.info("N+1\u7ed3\u7b97\u5206\u8d26\u7ed3\u679c\u5904\u7406\u8c03\u5ea6\u4efb\u52a1");
        List<TradeSettlementFlowRespDto> tradeSettlementFlowRespDtoList = this.tradeSettlementFlowService.queryStayDisposeRoutingFlow();
        logger.info("N+1\u7ed3\u7b97\u5206\u8d26\u7ed3\u679c\u5904\u7406\u8c03\u5ea6\u4efb\u52a1\uff0c\u5f85\u5904\u7406\u4ea4\u6613\u6d41\u6c34\uff1a{}", (Object)JSON.toJSONString(tradeSettlementFlowRespDtoList));
        if (CollectionUtils.isNotEmpty(tradeSettlementFlowRespDtoList)) {
            tradeSettlementFlowRespDtoList.forEach(trade -> {
                try {
                    this.shareBenefitService.unifyShareBenefitDispose(trade.getId());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.scheduled.SettlementRoutingEvent\uff0c\u7ed3\u7b97\u5206\u8d26\u7ed3\u679c\u5904\u7406\u8c03\u5ea6\u4efb\u52a1\u5f02\u5e38\uff1a" + trade.getId());
                }
            });
            return;
        }
        logger.info("\u7ed3\u7b97\u5206\u8d26\u7ed3\u679c\u5904\u7406\u8c03\u5ea6\u4efb\u52a1\uff0c\u65e0\u9700\u8981\u5904\u7406\u7684\u4ea4\u6613");
    }
}

