/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SettlementTradeCallbackCheckEvent")
@Scope(value="prototype")
public class SettlementTradeCallbackCheckEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SettlementTradeCallbackCheckEvent.class);
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private ISettlementService settlementService;
    @Resource
    private DingdingSender dingdingSender;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.doExecute();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private void doExecute() {
        logger.info("\u5728\u7ebf\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u68c0\u67e5\u8c03\u5ea6\u4efb\u52a1");
        List<TradeSettlementFlowRespDto> list = this.tradeSettlementFlowService.queryStayCallbackFlow();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(trade -> {
                try {
                    this.settlementService.tradeCallbackCheck((TradeSettlementFlowRespDto)trade);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.scheduled.SettlementTradeCallbackCheckEvent\uff0c\u4ea4\u6613\u56de\u8c03\u901a\u77e5\u68c0\u67e5\u8c03\u5ea6\u4efb\u52a1\u5f02\u5e38\uff1a" + trade.getId());
                }
            });
            return;
        }
        logger.info("\u5728\u7ebf\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u68c0\u67e5\u8c03\u5ea6\u4efb\u52a1\uff0c\u65e0\u4ea4\u6613\u9700\u8981\u5904\u7406");
    }
}

