/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.tcbj.center.settlement.api.constant.PayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowRefundTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.RefundParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.config.PayCommonConfig;
import com.dtyunxi.tcbj.center.settlement.biz.config.SettlementCommonConfig;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaySettlementHelperAbstract;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayRefundService
extends PaySettlementHelperAbstract<RefundParamReqDto> {
    private Logger logger = LoggerFactory.getLogger(PayRefundService.class);
    public static final int BALANCE = 1;
    public static final int ONLINE = 2;
    @Resource
    private SettlementAccountOptService settlementAccountOptService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private ILockService lockService;
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private ICreateTradeService createTradeService;
    @Resource
    private SettlementCommonConfig settlementCommonConfig;
    @Resource
    private PayCommonConfig payCommonConfig;
    @Resource
    private IShareBenefitService shareBenefitService;
    @Resource
    private DingdingSender dingdingSender;

    @Override
    public TradeBaseResponse<RefundParamReqDto> executeProcess(RefundParamReqDto refundParamReqDto) {
        this.logger.info("\u5df2\u5f03\u7528\uff01");
        return null;
    }

    @Override
    public TradeBaseResponse<RefundParamReqDto> checkAndBuild(RefundParamReqDto dto) {
        this.logger.info("\u3010\u652f\u4ed8\u9000\u6b3e\u3011\u68c0\u67e5\u5e76\u6784\u5efa\u6279\u91cf\u652f\u4ed8\u9000\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        String refundNo = TradeUtil.generateRefundNo(dto.getOrderNo());
        TradeSettlementFlowReqDto flowParam = new TradeSettlementFlowReqDto();
        flowParam.setOptTradeNo(refundNo);
        flowParam.setTradeType(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
        List<TradeSettlementFlowRespDto> refundList = this.tradeSettlementFlowService.queryList(flowParam);
        if (CollectionUtil.isNotEmpty(refundList)) {
            for (TradeSettlementFlowRespDto respDto : refundList) {
                if (respDto.getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                    throw new BizException(SettlementExceptionCode.ORDER_REFUND_SUCCESS.getCode(), SettlementExceptionCode.ORDER_REFUND_SUCCESS.getMsg());
                }
                if (!respDto.getTradeStatus().equals(SettlementFlowTradeStatusEnum.ACCEPT.getCode())) continue;
                throw new BizException(SettlementExceptionCode.ORDER_REFUND_ING.getCode(), SettlementExceptionCode.ORDER_REFUND_ING.getMsg());
            }
        }
        flowParam = new TradeSettlementFlowReqDto();
        flowParam.setOptTradeNo(dto.getOrderNo());
        List<TradeSettlementFlowRespDto> formerList = this.tradeSettlementFlowService.queryList(flowParam);
        if (CollectionUtil.isEmpty(formerList)) {
            throw new BizException(SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getMsg());
        }
        formerList.forEach(flow -> {
            if (flow.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY.getCode()) && flow.getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                dto.setFormerTradeFlow(flow);
            }
            if (flow.getTradeType().equals(SettlementFlowTradeTypeEnum.ROUTING.getCode()) && !flow.getTradeStatus().equals(SettlementFlowTradeStatusEnum.FAIL.getCode()) && !flow.getTradeStatus().equals(SettlementFlowTradeStatusEnum.CLOSED.getCode())) {
                throw new BizException(SettlementExceptionCode.ORDER_ROUTING_ING.getCode(), SettlementExceptionCode.ORDER_ROUTING_ING.getMsg());
            }
        });
        if (ObjectUtils.isEmpty((Object)dto.getFormerTradeFlow())) {
            this.logger.error(JSON.toJSONString((Object)flowParam));
            throw new BizException(SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT.getMsg());
        }
        dto.setPaymentType(Integer.valueOf(this.getPayType(dto.getFormerTradeFlow().getTradePayType())));
        TradeSettlementFlowReqDto tradeFlowParam = new TradeSettlementFlowReqDto();
        tradeFlowParam.setOptAccountNo(dto.getFormerTradeFlow().getOptAccountNo());
        tradeFlowParam.setOptAccountName(dto.getFormerTradeFlow().getOptAccountName());
        tradeFlowParam.setOptAccountType(dto.getFormerTradeFlow().getOptAccountType());
        tradeFlowParam.setSettlementAccountNo(dto.getFormerTradeFlow().getSettlementAccountNo());
        tradeFlowParam.setSettlementAccountName(dto.getFormerTradeFlow().getSettlementAccountName());
        tradeFlowParam.setSettlementAccountType(dto.getFormerTradeFlow().getSettlementAccountType());
        tradeFlowParam.setOptTradeNo(refundNo);
        tradeFlowParam.setLaunchTradeAmount(dto.getFormerTradeFlow().getLaunchTradeAmount());
        tradeFlowParam.setTradeAmount(dto.getFormerTradeFlow().getTradeAmount());
        tradeFlowParam.setTradePoundage(dto.getFormerTradeFlow().getTradePoundage());
        tradeFlowParam.setTradePoundageRate(dto.getFormerTradeFlow().getTradePoundageRate());
        tradeFlowParam.setRefundType(dto.getRefundType());
        dto.setTradeFlowParam(tradeFlowParam);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<RefundParamReqDto> before(RefundParamReqDto dto) {
        this.logger.info("\u3010\u652f\u4ed8\u9000\u6b3e\u3011\u65b0\u589e\u9000\u6b3e\u4ea4\u6613\uff0c\u51bb\u7ed3\u5728\u9014\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.getTradeFlowParam().setTradeType(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
        dto.getTradeFlowParam().setTradeStatus(SettlementFlowTradeStatusEnum.CREATED.getCode());
        dto.getTradeFlowParam().setTradeEntireStatus(SettlementTradeEntireStatusEnum.NOTSTART.getCode());
        TradeSettlementFlowEo tradeFlow = super.createTradeFlow(dto);
        TradeSettlementFlowRespDto respDto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)tradeFlow, (BaseVo)respDto);
        dto.setTradeFlow(respDto);
        ArrayList<SettlementAccountFlowRespDto> flowList = new ArrayList<SettlementAccountFlowRespDto>();
        AccountOptReqDto freezeOrderAmount = new AccountOptReqDto();
        freezeOrderAmount.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
        freezeOrderAmount.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES_REFUND.getCode());
        freezeOrderAmount.setChangeBalance(dto.getTradeFlow().getLaunchTradeAmount());
        freezeOrderAmount.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
        freezeOrderAmount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
        freezeOrderAmount.setLinkedTradeNo(tradeFlow.getTradeNo());
        freezeOrderAmount.setLinkedParentTradeNo(tradeFlow.getParentTradeNo());
        freezeOrderAmount.setRouteFrozen(freezeOrderAmount.getChangeBalance());
        freezeOrderAmount.setType(Integer.valueOf(1));
        flowList.add(this.settlementAccountOptService.optAccountFrozen(freezeOrderAmount));
        if (ObjectUtils.isNotEmpty((Object)dto.getTradeFlow().getTradePoundage()) && dto.getTradeFlow().getTradePoundage().compareTo(BigDecimal.ZERO) > 0) {
            AccountOptReqDto freezeFeeAmount = new AccountOptReqDto();
            freezeFeeAmount.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
            freezeFeeAmount.setAccountFlowType(SettlementAccountFlowTypeEnum.CLIENT_FEE_RETURN.getCode());
            freezeFeeAmount.setChangeBalance(dto.getTradeFlow().getTradePoundage());
            freezeFeeAmount.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
            freezeFeeAmount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
            freezeFeeAmount.setLinkedTradeNo(tradeFlow.getTradeNo());
            freezeFeeAmount.setLinkedParentTradeNo(tradeFlow.getParentTradeNo());
            freezeFeeAmount.setRouteFrozen(freezeOrderAmount.getChangeBalance());
            freezeFeeAmount.setType(Integer.valueOf(1));
            flowList.add(this.settlementAccountOptService.optAccountFrozen(freezeFeeAmount));
        }
        dto.setSettlementAccountFlowList(flowList);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<RefundParamReqDto> run(RefundParamReqDto dto) {
        this.logger.info("\u3010\u652f\u4ed8\u9000\u6b3e\u3011\u66f4\u65b0\u9000\u6b3e\u4ea4\u6613\u6d41\u6c34\uff0c\u7533\u8bf7\u7b2c\u4e09\u65b9\u9000\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowRespDto updateTradeSuccess = new TradeSettlementFlowRespDto();
        updateTradeSuccess.setId(dto.getTradeFlow().getId());
        updateTradeSuccess.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        updateTradeSuccess.setTradePaidAmount(dto.getTradeFlow().getTradeAmount());
        super.updateTradeFlow(updateTradeSuccess, SettlementFlowTradeStatusEnum.CREATED.getCode());
        if (dto.getPaymentType() == 2 && dto.getTradeFlow().getRefundType().intValue() == SettlementFlowRefundTypeEnum.ORIGINAL.getCode().intValue()) {
            TradeSettlementFlowEo updateEo;
            block5: {
                updateEo = new TradeSettlementFlowEo();
                updateEo.setId(dto.getTradeFlow().getId());
                RefundRequest refundRequest = new RefundRequest();
                refundRequest.setTradeId(dto.getTradeFlow().getFormerPayBalancetradeId());
                refundRequest.setStoreRefundId(dto.getTradeFlow().getTradeNo());
                refundRequest.setStoreOrderId(dto.getTradeFlow().getFormerParentTradeNo());
                refundRequest.setStoreId(dto.getTradeFlow().getTradePayStoreCode());
                refundRequest.setAppId(dto.getTradeFlow().getTradePayAppCode());
                refundRequest.setRefundAmt(dto.getTradeFlow().getTradeAmount());
                refundRequest.setUserId(dto.getTradeFlow().getLaunchUserId());
                refundRequest.setNotifyUrl(this.payCommonConfig.getOnlinePayRefundNotifyUrl());
                refundRequest.setReason(dto.getReason());
                refundRequest.setSign(this.settlementCommonConfig.getSign(refundRequest));
                try {
                    this.logger.info("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\uff1a{}", (Object)JSONObject.toJSONString((Object)refundRequest));
                    RefundResponse refundResponse = this.createTradeService.createRefundOrder(refundRequest);
                    this.logger.info("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)refundResponse));
                    dto.getTradeFlow().setTradePayTradeId(refundResponse.getRefundId());
                    updateEo.setTradePayTradeId(refundResponse.getRefundId());
                    if (refundResponse.getResultCode().equals("0")) {
                        if (!refundResponse.getResult().equals(PayEnum.ACCEPT.getCode())) {
                            throw new BizException("-1", "\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u5931\u8d25");
                        }
                        break block5;
                    }
                    throw new BizException(SettlementExceptionCode.ORDER_REFUND_ING.getCode(), SettlementExceptionCode.ORDER_REFUND_ING.getMsg());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    throw new BizException("-1", "\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
            this.tradeSettlementFlowDas.updateSelective((BaseEo)updateEo);
        }
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<RefundParamReqDto> after(RefundParamReqDto dto) {
        this.logger.info("\u3010\u652f\u4ed8\u9000\u6b3e\u3011\u66f4\u65b0\u9000\u6b3e\u4ea4\u6613\u6d41\u6c34\uff0c\u8fdb\u884c\u91d1\u989d\u7ed3\u7b97\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.setPaymentType(Integer.valueOf(this.getPayType(dto.getFormerTradeFlow().getTradePayType())));
        TradeSettlementFlowRespDto updateTradeSuccess = new TradeSettlementFlowRespDto();
        updateTradeSuccess.setId(dto.getTradeFlow().getId());
        updateTradeSuccess.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        updateTradeSuccess.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        updateTradeSuccess.setTradeEntireSucTime(new Date());
        updateTradeSuccess.setTradePayFinishTime(dto.getTradeFlow().getTradePayFinishTime());
        super.updateTradeFlow(updateTradeSuccess, SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        dto.getSettlementAccountFlowList().forEach(flow -> {
            AccountOptReqDto releaseAmount = new AccountOptReqDto();
            releaseAmount.setAccountFlowNoId(flow.getId());
            releaseAmount.setAccountNo(flow.getAccountNo());
            releaseAmount.setRouteFrozen(flow.getChangeBalance());
            releaseAmount.setType(Integer.valueOf(-1));
            releaseAmount.setRouteBalance(flow.getChangeBalance());
            this.settlementAccountOptService.optAccountUpdate(releaseAmount);
        });
        if (dto.getPaymentType() == 2 && dto.getTradeFlow().getRefundType().equals(SettlementFlowRefundTypeEnum.OFFLINE_BALANCE.getCode())) {
            this.logger.info("\u9694\u5929\u9000\u6b3e\u9700\u5c06\u5728\u6d82\u6b3e\u8f6c\u4f59\u989d\uff1a{}", (Object)JSON.toJSONString((Object)dto.getTradeFlow()));
            BigDecimal total = dto.getTradeFlow().getTradeAmount().subtract(dto.getTradeFlow().getTradePayParnterPoundage());
            AccountOptReqDto buyerOptReqDto = new AccountOptReqDto();
            buyerOptReqDto.setAccountNo(((SettlementAccountFlowRespDto)dto.getSettlementAccountFlowList().get(0)).getAccountNo());
            buyerOptReqDto.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES_NEXT_REFUND.getCode());
            buyerOptReqDto.setChangeBalance(total);
            buyerOptReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
            buyerOptReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
            buyerOptReqDto.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
            buyerOptReqDto.setLinkedParentTradeNo(dto.getTradeFlow().getParentTradeNo());
            buyerOptReqDto.setBalance(buyerOptReqDto.getChangeBalance());
            buyerOptReqDto.setType(Integer.valueOf(1));
            this.settlementAccountOptService.optAccountFinish(buyerOptReqDto);
        }
        if (dto.getPaymentType() == 1) {
            this.logger.info("\u82e5\u4e3a\u4f59\u989d\u652f\u4ed8\uff0c\u5219\u9700\u8981\u66f4\u65b0\u5ba2\u6237\u8d26\u6237\uff0c\u9000\u8fd8\u4f59\u989d\uff1a{}", (Object)JSON.toJSONString((Object)dto.getTradeFlow()));
            AccountOptReqDto buyerOptReqDto = new AccountOptReqDto();
            buyerOptReqDto.setAccountNo(dto.getTradeFlow().getOptAccountNo());
            buyerOptReqDto.setAccountFlowType(SettlementAccountFlowTypeEnum.ORDER_GOODS_REFUND.getCode());
            buyerOptReqDto.setChangeBalance(dto.getTradeFlow().getTradeAmount());
            buyerOptReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
            buyerOptReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
            buyerOptReqDto.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
            buyerOptReqDto.setLinkedParentTradeNo(dto.getTradeFlow().getParentTradeNo());
            buyerOptReqDto.setBalance(dto.getTradeFlow().getTradeAmount());
            buyerOptReqDto.setType(Integer.valueOf(1));
            this.settlementAccountOptService.optAccountFinish(buyerOptReqDto);
        }
        TradeSettlementFlowEo formerTradeFlowEo = new TradeSettlementFlowEo();
        formerTradeFlowEo.setId(dto.getFormerTradeFlow().getId());
        formerTradeFlowEo.setRefundAmount(dto.getTradeFlow().getTradePaidAmount());
        this.tradeSettlementFlowDas.updateSelective((BaseEo)formerTradeFlowEo);
        TradeSettlementFlowRespDto refundFlow = this.tradeSettlementFlowService.queryById(dto.getTradeFlow().getId());
        if (dto.getPaymentType() == 2 && dto.getTradeFlow().getRefundType().intValue() == SettlementFlowRefundTypeEnum.ORIGINAL.getCode().intValue()) {
            try {
                this.shareBenefitService.uploadRefundShareBenefit(dto.getFormerTradeFlow(), refundFlow);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        dto.setTradeFlow(refundFlow);
        return new TradeBaseResponse((Object)dto);
    }

    private TradeBaseResponse<RefundParamReqDto> interceptRefund(RefundParamReqDto dto) {
        this.logger.info("\u62e6\u622a\u5728\u7ebf\u652f\u4ed8\uff0c\u4e14\u975e\u5f53\u5929\u652f\u4ed8\u7684\u9000\u6b3e\u8bf7\u6c42\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        TradeBaseResponse response = new TradeBaseResponse();
        if (ObjectUtils.isNotEmpty((Object)dto.getFormerTradeFlow().getTradePayFinishTime())) {
            String payDate;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String nowDate = dateFormat.format(new Date());
            if (nowDate.equals(payDate = dateFormat.format(dto.getFormerTradeFlow().getTradePayFinishTime()))) {
                response.setGlobalResultCode("-1");
                return response;
            }
            response.setGlobalResultCode("0");
            return response;
        }
        this.logger.info("\u652f\u4ed8\u6d41\u6c34\u6570\u636e\u5f02\u5e38\uff0c\u6ca1\u6709\u652f\u4ed8\u65f6\u95f4");
        response.setGlobalResultCode("0");
        return response;
    }

    private int getPayType(String tradePayType) {
        if (tradePayType.equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
            return 1;
        }
        return 2;
    }
}

