/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.tcbj.center.settlement.api.constant.PayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.TradeSettlementCloseStatusTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.LaunchSettlementReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PayNotifyReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentBatchParamBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentOrderReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.config.PayCommonConfig;
import com.dtyunxi.tcbj.center.settlement.biz.config.SettlementCommonConfig;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.mq.PayOrderMqProducerService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaySettlementHelperAbstract;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentBatchOfOnlineService
extends PaySettlementHelperAbstract<PaymentBatchParamBaseDto> {
    private Logger logger = LoggerFactory.getLogger(PaymentBatchOfOnlineService.class);
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private ILockService lockService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private PayCommonConfig payCommonConfig;
    @Resource
    private SettlementCommonConfig settlementCommonConfig;
    @Resource
    private ICreateTradeService createTradeService;
    @Resource
    private SettlementAccountOptService settlementAccountOptService;
    @Resource
    private PayOrderMqProducerService payOrderMqProducerService;
    @Resource
    private IShareBenefitService shareBenefitService;
    @Resource
    private PaymentBatchOfOnlineService paymentBatchOfOnlineService;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ISettlementService settlementService;
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> checkAndBuild(PaymentBatchParamBaseDto paymentBatchParamBaseDto) {
        this.logger.info("\u3010\u5728\u7ebf\u652f\u4ed8\u3011checkAndBuild\uff0c\u68c0\u67e5\u5e76\u6784\u5efa\u6279\u91cf\u5728\u7ebf\u652f\u4ed8\uff1a{}", (Object)JSON.toJSONString((Object)paymentBatchParamBaseDto));
        paymentBatchParamBaseDto = super.calculateTradeAmount(paymentBatchParamBaseDto);
        for (PaymentOrderReqDto paymentOrder : paymentBatchParamBaseDto.getPaymentOrderList()) {
            super.checkOrderIfPay(paymentOrder.getOrderNo());
            super.checkAccount(paymentOrder.getRecordedAccount(), 2);
        }
        return new TradeBaseResponse((Object)paymentBatchParamBaseDto);
    }

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> executeProcess(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u5df2\u5f03\u7528\uff01");
        return null;
    }

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> before(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u3010\u5728\u7ebf\u652f\u4ed8\u3011before\uff0c\u521b\u5efa\u652f\u4ed8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.setParentOrderNo(TradeUtil.generateTradeParentFlowNo());
        ArrayList<TradeSettlementFlowEo> createTradeFlowEoList = new ArrayList<TradeSettlementFlowEo>();
        for (PaymentOrderReqDto paymentOrder : dto.getPaymentOrderList()) {
            TradeSettlementFlowEo eo = super.buildCreatePayTradeFlow(paymentOrder, dto);
            createTradeFlowEoList.add(eo);
        }
        List<TradeSettlementFlowRespDto> tradeFlowList = super.batchCreateTradeFlow(createTradeFlowEoList);
        dto.setTradeFlowList(tradeFlowList);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> run(PaymentBatchParamBaseDto dto) {
        String tradePayTradeId;
        this.logger.info("\u3010\u5728\u7ebf\u652f\u4ed8\u3011run\uff0c\u4fee\u6539\u652f\u4ed8\u4ea4\u6613\u4e3a\u53d7\u7406\uff0c\u83b7\u53d6\u53d1\u8d77\u652f\u4ed8\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeBaseResponse response = new TradeBaseResponse();
        List<String> tradeNoList = dto.getTradeFlowList().stream().map(TradeSettlementFlowRespDto::getTradeNo).collect(Collectors.toList());
        TradeSettlementFlowReqDto reqDto = new TradeSettlementFlowReqDto();
        reqDto.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        super.batchUpdateTradeFlow(reqDto, tradeNoList, SettlementFlowTradeStatusEnum.CREATED.getCode());
        try {
            PayRequest payRequest = new PayRequest();
            payRequest.setStoreOrderId(dto.getParentOrderNo());
            payRequest.setOrderAmt(dto.getTradeTotalAmount());
            payRequest.setPayTypeId(dto.getPaymentWayReqDto().getPayTypeCode());
            payRequest.setStoreId(dto.getPaymentWayReqDto().getStoreCode());
            payRequest.setAppId(dto.getPaymentWayReqDto().getAppCode());
            payRequest.setAppName(dto.getPaymentWayReqDto().getAppName());
            payRequest.setUserId(dto.getUserId().toString());
            payRequest.setExpireTime(this.payCommonConfig.getTimeout());
            payRequest.setNotifyUrl(this.payCommonConfig.getBatchOnlinePayNotifyUrl());
            payRequest.setPtUserId(dto.getPaymentWayReqDto().getOpenId());
            payRequest.setSign(this.settlementCommonConfig.getSign(payRequest));
            this.logger.info(">>>>>>>>>\u8bf7\u6c42\u5728\u7ebf\u652f\u4ed8\uff1a{}", (Object)JSONObject.toJSONString((Object)payRequest));
            PayResponse payResponse = this.createTradeService.createPayOrder(payRequest);
            this.logger.info(">>>>>>>>>\u8bf7\u6c42\u5728\u7ebf\u652f\u4ed8\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)payResponse));
            tradePayTradeId = payResponse.getTradeId();
            if (PayEnum.ACCEPT.getCode().equals(payResponse.getResult())) {
                response.setGlobalResultCode(PayEnum.SUCCESS.getCode());
                response.setGlobalResulData(payResponse.getData());
            } else {
                response.setGlobalResultCode(PayEnum.FAIL.getCode());
                response.setGlobalResultMsg(payResponse.getResultMsg());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("\u53d1\u8d77\u5728\u7ebf\u652f\u4ed8\u5f02\u5e38\uff01\u3010" + e.getMessage() + "\u3011");
        }
        TradeSettlementFlowReqDto flowReqDto = new TradeSettlementFlowReqDto();
        flowReqDto.setTradePayTradeId(tradePayTradeId);
        if (!response.getGlobalResultCode().equals(PayEnum.SUCCESS.getCode())) {
            flowReqDto.setTradeStatus(SettlementFlowTradeStatusEnum.CLOSED.getCode());
            flowReqDto.setCloseStatusType(TradeSettlementCloseStatusTypeEnum.LAUNCH_PAY_FAIL.getCode());
        }
        super.batchUpdateTradeFlow(flowReqDto, tradeNoList, null);
        return response;
    }

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> after(PaymentBatchParamBaseDto dto) {
        this.logger.info("PaymentBatchOfOnlineService.after\u5165\u53c2={}", (Object)JSON.toJSONString((Object)dto));
        return null;
    }

    public List<TradeSettlementFlowRespDto> callBackCheckAndBuild(PayNotifyReqDto dto) {
        this.logger.info("\u3010\u5728\u7ebf\u652f\u4ed8\u3011\u5904\u7406\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowEo tradeFlowParam = new TradeSettlementFlowEo();
        tradeFlowParam.setParentTradeNo(dto.getStoreOrderId());
        tradeFlowParam.setTradePayTradeId(dto.getTradeId());
        tradeFlowParam.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        tradeFlowParam.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
        List tradeFlowList = this.tradeSettlementFlowDas.select((BaseEo)tradeFlowParam);
        if (CollectionUtil.isEmpty((Collection)tradeFlowList)) {
            throw new BizException(SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getMsg());
        }
        ArrayList tradeList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)tradeFlowList, tradeList, TradeSettlementFlowRespDto.class);
        ArrayList<TradeSettlementFlowRespDto> dealTradeList = new ArrayList<TradeSettlementFlowRespDto>();
        for (TradeSettlementFlowRespDto tradeFlow : tradeList) {
            if (dto.getOrderStatus().equals("S") && super.checkOrderIfPayRes(tradeFlow.getOptTradeNo())) {
                try {
                    tradeFlow.setTradeStatus(SettlementFlowTradeStatusEnum.CLOSED.getCode());
                    tradeFlow.setCloseStatusType(TradeSettlementCloseStatusTypeEnum.REPEAT.getCode());
                    tradeFlow.setTradePayFinishTime(dto.getFinishTime());
                    tradeFlow.setTradePayTradeChannelId(dto.getPartnerOrderId());
                    tradeFlow.setTradeEntireSucTime(new Date());
                    tradeFlow.setTradePaidAmount(tradeFlow.getTradeAmount());
                    TradeSettlementFlowRespDto updateDipFlow = new TradeSettlementFlowRespDto();
                    updateDipFlow.setTradeStatus(SettlementFlowTradeStatusEnum.CLOSED.getCode());
                    updateDipFlow.setCloseStatusType(TradeSettlementCloseStatusTypeEnum.REPEAT.getCode());
                    updateDipFlow.setTradePayFinishTime(dto.getFinishTime());
                    updateDipFlow.setTradePayTradeChannelId(dto.getPartnerOrderId());
                    updateDipFlow.setTradeEntireSucTime(new Date());
                    updateDipFlow.setTradePaidAmount(tradeFlow.getTradeAmount());
                    updateDipFlow.setId(tradeFlow.getId());
                    super.updateTradeFlow(updateDipFlow, null);
                    this.logger.error("\u51fa\u73b0\u91cd\u590d\u652f\u4ed8\uff1a{}", (Object)JSON.toJSONString((Object)tradeFlow));
                    this.shareBenefitService.uploadPayShareBenefit(tradeFlow);
                    ExecutorUtils.execute(() -> {
                        LaunchSettlementReqDto reqDto = new LaunchSettlementReqDto();
                        reqDto.setOrderNo(tradeFlow.getOptTradeNo());
                        reqDto.setReason("\u91cd\u590d\u652f\u4ed8\uff0c\u7533\u8bf7\u9000\u6b3e");
                        reqDto.setStartTime(new Date());
                        reqDto.setUserId(Long.valueOf(dto.getUserId()));
                        this.logger.info("\u91cd\u590d\u652f\u4ed8\uff0c\u5f02\u6b65\u7533\u8bf7\u9000\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
                        this.settlementService.refundOfBacktrack(reqDto);
                    });
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfOnlineService.callBack\u6279\u91cf\u5728\u7ebf\u652f\u4ed8\u56de\u8c03\uff0c\u5904\u7406\u91cd\u590d\u652f\u4ed8\u5f02\u5e38\uff1a" + e.getMessage());
                }
                continue;
            }
            dealTradeList.add(tradeFlow);
        }
        return dealTradeList;
    }

    @Transactional(rollbackFor={Exception.class})
    public TradeSettlementFlowRespDto updateSuccessCallBack(TradeSettlementFlowRespDto trade, PayNotifyReqDto dto) {
        this.logger.info("\u3010\u5728\u7ebf\u652f\u4ed8\u3011\u5904\u7406\u56de\u8c03\u652f\u4ed8\u6210\u529f\uff0c\u589e\u52a0\u5728\u9014\u6b3e\uff0c\u5b8c\u6210\u652f\u4ed8\u4ea4\u6613\uff1a{}=={}", (Object)JSON.toJSONString((Object)trade), JSON.toJSON((Object)dto));
        TradeSettlementFlowRespDto updateTradeSuccessDto = new TradeSettlementFlowRespDto();
        updateTradeSuccessDto.setId(trade.getId());
        updateTradeSuccessDto.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        updateTradeSuccessDto.setTradePayTradeChannelId(dto.getPartnerOrderId());
        super.updateTradeFlow(updateTradeSuccessDto, SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        SettlementAccountRespDto account = this.settlementAccountService.queryByAccountNo(trade.getSettlementAccountNo());
        if (ObjectUtils.isEmpty((Object)account)) {
            this.logger.error("\u83b7\u53d6\u7ed3\u7b97\u8d26\u6237\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)trade));
            throw new BizException("-1", "\u83b7\u53d6\u7ed3\u7b97\u8d26\u6237\u5f02\u5e38");
        }
        AccountOptReqDto addOrderAmount = new AccountOptReqDto();
        addOrderAmount.setAccountNo(trade.getSettlementAccountNo());
        addOrderAmount.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES.getCode());
        addOrderAmount.setChangeBalance(trade.getLaunchTradeAmount());
        addOrderAmount.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
        addOrderAmount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
        addOrderAmount.setLinkedTradeNo(trade.getTradeNo());
        addOrderAmount.setLinkedParentTradeNo(trade.getParentTradeNo());
        addOrderAmount.setRouteBalance(addOrderAmount.getChangeBalance());
        addOrderAmount.setType(Integer.valueOf(1));
        String addOrderAmountFlow = this.settlementAccountOptService.optAccountFinish(addOrderAmount);
        if (ObjectUtils.isNotEmpty((Object)trade.getTradePoundage()) && trade.getTradePoundage().compareTo(BigDecimal.ZERO) >= 1) {
            AccountOptReqDto addFeeAmount = new AccountOptReqDto();
            addFeeAmount.setAccountNo(trade.getSettlementAccountNo());
            addFeeAmount.setAccountFlowType(SettlementAccountFlowTypeEnum.CLIENT_FEE.getCode());
            addFeeAmount.setChangeBalance(trade.getTradePoundage());
            addFeeAmount.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
            addFeeAmount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
            addFeeAmount.setLinkedTradeNo(trade.getTradeNo());
            addFeeAmount.setLinkedParentTradeNo(trade.getParentTradeNo());
            addFeeAmount.setRouteBalance(addFeeAmount.getChangeBalance());
            addFeeAmount.setType(Integer.valueOf(1));
            String string = this.settlementAccountOptService.optAccountFinish(addFeeAmount);
        }
        TradeSettlementFlowRespDto updateTradeDto = new TradeSettlementFlowRespDto();
        updateTradeDto.setTradePaidAmount(trade.getTradeAmount());
        updateTradeDto.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        updateTradeDto.setTradeEntireSucTime(new Date());
        updateTradeDto.setTradePayFinishTime(dto.getFinishTime());
        updateTradeDto.setNotifyTradeType(dto.getRemark());
        updateTradeDto.setId(trade.getId());
        super.updateTradeFlow(updateTradeDto, null);
        return this.tradeSettlementFlowService.queryById(trade.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateFailCallBack(List<TradeSettlementFlowRespDto> trades, PayNotifyReqDto dto) {
        this.logger.info("\u3010\u5728\u7ebf\u652f\u4ed8\u3011\u56de\u8c03\u652f\u4ed8\u5931\u8d25\uff0c\u5173\u95ed\u652f\u4ed8\u4ea4\u6613\uff1a{}=={}", (Object)JSON.toJSONString(trades), JSON.toJSON((Object)dto));
        List<String> tradeNoList = trades.stream().map(TradeSettlementFlowRespDto::getTradeNo).collect(Collectors.toList());
        TradeSettlementFlowReqDto updateTradeClose = new TradeSettlementFlowReqDto();
        updateTradeClose.setTradeStatus(SettlementFlowTradeStatusEnum.CLOSED.getCode());
        updateTradeClose.setCloseStatusType(TradeSettlementCloseStatusTypeEnum.PAY_FAIL.getCode());
        updateTradeClose.setTradeEntireSucTime(new Date());
        super.batchUpdateTradeFlow(updateTradeClose, tradeNoList, SettlementFlowTradeStatusEnum.ACCEPT.getCode());
    }
}

